/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.node.NodeManager;

public class ECContainerReplicaCount
implements ContainerReplicaCount {
    private final ContainerInfo containerInfo;
    private final ECReplicationConfig repConfig;
    private final List<Integer> pendingAdd;
    private final List<Integer> pendingDelete;
    private final int remainingMaintenanceRedundancy;
    private final Map<Integer, Integer> healthyIndexes = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> unHealthyIndexes = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> decommissionIndexes = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> maintenanceIndexes = new HashMap<Integer, Integer>();
    private final Set<DatanodeDetails> unhealthyReplicaDNs;
    private final List<ContainerReplica> replicas;

    public ECContainerReplicaCount(ContainerInfo containerInfo, Set<ContainerReplica> replicas, List<ContainerReplicaOp> replicaPendingOps, int remainingMaintenanceRedundancy) {
        this.containerInfo = containerInfo;
        this.replicas = replicas.stream().sorted(Comparator.comparingLong(ContainerReplica::hashCode)).collect(Collectors.toList());
        this.repConfig = (ECReplicationConfig)containerInfo.getReplicationConfig();
        this.pendingAdd = new ArrayList<Integer>();
        this.pendingDelete = new ArrayList<Integer>();
        this.remainingMaintenanceRedundancy = Math.min(this.repConfig.getParity(), remainingMaintenanceRedundancy);
        this.unhealthyReplicaDNs = new HashSet<DatanodeDetails>();
        for (ContainerReplica r : replicas) {
            if (r.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) continue;
            this.unhealthyReplicaDNs.add(r.getDatanodeDetails());
        }
        for (ContainerReplicaOp op : replicaPendingOps) {
            this.processPendingOp(op);
        }
        for (ContainerReplica replica : replicas) {
            int val;
            if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) {
                int val2 = this.unHealthyIndexes.getOrDefault(replica.getReplicaIndex(), 0);
                this.unHealthyIndexes.put(replica.getReplicaIndex(), val2 + 1);
                continue;
            }
            HddsProtos.NodeOperationalState state = replica.getDatanodeDetails().getPersistedOpState();
            int index = replica.getReplicaIndex();
            this.ensureIndexWithinBounds(index, "replicaSet");
            if (state == HddsProtos.NodeOperationalState.DECOMMISSIONED || state == HddsProtos.NodeOperationalState.DECOMMISSIONING) {
                val = this.decommissionIndexes.getOrDefault(index, 0);
                this.decommissionIndexes.put(index, val + 1);
                continue;
            }
            if (state == HddsProtos.NodeOperationalState.IN_MAINTENANCE || state == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE) {
                val = this.maintenanceIndexes.getOrDefault(index, 0);
                this.maintenanceIndexes.put(index, val + 1);
                continue;
            }
            val = this.healthyIndexes.getOrDefault(index, 0);
            this.healthyIndexes.put(index, val + 1);
        }
        for (Integer i : this.pendingDelete) {
            this.adjustHealthyCountWithPendingDelete(i);
        }
    }

    @Override
    public ContainerInfo getContainer() {
        return this.containerInfo;
    }

    @Override
    public List<ContainerReplica> getReplicas() {
        return this.replicas;
    }

    @Override
    public int getDecommissionCount() {
        return this.decommissionIndexes.size();
    }

    @Override
    public int getMaintenanceCount() {
        return this.maintenanceIndexes.size();
    }

    private void processPendingOp(ContainerReplicaOp op) {
        this.ensureIndexWithinBounds(op.getReplicaIndex(), "pending" + (Object)((Object)op.getOpType()));
        if (op.getOpType() == ContainerReplicaOp.PendingOpType.ADD) {
            this.pendingAdd.add(op.getReplicaIndex());
        } else if (op.getOpType() == ContainerReplicaOp.PendingOpType.DELETE && !this.unhealthyReplicaDNs.contains(op.getTarget())) {
            this.pendingDelete.add(op.getReplicaIndex());
        }
    }

    private void adjustHealthyCountWithPendingDelete(int index) {
        Integer count = this.healthyIndexes.get(index);
        if (count != null) {
            if ((count = Integer.valueOf(count - 1)) < 1) {
                this.healthyIndexes.remove(index);
            } else {
                this.healthyIndexes.put(index, count);
            }
        }
    }

    public void addPendingOp(ContainerReplicaOp op) {
        this.processPendingOp(op);
        if (op.getOpType() == ContainerReplicaOp.PendingOpType.DELETE) {
            this.adjustHealthyCountWithPendingDelete(op.getReplicaIndex());
        }
    }

    public Set<Integer> decommissioningIndexes() {
        return this.decommissionIndexes.keySet();
    }

    public Set<Integer> decommissioningOnlyIndexes(boolean includePendingAdd) {
        HashSet<Integer> decommissioningOnlyIndexes = new HashSet<Integer>();
        for (Integer i : this.decommissionIndexes.keySet()) {
            if (this.healthyIndexes.containsKey(i)) continue;
            decommissioningOnlyIndexes.add(i);
        }
        if (includePendingAdd) {
            for (Integer i : this.pendingAdd) {
                decommissioningOnlyIndexes.remove(i);
            }
        }
        return decommissioningOnlyIndexes;
    }

    public Set<Integer> maintenanceIndexes() {
        return this.maintenanceIndexes.keySet();
    }

    public Set<Integer> maintenanceOnlyIndexes(boolean includePendingAdd) {
        HashSet<Integer> maintenanceOnlyIndexes = new HashSet<Integer>();
        for (Integer i : this.maintenanceIndexes.keySet()) {
            if (this.healthyIndexes.containsKey(i)) continue;
            maintenanceOnlyIndexes.add(i);
        }
        if (includePendingAdd) {
            for (Integer i : this.pendingAdd) {
                maintenanceOnlyIndexes.remove(i);
            }
        }
        return maintenanceOnlyIndexes;
    }

    @Override
    public boolean isUnrecoverable() {
        Set<Integer> distinct = this.healthyReplicas();
        return distinct.size() < this.repConfig.getData();
    }

    public boolean isMissing() {
        Set<Integer> distinct = this.healthyReplicas();
        distinct.addAll(this.unHealthyIndexes.keySet());
        return distinct.size() < this.repConfig.getData();
    }

    private Set<Integer> healthyReplicas() {
        HashSet<Integer> distinct = new HashSet<Integer>();
        distinct.addAll(this.healthyIndexes.keySet());
        distinct.addAll(this.decommissionIndexes.keySet());
        distinct.addAll(this.maintenanceIndexes.keySet());
        return distinct;
    }

    public List<Integer> unavailableIndexes(boolean includePendingAdd) {
        if (this.isSufficientlyReplicated(false)) {
            return Collections.emptyList();
        }
        HashSet<Integer> missing = new HashSet<Integer>();
        for (int i = 1; i <= this.repConfig.getRequiredNodes(); ++i) {
            if (this.healthyIndexes.containsKey(i)) continue;
            missing.add(i);
        }
        if (includePendingAdd) {
            for (Integer i : this.pendingAdd) {
                missing.remove(i);
            }
        }
        for (Integer i : this.maintenanceIndexes.keySet()) {
            missing.remove(i);
        }
        for (Integer i : this.decommissionIndexes.keySet()) {
            missing.remove(i);
        }
        return new ArrayList<Integer>(missing);
    }

    public int additionalMaintenanceCopiesNeeded(boolean includePendingAdd) {
        Set<Integer> maintenanceOnly = this.maintenanceOnlyIndexes(includePendingAdd);
        return Math.max(0, maintenanceOnly.size() - this.getMaxMaintenance());
    }

    public boolean isOverReplicated(boolean includePendingDelete) {
        Map<Integer, Integer> availableIndexes = this.getHealthyWithDelete(includePendingDelete);
        for (Integer count : availableIndexes.values()) {
            if (count <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOverReplicated() {
        return this.isOverReplicated(false);
    }

    public List<Integer> overReplicatedIndexes(boolean includePendingDelete) {
        Map<Integer, Integer> availableIndexes = this.getHealthyWithDelete(includePendingDelete);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> entry : availableIndexes.entrySet()) {
            if (entry.getValue() <= 1) continue;
            indexes.add(entry.getKey());
        }
        return indexes;
    }

    private Map<Integer, Integer> getHealthyWithDelete(boolean includeDelete) {
        Map<Integer, Integer> availableIndexes;
        if (includeDelete) {
            availableIndexes = Collections.unmodifiableMap(this.healthyIndexes);
        } else {
            availableIndexes = new HashMap<Integer, Integer>(this.healthyIndexes);
            this.pendingDelete.forEach(k -> availableIndexes.merge((Integer)k, 1, Integer::sum));
        }
        return availableIndexes;
    }

    public boolean isSufficientlyReplicated(boolean includePendingAdd) {
        Map<Integer, Integer> onlineIndexes;
        if (includePendingAdd) {
            onlineIndexes = new HashMap<Integer, Integer>(this.healthyIndexes);
            this.pendingAdd.forEach(k -> onlineIndexes.merge((Integer)k, 1, Integer::sum));
        } else {
            onlineIndexes = Collections.unmodifiableMap(this.healthyIndexes);
        }
        if (this.hasFullSetOfIndexes(onlineIndexes)) {
            return true;
        }
        HashMap<Integer, Integer> healthy = new HashMap<Integer, Integer>(onlineIndexes);
        this.maintenanceIndexes.forEach((k, v) -> healthy.merge((Integer)k, (Integer)v, Integer::sum));
        return this.hasFullSetOfIndexes(healthy) && onlineIndexes.size() >= this.repConfig.getData() + this.remainingMaintenanceRedundancy;
    }

    @Override
    public boolean isSufficientlyReplicatedForOffline(DatanodeDetails datanode, NodeManager nodeManager) {
        boolean sufficientlyReplicated = this.isSufficientlyReplicated(false);
        if (sufficientlyReplicated) {
            return true;
        }
        if (datanode.getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE) {
            return false;
        }
        ContainerReplica thisReplica = null;
        for (ContainerReplica r : this.replicas) {
            if (!r.getDatanodeDetails().equals((Object)datanode)) continue;
            thisReplica = r;
            break;
        }
        if (thisReplica == null) {
            return false;
        }
        return this.healthyIndexes.containsKey(thisReplica.getReplicaIndex());
    }

    @Override
    public boolean isHealthyEnoughForOffline() {
        return this.isHealthy();
    }

    @Override
    public boolean isSufficientlyReplicated() {
        return this.isSufficientlyReplicated(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Container State: ").append(this.containerInfo.getState()).append(", Replicas: (Count: ").append(this.replicas.size());
        if (!this.healthyIndexes.isEmpty()) {
            sb.append(", Healthy: ").append(this.healthyIndexes.size());
        }
        if (!this.unhealthyReplicaDNs.isEmpty()) {
            sb.append(", Unhealthy: ").append(this.unhealthyReplicaDNs.size());
        }
        if (!this.decommissionIndexes.isEmpty()) {
            sb.append(", Decommission: ").append(this.decommissionIndexes.size());
        }
        if (!this.maintenanceIndexes.isEmpty()) {
            sb.append(", Maintenance: ").append(this.maintenanceIndexes.size());
        }
        if (!this.pendingAdd.isEmpty()) {
            sb.append(", PendingAdd: ").append(this.pendingAdd.size());
        }
        if (!this.pendingDelete.isEmpty()) {
            sb.append(", PendingDelete: ").append(this.pendingDelete.size());
        }
        sb.append(")").append(", ReplicationConfig: ").append(this.repConfig).append(", RemainingMaintenanceRedundancy: ").append(this.remainingMaintenanceRedundancy);
        return sb.toString();
    }

    private boolean hasFullSetOfIndexes(Map<Integer, Integer> indexSet) {
        return indexSet.size() == this.repConfig.getRequiredNodes();
    }

    private int getMaxMaintenance() {
        return Math.max(0, this.repConfig.getParity() - this.remainingMaintenanceRedundancy);
    }

    private void ensureIndexWithinBounds(Integer index, String setName) {
        if (index < 1 || index > this.repConfig.getRequiredNodes()) {
            throw new IllegalArgumentException("Replica Index in " + setName + " for containerID " + this.containerInfo.getContainerID() + "must be between 1 and " + this.repConfig.getRequiredNodes() + ". But the given index is: " + index);
        }
    }
}

