/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.command;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.HddsIdFactory;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.IdentifiableEventPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandStatusReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.CommandStatusReportFromDatanode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandStatusReportHandler.class);

    public void onMessage(SCMDatanodeHeartbeatDispatcher.CommandStatusReportFromDatanode report, EventPublisher publisher) {
        Preconditions.checkNotNull((Object)report);
        List cmdStatusList = ((StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto)report.getReport()).getCmdStatusList();
        Preconditions.checkNotNull((Object)cmdStatusList);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Processing command status report for dn: {}", (Object)report.getDatanodeDetails());
        }
        ArrayList<StorageContainerDatanodeProtocolProtos.CommandStatus> deleteBlocksCommandStatus = new ArrayList<StorageContainerDatanodeProtocolProtos.CommandStatus>();
        cmdStatusList.forEach(cmdStatus -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Emitting command status for id:{} type: {}", (Object)cmdStatus.getCmdId(), (Object)cmdStatus.getType());
            }
            if (cmdStatus.getType() == StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) {
                deleteBlocksCommandStatus.add((StorageContainerDatanodeProtocolProtos.CommandStatus)cmdStatus);
            } else {
                LOGGER.debug("CommandStatus of type:{} not handled in CommandStatusReportHandler.", (Object)cmdStatus.getType());
            }
        });
        if (!deleteBlocksCommandStatus.isEmpty()) {
            publisher.fireEvent(SCMEvents.DELETE_BLOCK_STATUS, (Object)new DeleteBlockStatus(deleteBlocksCommandStatus, report.getDatanodeDetails()));
        }
    }

    public static class DeleteBlockStatus
    extends CommandStatusEvent {
        private final DatanodeDetails datanodeDetails;

        public DeleteBlockStatus(List<StorageContainerDatanodeProtocolProtos.CommandStatus> cmdStatus, DatanodeDetails datanodeDetails) {
            super(cmdStatus);
            this.datanodeDetails = datanodeDetails;
        }

        public DatanodeDetails getDatanodeDetails() {
            return this.datanodeDetails;
        }
    }

    public static class CommandStatusEvent
    implements IdentifiableEventPayload {
        private final List<StorageContainerDatanodeProtocolProtos.CommandStatus> cmdStatus;

        CommandStatusEvent(List<StorageContainerDatanodeProtocolProtos.CommandStatus> cmdStatus) {
            this.cmdStatus = cmdStatus;
        }

        public List<StorageContainerDatanodeProtocolProtos.CommandStatus> getCmdStatus() {
            return this.cmdStatus;
        }

        public String toString() {
            return "CommandStatusEvent:" + this.cmdStatus.toString();
        }

        public long getId() {
            return HddsIdFactory.getLongId();
        }
    }
}

