/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(name="ScmBlockDeletingService Metrics", about="Metrics related to background block deleting service in SCM", context="SCM")
public final class ScmBlockDeletingServiceMetrics
implements MetricsSource {
    private static ScmBlockDeletingServiceMetrics instance;
    public static final String SOURCE_NAME;
    private final MetricsRegistry registry;
    @Metric(about="The number of individual delete transaction commands sent to all DN.")
    private MutableCounterLong numBlockDeletionCommandSent;
    @Metric(about="The number of success ACK of delete transaction commands.")
    private MutableCounterLong numBlockDeletionCommandSuccess;
    @Metric(about="The number of failure ACK of delete transaction commands.")
    private MutableCounterLong numBlockDeletionCommandFailure;
    @Metric(about="The number of individual delete transactions sent to all DN.")
    private MutableCounterLong numBlockDeletionTransactionSent;
    @Metric(about="The number of success execution of delete transactions.")
    private MutableCounterLong numBlockDeletionTransactionSuccess;
    @Metric(about="The number of failure execution of delete transactions.")
    private MutableCounterLong numBlockDeletionTransactionFailure;
    @Metric(about="The number of completed txs which are removed from DB.")
    private MutableCounterLong numBlockDeletionTransactionCompleted;
    @Metric(about="The number of created txs which are added into DB.")
    private MutableCounterLong numBlockDeletionTransactionCreated;
    @Metric(about="The number of skipped transactions")
    private MutableCounterLong numSkippedTransactions;
    @Metric(about="The number of processed transactions")
    private MutableCounterLong numProcessedTransactions;
    @Metric(about="The number of dataNodes of delete transactions.")
    private MutableGaugeLong numBlockDeletionTransactionDataNodes;
    private final Map<UUID, DatanodeCommandCounts> numCommandsDatanode = new ConcurrentHashMap<UUID, DatanodeCommandCounts>();

    private ScmBlockDeletingServiceMetrics() {
        this.registry = new MetricsRegistry(SOURCE_NAME);
    }

    public static synchronized ScmBlockDeletingServiceMetrics create() {
        if (instance == null) {
            MetricsSystem ms = DefaultMetricsSystem.instance();
            instance = (ScmBlockDeletingServiceMetrics)ms.register(SOURCE_NAME, "SCMBlockDeletingService", (Object)new ScmBlockDeletingServiceMetrics());
        }
        return instance;
    }

    public static void unRegister() {
        instance = null;
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void incrBlockDeletionCommandSent() {
        this.numBlockDeletionCommandSent.incr();
    }

    public void incrBlockDeletionCommandSuccess() {
        this.numBlockDeletionCommandSuccess.incr();
    }

    public void incrBlockDeletionCommandFailure() {
        this.numBlockDeletionCommandFailure.incr();
    }

    public void incrBlockDeletionTransactionSent(long count) {
        this.numBlockDeletionTransactionSent.incr(count);
    }

    public void incrBlockDeletionTransactionFailure() {
        this.numBlockDeletionTransactionFailure.incr();
    }

    public void incrBlockDeletionTransactionSuccess() {
        this.numBlockDeletionTransactionSuccess.incr();
    }

    public void incrBlockDeletionTransactionCompleted(long count) {
        this.numBlockDeletionTransactionCompleted.incr(count);
    }

    public void incrBlockDeletionTransactionCreated(long count) {
        this.numBlockDeletionTransactionCreated.incr(count);
    }

    public void incrSkippedTransaction() {
        this.numSkippedTransactions.incr();
    }

    public void incrProcessedTransaction() {
        this.numProcessedTransactions.incr();
    }

    public void setNumBlockDeletionTransactionDataNodes(long dataNodes) {
        this.numBlockDeletionTransactionDataNodes.set(dataNodes);
    }

    public void incrDNCommandsSent(UUID id, long delta) {
        this.numCommandsDatanode.computeIfAbsent(id, k -> new DatanodeCommandCounts()).incrCommandsSent(delta);
    }

    public void incrDNCommandsSuccess(UUID id, long delta) {
        this.numCommandsDatanode.computeIfAbsent(id, k -> new DatanodeCommandCounts()).incrCommandsSuccess(delta);
    }

    public void incrDNCommandsFailure(UUID id, long delta) {
        this.numCommandsDatanode.computeIfAbsent(id, k -> new DatanodeCommandCounts()).incrCommandsFailure(delta);
    }

    public long getNumBlockDeletionCommandSent() {
        return this.numBlockDeletionCommandSent.value();
    }

    public long getNumBlockDeletionCommandSuccess() {
        return this.numBlockDeletionCommandSuccess.value();
    }

    public long getBNumBlockDeletionCommandFailure() {
        return this.numBlockDeletionCommandFailure.value();
    }

    public long getNumBlockDeletionTransactionSent() {
        return this.numBlockDeletionTransactionSent.value();
    }

    public long getNumBlockDeletionTransactionFailure() {
        return this.numBlockDeletionTransactionFailure.value();
    }

    public long getNumBlockDeletionTransactionSuccess() {
        return this.numBlockDeletionTransactionSuccess.value();
    }

    public long getNumBlockDeletionTransactionCompleted() {
        return this.numBlockDeletionTransactionCompleted.value();
    }

    public long getNumBlockDeletionTransactionCreated() {
        return this.numBlockDeletionTransactionCreated.value();
    }

    public long getNumSkippedTransactions() {
        return this.numSkippedTransactions.value();
    }

    public long getNumProcessedTransactions() {
        return this.numProcessedTransactions.value();
    }

    public long getNumBlockDeletionTransactionDataNodes() {
        return this.numBlockDeletionTransactionDataNodes.value();
    }

    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder builder = metricsCollector.addRecord(SOURCE_NAME);
        this.numBlockDeletionCommandSent.snapshot(builder, all);
        this.numBlockDeletionCommandSuccess.snapshot(builder, all);
        this.numBlockDeletionCommandFailure.snapshot(builder, all);
        this.numBlockDeletionTransactionSent.snapshot(builder, all);
        this.numBlockDeletionTransactionSuccess.snapshot(builder, all);
        this.numBlockDeletionTransactionFailure.snapshot(builder, all);
        this.numBlockDeletionTransactionCompleted.snapshot(builder, all);
        this.numBlockDeletionTransactionCreated.snapshot(builder, all);
        this.numSkippedTransactions.snapshot(builder, all);
        this.numProcessedTransactions.snapshot(builder, all);
        this.numBlockDeletionTransactionDataNodes.snapshot(builder, all);
        MetricsRecordBuilder recordBuilder = builder;
        for (Map.Entry<UUID, DatanodeCommandCounts> e : this.numCommandsDatanode.entrySet()) {
            recordBuilder = recordBuilder.endRecord().addRecord(SOURCE_NAME).add(new MetricsTag(Interns.info((String)"datanode", (String)"Datanode host for deletion commands"), e.getKey().toString())).addGauge(DatanodeCommandCounts.COMMANDS_SENT_TO_DN, e.getValue().getCommandsSent()).addGauge(DatanodeCommandCounts.COMMANDS_SUCCESSFUL_EXECUTION_BY_DN, e.getValue().getCommandsSuccess()).addGauge(DatanodeCommandCounts.COMMANDS_FAILED_EXECUTION_BY_DN, e.getValue().getCommandsFailure());
        }
        recordBuilder.endRecord();
    }

    public long getNumCommandsDatanodeSent() {
        long sent = 0L;
        for (DatanodeCommandCounts v : this.numCommandsDatanode.values()) {
            sent += v.commandsSent;
        }
        return sent;
    }

    public long getNumCommandsDatanodeSuccess() {
        long successCount = 0L;
        for (DatanodeCommandCounts v : this.numCommandsDatanode.values()) {
            successCount += v.commandsSuccess;
        }
        return successCount;
    }

    public long getNumCommandsDatanodeFailed() {
        long failCount = 0L;
        for (DatanodeCommandCounts v : this.numCommandsDatanode.values()) {
            failCount += v.commandsFailure;
        }
        return failCount;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder().append("numBlockDeletionTransactionCreated = ").append(this.numBlockDeletionTransactionCreated.value()).append("\t").append("numBlockDeletionTransactionCompleted = ").append(this.numBlockDeletionTransactionCompleted.value()).append("\t").append("numBlockDeletionCommandSent = ").append(this.numBlockDeletionCommandSent.value()).append("\t").append("numBlockDeletionCommandSuccess = ").append(this.numBlockDeletionCommandSuccess.value()).append("\t").append("numBlockDeletionCommandFailure = ").append(this.numBlockDeletionCommandFailure.value()).append("\t").append("numBlockDeletionTransactionSent = ").append(this.numBlockDeletionTransactionSent.value()).append("\t").append("numBlockDeletionTransactionSuccess = ").append(this.numBlockDeletionTransactionSuccess.value()).append("\t").append("numBlockDeletionTransactionFailure = ").append(this.numBlockDeletionTransactionFailure.value()).append("\t").append("numDeletionCommandsPerDatanode = ").append(this.numCommandsDatanode);
        return buffer.toString();
    }

    static {
        SOURCE_NAME = SCMBlockDeletingService.class.getSimpleName();
    }

    public static final class DatanodeCommandCounts {
        private long commandsSent = 0L;
        private long commandsSuccess = 0L;
        private long commandsFailure = 0L;
        private static final MetricsInfo COMMANDS_SENT_TO_DN = Interns.info((String)"CommandsSent", (String)"Number of commands sent from SCM to the datanode for deletion");
        private static final MetricsInfo COMMANDS_SUCCESSFUL_EXECUTION_BY_DN = Interns.info((String)"CommandsSuccess", (String)"Number of commands sent from SCM to the datanode for deletion for which execution succeeded.");
        private static final MetricsInfo COMMANDS_FAILED_EXECUTION_BY_DN = Interns.info((String)"CommandsFailed", (String)"Number of commands sent from SCM to the datanode for deletion for which execution failed.");

        public void incrCommandsSent(long delta) {
            this.commandsSent += delta;
        }

        public void incrCommandsSuccess(long delta) {
            this.commandsSuccess += delta;
        }

        public void incrCommandsFailure(long delta) {
            this.commandsFailure += delta;
        }

        public long getCommandsSent() {
            return this.commandsSent;
        }

        public long getCommandsSuccess() {
            return this.commandsSuccess;
        }

        public long getCommandsFailure() {
            return this.commandsFailure;
        }

        public String toString() {
            return "Sent=" + this.commandsSent + ", Success=" + this.commandsSuccess + ", Failed=" + this.commandsFailure;
        }
    }
}

