/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogStateManager;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedBlockLogStateManagerImpl
implements DeletedBlockLogStateManager {
    public static final Logger LOG = LoggerFactory.getLogger(DeletedBlockLogStateManagerImpl.class);
    private Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedTable;
    private ContainerManager containerManager;
    private final DBTransactionBuffer transactionBuffer;
    private final Set<Long> deletingTxIDs;
    private final Set<Long> skippingRetryTxIDs;

    public DeletedBlockLogStateManagerImpl(ConfigurationSource conf, Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedTable, ContainerManager containerManager, DBTransactionBuffer txBuffer) {
        this.deletedTable = deletedTable;
        this.containerManager = containerManager;
        this.transactionBuffer = txBuffer;
        this.deletingTxIDs = ConcurrentHashMap.newKeySet();
        this.skippingRetryTxIDs = ConcurrentHashMap.newKeySet();
    }

    @Override
    public TableIterator<Long, Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> getReadOnlyIterator() throws IOException {
        return new TableIterator<Long, Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>>(){
            private TableIterator<Long, ? extends Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> iter;
            private Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> nextTx;
            {
                this.iter = DeletedBlockLogStateManagerImpl.this.deletedTable.iterator();
                this.findNext();
            }

            private void findNext() {
                while (this.iter.hasNext()) {
                    long txID;
                    Table.KeyValue next = (Table.KeyValue)this.iter.next();
                    try {
                        txID = (Long)next.getKey();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("");
                    }
                    if (DeletedBlockLogStateManagerImpl.this.deletingTxIDs != null && DeletedBlockLogStateManagerImpl.this.deletingTxIDs.contains(txID) || DeletedBlockLogStateManagerImpl.this.skippingRetryTxIDs != null && DeletedBlockLogStateManagerImpl.this.skippingRetryTxIDs.contains(txID)) continue;
                    this.nextTx = next;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("DeletedBlocksTransaction matching txID:{}", (Object)txID);
                    }
                    return;
                }
                this.nextTx = null;
            }

            public boolean hasNext() {
                return this.nextTx != null;
            }

            public Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> next() {
                if (this.nextTx == null) {
                    throw new NoSuchElementException("DeletedBlocksTransaction Iterator reached end");
                }
                Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> returnTx = this.nextTx;
                this.findNext();
                return returnTx;
            }

            public void close() throws IOException {
                this.iter.close();
            }

            public void seekToFirst() {
                this.iter.seekToFirst();
                this.findNext();
            }

            public void seekToLast() {
                throw new UnsupportedOperationException("seekToLast");
            }

            public Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> seek(Long key) throws IOException {
                this.iter.seek((Object)key);
                this.findNext();
                return this.nextTx;
            }

            public void removeFromDB() throws IOException {
                throw new UnsupportedOperationException("read-only");
            }
        };
    }

    @Override
    public void addTransactionsToDB(ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> txs) throws IOException {
        HashMap<ContainerID, Long> containerIdToTxnIdMap = new HashMap<ContainerID, Long>();
        for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx : txs) {
            long tid = tx.getTxID();
            containerIdToTxnIdMap.compute(ContainerID.valueOf((long)tx.getContainerID()), (k, v) -> v != null && v > tid ? v : tid);
            this.transactionBuffer.addToBuffer(this.deletedTable, (Object)tx.getTxID(), (Object)tx);
        }
        this.containerManager.updateDeleteTransactionId(containerIdToTxnIdMap);
    }

    @Override
    public void removeTransactionsFromDB(ArrayList<Long> txIDs) throws IOException {
        if (this.deletingTxIDs != null) {
            this.deletingTxIDs.addAll(txIDs);
        }
        for (Long txID : txIDs) {
            this.transactionBuffer.removeFromBuffer(this.deletedTable, (Object)txID);
        }
    }

    @Override
    public void increaseRetryCountOfTransactionInDB(ArrayList<Long> txIDs) throws IOException {
        for (Long txID : txIDs) {
            StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction block = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)this.deletedTable.get((Object)txID);
            if (block == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Deleted TXID {} not found.", (Object)txID);
                continue;
            }
            StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.Builder builder = block.toBuilder().setCount(-1);
            this.transactionBuffer.addToBuffer(this.deletedTable, (Object)txID, (Object)builder.build());
            if (this.skippingRetryTxIDs == null) continue;
            this.skippingRetryTxIDs.add(txID);
        }
    }

    @Override
    public int resetRetryCountOfTransactionInDB(ArrayList<Long> txIDs) throws IOException {
        Objects.requireNonNull(txIDs, "txIds cannot be null.");
        int resetCount = 0;
        for (long txId : txIDs) {
            try {
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction transaction = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)this.deletedTable.get((Object)txId);
                if (transaction == null) {
                    LOG.warn("txId {} is not found in deletedTable.", (Object)txId);
                    continue;
                }
                if (transaction.getCount() != -1) {
                    LOG.warn("txId {} has already been reset in deletedTable.", (Object)txId);
                    continue;
                }
                this.transactionBuffer.addToBuffer(this.deletedTable, (Object)txId, (Object)transaction.toBuilder().setCount(0).build());
                ++resetCount;
                if (!LOG.isDebugEnabled()) continue;
                LOG.info("Reset deleted block Txn retry count to 0 in container {} with txnId {} ", (Object)transaction.getContainerID(), (Object)txId);
            }
            catch (IOException ex) {
                LOG.error("Could not reset deleted block transaction {}.", (Object)txId, (Object)ex);
                throw ex;
            }
        }
        LOG.info("Reset in total {} deleted block Txn retry count", (Object)resetCount);
        return resetCount;
    }

    @Override
    public void onFlush() {
        Preconditions.checkNotNull(this.deletingTxIDs);
        Preconditions.checkNotNull(this.skippingRetryTxIDs);
        this.deletingTxIDs.clear();
        this.skippingRetryTxIDs.clear();
    }

    @Override
    public void reinitialize(Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTXTable) {
        Preconditions.checkArgument((boolean)this.deletingTxIDs.isEmpty());
        this.deletedTable = deletedBlocksTXTable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ConfigurationSource conf;
        private SCMRatisServer scmRatisServer;
        private Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> table;
        private DBTransactionBuffer transactionBuffer;
        private ContainerManager containerManager;

        public Builder setConfiguration(ConfigurationSource config) {
            this.conf = config;
            return this;
        }

        public Builder setRatisServer(SCMRatisServer ratisServer) {
            this.scmRatisServer = ratisServer;
            return this;
        }

        public Builder setDeletedBlocksTable(Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTable) {
            this.table = deletedBlocksTable;
            return this;
        }

        public Builder setSCMDBTransactionBuffer(DBTransactionBuffer buffer) {
            this.transactionBuffer = buffer;
            return this;
        }

        public Builder setContainerManager(ContainerManager contManager) {
            this.containerManager = contManager;
            return this;
        }

        public DeletedBlockLogStateManager build() {
            Preconditions.checkNotNull((Object)this.conf);
            Preconditions.checkNotNull(this.table);
            DeletedBlockLogStateManagerImpl impl = new DeletedBlockLogStateManagerImpl(this.conf, this.table, this.containerManager, this.transactionBuffer);
            return this.scmRatisServer.getProxyHandler(SCMRatisProtocol.RequestType.BLOCK, DeletedBlockLogStateManager.class, impl);
        }
    }
}

