/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.CollectionUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;

public class DBColumnFamilyDefinition<KEY, VALUE> {
    private final String tableName;
    private final Codec<KEY> keyCodec;
    private final Codec<VALUE> valueCodec;
    private volatile ManagedColumnFamilyOptions cfOptions;

    public static Map<String, DBColumnFamilyDefinition<?, ?>> newUnmodifiableMap(DBColumnFamilyDefinition<?, ?> ... families) {
        return DBColumnFamilyDefinition.newUnmodifiableMap(Collections.emptyMap(), families);
    }

    public static Map<String, DBColumnFamilyDefinition<?, ?>> newUnmodifiableMap(Map<String, DBColumnFamilyDefinition<?, ?>> existing, DBColumnFamilyDefinition<?, ?> ... families) {
        return CollectionUtils.newUnmodifiableMap(Arrays.asList(families), DBColumnFamilyDefinition::getName, existing);
    }

    public static Map<String, List<DBColumnFamilyDefinition<?, ?>>> newUnmodifiableMultiMap(DBColumnFamilyDefinition<?, ?> ... families) {
        return CollectionUtils.newUnmodifiableMultiMap(Arrays.asList(families), DBColumnFamilyDefinition::getName);
    }

    public DBColumnFamilyDefinition(String tableName, Codec<KEY> keyCodec, Codec<VALUE> valueCodec) {
        this.tableName = tableName;
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
        this.cfOptions = null;
    }

    public Table<KEY, VALUE> getTable(DBStore db) throws IOException {
        return db.getTable(this.tableName, this.getKeyType(), this.getValueType());
    }

    public String getName() {
        return this.tableName;
    }

    public Class<KEY> getKeyType() {
        return this.keyCodec.getTypeClass();
    }

    public Codec<KEY> getKeyCodec() {
        return this.keyCodec;
    }

    public Class<VALUE> getValueType() {
        return this.valueCodec.getTypeClass();
    }

    public Codec<VALUE> getValueCodec() {
        return this.valueCodec;
    }

    public ManagedColumnFamilyOptions getCfOptions() {
        return this.cfOptions;
    }

    public void setCfOptions(ManagedColumnFamilyOptions cfOptions) {
        this.cfOptions = cfOptions;
    }
}

