/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.DBStoreHAManager;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;

public final class TransactionInfo
implements Comparable<TransactionInfo> {
    private static final Codec<TransactionInfo> CODEC = new DelegatedCodec((Codec)StringCodec.get(), TransactionInfo::valueOf, TransactionInfo::toString, TransactionInfo.class, DelegatedCodec.CopyType.SHALLOW);
    public static final TransactionInfo DEFAULT_VALUE = TransactionInfo.valueOf(0L, -1L);
    public static final long NON_RATIS_TERM = -1L;
    private final SnapshotInfo snapshotInfo;
    private final String transactionInfoString;

    public static Codec<TransactionInfo> getCodec() {
        return CODEC;
    }

    public static TransactionInfo valueOf(String transactionInfo) {
        String[] tInfo = transactionInfo.split("#");
        Preconditions.checkArgument((tInfo.length == 2 ? 1 : 0) != 0, (String)"Unexpected split length: %s in \"%s\"", (int)tInfo.length, (Object)transactionInfo);
        try {
            return TransactionInfo.valueOf(Long.parseLong(tInfo[0]), Long.parseLong(tInfo[1]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse " + transactionInfo, e);
        }
    }

    public static TransactionInfo valueOf(long currentTerm, long transactionIndex) {
        return TransactionInfo.valueOf(TermIndex.valueOf((long)currentTerm, (long)transactionIndex));
    }

    public static TransactionInfo valueOf(TermIndex termIndex) {
        return new TransactionInfo(termIndex);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_VALUE);
    }

    @Override
    public int compareTo(TransactionInfo info) {
        return this.getTermIndex().compareTo(info.getTermIndex());
    }

    public static TermIndex getTermIndex(long transactionIndex) {
        return TermIndex.valueOf((long)-1L, (long)transactionIndex);
    }

    private TransactionInfo(final TermIndex termIndex) {
        this.transactionInfoString = termIndex.getTerm() + "#" + termIndex.getIndex();
        this.snapshotInfo = new SnapshotInfo(){

            public TermIndex getTermIndex() {
                return termIndex;
            }

            public List<FileInfo> getFiles() {
                return null;
            }

            public String toString() {
                return TransactionInfo.this.transactionInfoString;
            }
        };
    }

    public long getTerm() {
        return this.snapshotInfo.getTerm();
    }

    public long getTransactionIndex() {
        return this.snapshotInfo.getIndex();
    }

    public TermIndex getTermIndex() {
        return this.snapshotInfo.getTermIndex();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInfo that = (TransactionInfo)o;
        return this.getTermIndex().equals(that.getTermIndex());
    }

    public int hashCode() {
        return Objects.hash(this.getTerm(), this.getTransactionIndex());
    }

    public String toString() {
        return this.transactionInfoString;
    }

    public static TransactionInfo readTransactionInfo(DBStoreHAManager metadataManager) throws IOException {
        return metadataManager.getTransactionInfoTable().getSkipCache("#TRANSACTIONINFO");
    }

    public ByteString toByteString() throws IOException {
        return ByteString.copyFrom((byte[])TransactionInfo.getCodec().toPersistedFormat((Object)this));
    }

    public static TransactionInfo fromByteString(ByteString byteString) throws IOException {
        return byteString == null ? null : (TransactionInfo)TransactionInfo.getCodec().fromPersistedFormat(byteString.toByteArray());
    }

    public SnapshotInfo toSnapshotInfo() {
        return this.snapshotInfo;
    }
}

