/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pipeline {
    private static final Codec<Pipeline> CODEC = new DelegatedCodec<Pipeline, HddsProtos.Pipeline>(Proto2Codec.get(HddsProtos.Pipeline.getDefaultInstance()), Pipeline::getFromProtobufSetCreationTimestamp, p -> p.getProtobufMessage(ClientVersion.CURRENT_VERSION), Pipeline.class, DelegatedCodec.CopyType.UNSUPPORTED);
    private static final Logger LOG = LoggerFactory.getLogger(Pipeline.class);
    private final PipelineID id;
    private final ReplicationConfig replicationConfig;
    private final PipelineState state;
    private final Map<DatanodeDetails, Long> nodeStatus;
    private final Map<DatanodeDetails, Integer> replicaIndexes;
    private final ImmutableList<DatanodeDetails> nodesInOrder;
    private DatanodeID leaderId;
    private Instant creationTimestamp;
    private final DatanodeID suggestedLeaderId;
    private final Instant stateEnterTime;

    private Pipeline(Builder b) {
        this.id = b.id;
        this.replicationConfig = b.replicationConfig;
        this.state = b.state;
        this.leaderId = b.leaderId;
        this.suggestedLeaderId = b.suggestedLeaderId;
        this.nodeStatus = b.nodeStatus;
        this.nodesInOrder = b.nodesInOrder != null ? ImmutableList.copyOf((Collection)b.nodesInOrder) : ImmutableList.of();
        this.replicaIndexes = b.replicaIndexes;
        this.creationTimestamp = b.creationTimestamp != null ? b.creationTimestamp : Instant.now();
        this.stateEnterTime = Instant.now();
    }

    public static Codec<Pipeline> getCodec() {
        return CODEC;
    }

    public PipelineID getId() {
        return this.id;
    }

    public HddsProtos.ReplicationType getType() {
        return this.replicationConfig.getReplicationType();
    }

    public PipelineState getPipelineState() {
        return this.state;
    }

    public Instant getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Instant getStateEnterTime() {
        return this.stateEnterTime;
    }

    public DatanodeID getSuggestedLeaderId() {
        return this.suggestedLeaderId;
    }

    public void setCreationTimestamp(Instant creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public DatanodeID getLeaderId() {
        return this.leaderId;
    }

    void setLeaderId(DatanodeID leaderId) {
        this.leaderId = leaderId;
    }

    public int size() {
        return this.nodeStatus.size();
    }

    public List<DatanodeDetails> getNodes() {
        return new ArrayList<DatanodeDetails>(this.nodeStatus.keySet());
    }

    @JsonIgnore
    public Set<DatanodeDetails> getNodeSet() {
        return Collections.unmodifiableSet(this.nodeStatus.keySet());
    }

    public boolean sameDatanodes(Pipeline pipeline) {
        return this.getNodeSet().equals(pipeline.getNodeSet());
    }

    public int getReplicaIndex(DatanodeDetails dn) {
        return this.replicaIndexes.getOrDefault(dn, 0);
    }

    public Map<DatanodeDetails, Integer> getReplicaIndexes() {
        return this.getNodes().stream().collect(Collectors.toMap(Function.identity(), this::getReplicaIndex));
    }

    public DatanodeDetails getLeaderNode() throws IOException {
        if (this.nodeStatus.isEmpty()) {
            throw new IOException(String.format("Pipeline=%s is empty", this.id));
        }
        Optional<DatanodeDetails> datanodeDetails = this.nodeStatus.keySet().stream().filter(d -> d.getID().equals(this.leaderId)).findFirst();
        if (datanodeDetails.isPresent()) {
            return datanodeDetails.get();
        }
        return this.getClosestNode();
    }

    public DatanodeDetails getFirstNode() throws IOException {
        return this.getFirstNode(null);
    }

    public DatanodeDetails getFirstNode(Set<DatanodeDetails> excluded) throws IOException {
        if (excluded == null) {
            excluded = Collections.emptySet();
        }
        if (this.nodeStatus.isEmpty()) {
            throw new IOException(String.format("Pipeline=%s is empty", this.id));
        }
        for (DatanodeDetails d : this.nodeStatus.keySet()) {
            if (excluded.contains(d)) continue;
            return d;
        }
        throw new IOException(String.format("All nodes are excluded: Pipeline=%s, excluded=%s", this.id, excluded));
    }

    public DatanodeDetails getClosestNode() throws IOException {
        return this.getClosestNode(null);
    }

    public DatanodeDetails getClosestNode(Set<DatanodeDetails> excluded) throws IOException {
        if (excluded == null) {
            excluded = Collections.emptySet();
        }
        if (this.nodesInOrder.isEmpty()) {
            LOG.debug("Nodes in order is empty, delegate to getFirstNode");
            return this.getFirstNode(excluded);
        }
        for (DatanodeDetails d : this.nodesInOrder) {
            if (excluded.contains(d)) continue;
            return d;
        }
        throw new IOException(String.format("All nodes are excluded: Pipeline=%s, excluded=%s", this.id, excluded));
    }

    @JsonIgnore
    public boolean isClosed() {
        return this.state == PipelineState.CLOSED;
    }

    @JsonIgnore
    public boolean isOpen() {
        return this.state == PipelineState.OPEN;
    }

    public List<DatanodeDetails> getNodesInOrder() {
        if (this.nodesInOrder.isEmpty()) {
            LOG.debug("Nodes in order is empty, delegate to getNodes");
            return this.getNodes();
        }
        return this.nodesInOrder;
    }

    void reportDatanode(DatanodeDetails dn) throws IOException {
        if (dn == null || this.nodeStatus.get(dn) == null && this.nodeStatus.keySet().stream().noneMatch(node -> node.compareNodeValues(dn))) {
            throw new IOException(String.format("Datanode=%s not part of pipeline=%s", dn, this.id));
        }
        this.nodeStatus.put(dn, System.currentTimeMillis());
    }

    public boolean isHealthy() {
        if (this.replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            return true;
        }
        for (Long reportedTime : this.nodeStatus.values()) {
            if (reportedTime >= 0L) continue;
            return false;
        }
        return this.leaderId != null;
    }

    public boolean isEmpty() {
        return this.nodeStatus.isEmpty();
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public HddsProtos.Pipeline getProtobufMessage(int clientVersion) {
        return this.getProtobufMessage(clientVersion, Collections.emptySet());
    }

    public HddsProtos.Pipeline getProtobufMessage(int clientVersion, Set<DatanodeDetails.Port.Name> filterPorts) {
        ArrayList<HddsProtos.DatanodeDetailsProto> members = new ArrayList<HddsProtos.DatanodeDetailsProto>();
        ArrayList<Integer> memberReplicaIndexes = new ArrayList<Integer>();
        for (DatanodeDetails dn : this.nodeStatus.keySet()) {
            members.add(dn.toProto(clientVersion, filterPorts));
            memberReplicaIndexes.add(this.replicaIndexes.getOrDefault(dn, 0));
        }
        HddsProtos.Pipeline.Builder builder = HddsProtos.Pipeline.newBuilder().setId(this.id.getProtobuf()).setType(this.replicationConfig.getReplicationType()).setState(PipelineState.getProtobuf(this.state)).setLeaderID(this.leaderId != null ? this.leaderId.toString() : "").setCreationTimeStamp(this.creationTimestamp.toEpochMilli()).addAllMembers(members).addAllMemberReplicaIndexes(memberReplicaIndexes);
        if (this.replicationConfig instanceof ECReplicationConfig) {
            builder.setEcReplicationConfig(((ECReplicationConfig)this.replicationConfig).toProto());
        } else {
            builder.setFactor(ReplicationConfig.getLegacyFactor(this.replicationConfig));
        }
        if (this.leaderId != null) {
            builder.setLeaderDatanodeID(this.leaderId.toProto());
        }
        if (this.suggestedLeaderId != null) {
            builder.setSuggestedLeaderDatanodeID(this.suggestedLeaderId.toProto());
        }
        if (!this.nodesInOrder.isEmpty()) {
            block1: for (DatanodeDetails datanodeDetails : this.nodesInOrder) {
                Iterator<DatanodeDetails> it = this.nodeStatus.keySet().iterator();
                for (int j = 0; j < this.nodeStatus.size(); ++j) {
                    if (!it.next().equals(datanodeDetails)) continue;
                    builder.addMemberOrders(j);
                    continue block1;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serialize pipeline {} with nodesInOrder {}", (Object)this.id, this.nodesInOrder);
            }
        }
        return builder.build();
    }

    private static Pipeline getFromProtobufSetCreationTimestamp(HddsProtos.Pipeline proto) {
        return Pipeline.toBuilder(proto).setCreateTimestamp(Instant.now()).build();
    }

    public Pipeline copyWithNodesInOrder(List<? extends DatanodeDetails> nodes) {
        return this.toBuilder().setNodesInOrder(nodes).build();
    }

    public Pipeline copyForRead() {
        if (this.replicationConfig.getReplicationType() == HddsProtos.ReplicationType.STAND_ALONE) {
            return this;
        }
        HddsProtos.ReplicationFactor factor = this.replicationConfig instanceof ReplicatedReplicationConfig ? ((ReplicatedReplicationConfig)this.replicationConfig).getReplicationFactor() : HddsProtos.ReplicationFactor.ONE;
        return this.toBuilder().setReplicationConfig(StandaloneReplicationConfig.getInstance(factor)).build();
    }

    public Pipeline copyForReadFromNode(DatanodeDetails node) {
        Preconditions.assertTrue((boolean)this.nodeStatus.containsKey(node), () -> node + " is not part of the pipeline " + this.id.getId());
        return this.toBuilder().setNodes(Collections.singletonList(node)).setReplicaIndexes(Collections.singletonMap(node, this.getReplicaIndex(node))).setReplicationConfig(StandaloneReplicationConfig.getInstance(HddsProtos.ReplicationFactor.ONE)).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder toBuilder(HddsProtos.Pipeline pipeline) {
        Objects.requireNonNull(pipeline, "pipeline == null");
        LinkedHashMap<DatanodeDetails, Integer> nodes = new LinkedHashMap<DatanodeDetails, Integer>();
        int index = 0;
        int repIndexListLength = pipeline.getMemberReplicaIndexesCount();
        for (HddsProtos.DatanodeDetailsProto member : pipeline.getMembersList()) {
            int repIndex = 0;
            if (index < repIndexListLength) {
                repIndex = pipeline.getMemberReplicaIndexes(index);
            }
            nodes.put(DatanodeDetails.getFromProtoBuf(member), repIndex);
            ++index;
        }
        DatanodeID leaderId = null;
        if (pipeline.hasLeaderDatanodeID()) {
            leaderId = DatanodeID.of(pipeline.getLeaderDatanodeID().getUuid());
        } else if (pipeline.hasLeaderID128()) {
            HddsProtos.UUID uuid = pipeline.getLeaderID128();
            leaderId = DatanodeID.of(uuid);
        } else if (pipeline.hasLeaderID() && StringUtils.isNotEmpty((CharSequence)pipeline.getLeaderID())) {
            leaderId = DatanodeID.fromUuidString(pipeline.getLeaderID());
        }
        DatanodeID suggestedLeaderId = null;
        if (pipeline.hasSuggestedLeaderDatanodeID()) {
            suggestedLeaderId = DatanodeID.of(pipeline.getSuggestedLeaderDatanodeID().getUuid());
        } else if (pipeline.hasSuggestedLeaderID()) {
            HddsProtos.UUID uuid = pipeline.getSuggestedLeaderID();
            suggestedLeaderId = DatanodeID.of(uuid);
        }
        ReplicationConfig config = ReplicationConfig.fromProto(pipeline.getType(), pipeline.getFactor(), pipeline.getEcReplicationConfig());
        return Pipeline.newBuilder().setId(PipelineID.getFromProtobuf(pipeline.getId())).setReplicationConfig(config).setState(PipelineState.fromProtobuf(pipeline.getState())).setNodes(new ArrayList<DatanodeDetails>(nodes.keySet())).setReplicaIndexes(nodes).setLeaderId(leaderId).setSuggestedLeaderId(suggestedLeaderId).setNodeOrder(pipeline.getMemberOrdersList()).setCreateTimestamp(pipeline.getCreationTimeStamp());
    }

    public static Pipeline getFromProtobuf(HddsProtos.Pipeline pipeline) {
        return Pipeline.toBuilder(pipeline).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline that = (Pipeline)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.replicationConfig, (Object)that.replicationConfig).append(this.nodeStatus.keySet(), that.nodeStatus.keySet()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.replicationConfig.getReplicationType()).append(this.nodeStatus).toHashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append('{');
        b.append(" Id: ").append(this.id.getId());
        b.append(", Nodes: [");
        for (DatanodeDetails datanodeDetails : this.nodeStatus.keySet()) {
            b.append(" {").append(datanodeDetails);
            b.append(", ReplicaIndex: ").append(this.getReplicaIndex(datanodeDetails)).append("},");
        }
        b.append(']');
        b.append(", ReplicationConfig: ").append(this.replicationConfig);
        b.append(", State:").append((Object)this.getPipelineState());
        b.append(", leaderId:").append(this.leaderId != null ? this.leaderId.toString() : "");
        b.append(", CreationTimestamp").append(this.getCreationTimestamp().atZone(ZoneId.systemDefault()));
        b.append('}');
        return b.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private PipelineID id = null;
        private ReplicationConfig replicationConfig = null;
        private PipelineState state = null;
        private Map<DatanodeDetails, Long> nodeStatus = null;
        private List<Integer> nodeOrder = null;
        private List<DatanodeDetails> nodesInOrder = null;
        private DatanodeID leaderId = null;
        private Instant creationTimestamp = null;
        private DatanodeID suggestedLeaderId = null;
        private Map<DatanodeDetails, Integer> replicaIndexes = ImmutableMap.of();

        private Builder() {
        }

        private Builder(Pipeline pipeline) {
            this.id = pipeline.id;
            this.replicationConfig = pipeline.replicationConfig;
            this.state = pipeline.state;
            this.nodeStatus = pipeline.nodeStatus;
            this.nodesInOrder = pipeline.nodesInOrder;
            this.leaderId = pipeline.getLeaderId();
            this.creationTimestamp = pipeline.getCreationTimestamp();
            this.suggestedLeaderId = pipeline.getSuggestedLeaderId();
            if (this.nodeStatus != null) {
                ImmutableMap.Builder b = ImmutableMap.builder();
                for (DatanodeDetails dn : this.nodeStatus.keySet()) {
                    int index = pipeline.getReplicaIndex(dn);
                    if (index <= 0) continue;
                    b.put((Object)dn, (Object)index);
                }
                this.replicaIndexes = b.build();
            }
        }

        public Builder setId(DatanodeID datanodeID) {
            this.id = datanodeID.toPipelineID();
            return this;
        }

        public Builder setId(PipelineID id1) {
            this.id = id1;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replicationConf) {
            this.replicationConfig = replicationConf;
            return this;
        }

        public Builder setState(PipelineState state1) {
            this.state = state1;
            return this;
        }

        public Builder setLeaderId(DatanodeID leaderId1) {
            this.leaderId = leaderId1;
            return this;
        }

        public Builder setNodes(List<DatanodeDetails> nodes) {
            LinkedHashMap<DatanodeDetails, Long> newNodeStatus = new LinkedHashMap<DatanodeDetails, Long>();
            nodes.forEach(node -> newNodeStatus.put((DatanodeDetails)node, -1L));
            if (this.nodeStatus != null && !this.nodeStatus.keySet().equals(newNodeStatus.keySet())) {
                if (nodes.size() == 1) {
                    this.setId(nodes.iterator().next().getID());
                } else {
                    this.setId(PipelineID.randomId());
                }
            }
            this.nodeStatus = newNodeStatus;
            if (this.nodesInOrder != null) {
                this.nodesInOrder = new LinkedList<DatanodeDetails>(this.nodesInOrder);
                this.nodesInOrder.retainAll(nodes);
            }
            return this;
        }

        public Builder setNodeOrder(List<Integer> orders) {
            this.nodeOrder = Collections.unmodifiableList(orders);
            return this;
        }

        public Builder setNodesInOrder(List<? extends DatanodeDetails> nodes) {
            this.nodesInOrder = new LinkedList<DatanodeDetails>(nodes);
            return this;
        }

        public Builder setCreateTimestamp(Instant instant) {
            this.creationTimestamp = instant;
            return this;
        }

        public Builder setCreateTimestamp(long createTimestamp) {
            this.creationTimestamp = Instant.ofEpochMilli(createTimestamp);
            return this;
        }

        public Builder setSuggestedLeaderId(DatanodeID dnId) {
            this.suggestedLeaderId = dnId;
            return this;
        }

        public Builder setReplicaIndexes(Map<DatanodeDetails, Integer> indexes) {
            this.replicaIndexes = indexes == null ? ImmutableMap.of() : ImmutableMap.copyOf(indexes);
            return this;
        }

        public Pipeline build() {
            Objects.requireNonNull(this.id, "id == null");
            Objects.requireNonNull(this.replicationConfig, "replicationConfig == null");
            Objects.requireNonNull(this.state, "state == null");
            Objects.requireNonNull(this.nodeStatus, "nodeStatus == null");
            if (this.nodeOrder != null && !this.nodeOrder.isEmpty()) {
                ArrayList<DatanodeDetails> nodesWithOrder = new ArrayList<DatanodeDetails>();
                Iterator<Integer> iterator = this.nodeOrder.iterator();
                block0: while (iterator.hasNext()) {
                    Iterator<DatanodeDetails> it = this.nodeStatus.keySet().iterator();
                    for (int nodeIndex = iterator.next().intValue(); it.hasNext() && nodeIndex >= 0; --nodeIndex) {
                        DatanodeDetails node = it.next();
                        if (nodeIndex != 0) continue;
                        nodesWithOrder.add(node);
                        continue block0;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deserialize nodesInOrder {} in pipeline {}", nodesWithOrder, (Object)this.id);
                }
                this.nodesInOrder = nodesWithOrder;
            }
            return new Pipeline(this);
        }
    }

    public static enum PipelineState {
        ALLOCATED,
        OPEN,
        DORMANT,
        CLOSED;


        public static PipelineState fromProtobuf(HddsProtos.PipelineState state) {
            Objects.requireNonNull(state, "state == null");
            switch (state) {
                case PIPELINE_ALLOCATED: {
                    return ALLOCATED;
                }
                case PIPELINE_OPEN: {
                    return OPEN;
                }
                case PIPELINE_DORMANT: {
                    return DORMANT;
                }
                case PIPELINE_CLOSED: {
                    return CLOSED;
                }
            }
            throw new IllegalArgumentException("Unexpected value " + state + " from " + state.getClass());
        }

        public static HddsProtos.PipelineState getProtobuf(PipelineState state) {
            Objects.requireNonNull(state, "state == null");
            switch (state.ordinal()) {
                case 0: {
                    return HddsProtos.PipelineState.PIPELINE_ALLOCATED;
                }
                case 1: {
                    return HddsProtos.PipelineState.PIPELINE_OPEN;
                }
                case 2: {
                    return HddsProtos.PipelineState.PIPELINE_DORMANT;
                }
                case 3: {
                    return HddsProtos.PipelineState.PIPELINE_CLOSED;
                }
            }
            throw new IllegalArgumentException("Unexpected value " + (Object)((Object)state) + " from " + ((Object)((Object)state)).getClass());
        }
    }
}

