/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.ExtensibleParentCommand;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.util.ExitUtils;
import picocli.CommandLine;

@CommandLine.Command
public abstract class GenericCli
implements GenericParentCommand {
    public static final int EXECUTION_ERROR_EXIT_CODE = -1;
    private final OzoneConfiguration config = new OzoneConfiguration();
    private final CommandLine cmd;
    private UserGroupInformation user;
    @CommandLine.Option(names={"--verbose"}, description={"More verbose output. Show the stack trace of the errors."})
    private boolean verbose;

    @CommandLine.Option(names={"-D", "--set"})
    public void setConfigurationOverrides(Map<String, String> configOverrides) {
        configOverrides.forEach((arg_0, arg_1) -> ((OzoneConfiguration)this.config).set(arg_0, arg_1));
    }

    @CommandLine.Option(names={"-conf"})
    public void setConfigurationPath(String configPath) {
        this.config.addResource(new Path(configPath));
    }

    public GenericCli() {
        this(CommandLine.defaultFactory());
    }

    public GenericCli(CommandLine.IFactory factory) {
        this.cmd = new CommandLine((Object)this, factory);
        this.cmd.setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            this.printError(ex);
            return -1;
        });
        ExtensibleParentCommand.addSubcommands(this.cmd);
    }

    public void run(String[] argv) {
        int exitCode = this.execute(argv);
        if (exitCode != 0) {
            ExitUtils.terminate((int)exitCode, null, null);
        }
    }

    @VisibleForTesting
    public int execute(String[] argv) {
        return this.cmd.execute(argv);
    }

    protected void printError(Throwable error) {
        if (this.verbose || Strings.isNullOrEmpty((String)error.getMessage())) {
            error.printStackTrace(this.cmd.getErr());
        } else if (error instanceof FileSystemException) {
            String errorMessage = GenericCli.handleFileSystemException((FileSystemException)error);
            this.cmd.getErr().println(errorMessage);
        } else {
            this.cmd.getErr().println(error.getMessage().split("\n")[0]);
        }
    }

    @Override
    public OzoneConfiguration getOzoneConf() {
        return this.config;
    }

    public UserGroupInformation getUser() throws IOException {
        if (this.user == null) {
            this.user = UserGroupInformation.getCurrentUser();
        }
        return this.user;
    }

    @VisibleForTesting
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    protected PrintWriter out() {
        return this.cmd.getOut();
    }

    protected PrintWriter err() {
        return this.cmd.getErr();
    }

    private static String handleFileSystemException(FileSystemException e) {
        String errorMessage = e.getMessage();
        if (e.getReason() == null) {
            errorMessage = e instanceof NoSuchFileException ? "File not found: " + errorMessage : (e instanceof AccessDeniedException ? "Access denied: " + errorMessage : (e instanceof FileAlreadyExistsException ? "File already exists: " + errorMessage : e.getClass().getSimpleName() + ": " + errorMessage));
        }
        return "Error: " + errorMessage;
    }
}

