/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.util.MetricUtil;

@Metrics(about="Client Metrics", context="ozone")
public final class ContainerClientMetrics {
    private static ContainerClientMetrics instance;
    @VisibleForTesting
    static int referenceCount;
    private static final String SOURCE_NAME;
    private static int instanceCount;
    @Metric
    private MutableCounterLong totalWriteChunkCalls;
    @Metric
    private MutableCounterLong totalWriteChunkBytes;
    @Metric
    private MutableRate hsyncSynchronizedWorkNs;
    @Metric
    private MutableRate hsyncSendWriteChunkNs;
    @Metric
    private MutableRate hsyncWaitForFlushNs;
    @Metric
    private MutableRate hsyncWatchForCommitNs;
    @Metric
    private MutableCounterLong writeChunksDuringWrite;
    @Metric
    private MutableCounterLong flushesDuringWrite;
    private MutableQuantiles[] listBlockLatency;
    private MutableQuantiles[] getBlockLatency;
    private MutableQuantiles[] getCommittedBlockLengthLatency;
    private MutableQuantiles[] readChunkLatency;
    private MutableQuantiles[] getSmallFileLatency;
    private MutableQuantiles[] hsyncLatencyNs;
    private MutableQuantiles[] omHsyncLatencyNs;
    private MutableQuantiles[] datanodeHsyncLatencyNs;
    private final Map<PipelineID, MutableCounterLong> writeChunkCallsByPipeline;
    private final Map<PipelineID, MutableCounterLong> writeChunkBytesByPipeline;
    private final Map<UUID, MutableCounterLong> writeChunksCallsByLeaders;
    private final MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);

    public static synchronized ContainerClientMetrics acquire() {
        if (instance == null) {
            instance = (ContainerClientMetrics)DefaultMetricsSystem.instance().register(SOURCE_NAME + ++instanceCount, "Ozone Client Metrics", (Object)new ContainerClientMetrics());
        }
        ++referenceCount;
        return instance;
    }

    public static synchronized void release() {
        if (instance == null) {
            throw new IllegalStateException("This metrics class is not used.");
        }
        if (--referenceCount == 0) {
            instance.stop();
            DefaultMetricsSystem.instance().unregisterSource(SOURCE_NAME + instanceCount);
            instance = null;
        }
    }

    private ContainerClientMetrics() {
        this.writeChunkCallsByPipeline = new ConcurrentHashMap<PipelineID, MutableCounterLong>();
        this.writeChunkBytesByPipeline = new ConcurrentHashMap<PipelineID, MutableCounterLong>();
        this.writeChunksCallsByLeaders = new ConcurrentHashMap<UUID, MutableCounterLong>();
        this.listBlockLatency = new MutableQuantiles[3];
        this.getBlockLatency = new MutableQuantiles[3];
        this.getCommittedBlockLengthLatency = new MutableQuantiles[3];
        this.readChunkLatency = new MutableQuantiles[3];
        this.getSmallFileLatency = new MutableQuantiles[3];
        this.hsyncLatencyNs = new MutableQuantiles[3];
        this.omHsyncLatencyNs = new MutableQuantiles[3];
        this.datanodeHsyncLatencyNs = new MutableQuantiles[3];
        int[] intervals = new int[]{60, 300, 900};
        for (int i = 0; i < intervals.length; ++i) {
            int interval = intervals[i];
            this.listBlockLatency[i] = this.registry.newQuantiles("listBlockLatency" + interval + "s", "ListBlock latency in microseconds", "ops", "latency", interval);
            this.getBlockLatency[i] = this.registry.newQuantiles("getBlockLatency" + interval + "s", "GetBlock latency in microseconds", "ops", "latency", interval);
            this.getCommittedBlockLengthLatency[i] = this.registry.newQuantiles("getCommittedBlockLengthLatency" + interval + "s", "GetCommittedBlockLength latency in microseconds", "ops", "latency", interval);
            this.readChunkLatency[i] = this.registry.newQuantiles("readChunkLatency" + interval + "s", "ReadChunk latency in microseconds", "ops", "latency", interval);
            this.getSmallFileLatency[i] = this.registry.newQuantiles("getSmallFileLatency" + interval + "s", "GetSmallFile latency in microseconds", "ops", "latency", interval);
            this.hsyncLatencyNs[i] = this.registry.newQuantiles("hsyncLatency" + interval + "s", "client hsync latency in nanoseconds", "ops", "latency", interval);
            this.omHsyncLatencyNs[i] = this.registry.newQuantiles("omHsyncLatency" + interval + "s", "client hsync latency to OM in nanoseconds", "ops", "latency", interval);
            this.datanodeHsyncLatencyNs[i] = this.registry.newQuantiles("dnHsyncLatency" + interval + "s", "client hsync latency to DN in nanoseconds", "ops", "latency", interval);
        }
    }

    public void stop() {
        MetricUtil.stop((MutableQuantiles[])this.listBlockLatency);
        MetricUtil.stop((MutableQuantiles[])this.getBlockLatency);
        MetricUtil.stop((MutableQuantiles[])this.getCommittedBlockLengthLatency);
        MetricUtil.stop((MutableQuantiles[])this.readChunkLatency);
        MetricUtil.stop((MutableQuantiles[])this.getSmallFileLatency);
        MetricUtil.stop((MutableQuantiles[])this.hsyncLatencyNs);
        MetricUtil.stop((MutableQuantiles[])this.omHsyncLatencyNs);
        MetricUtil.stop((MutableQuantiles[])this.datanodeHsyncLatencyNs);
    }

    public void recordWriteChunk(Pipeline pipeline, long chunkSizeBytes) {
        this.writeChunkCallsByPipeline.computeIfAbsent(pipeline.getId(), pipelineID -> this.registry.newCounter(Interns.info((String)("writeChunkCallsPipeline-" + pipelineID.getId()), (String)"Number of writeChunk calls on a pipelines"), 0L)).incr();
        this.writeChunkBytesByPipeline.computeIfAbsent(pipeline.getId(), pipelineID -> this.registry.newCounter(Interns.info((String)("writeChunkBytesPipeline-" + pipelineID.getId()), (String)"Number of bytes written on a pipelines"), 0L)).incr(chunkSizeBytes);
        if (pipeline.getLeaderId() != null) {
            this.writeChunksCallsByLeaders.computeIfAbsent(pipeline.getLeaderId(), leader -> this.registry.newCounter(Interns.info((String)("writeChunkCallsLeader-" + leader), (String)"Number of writeChunk calls on a leader node"), 0L)).incr();
        }
        this.totalWriteChunkCalls.incr();
        this.totalWriteChunkBytes.incr(chunkSizeBytes);
    }

    public void addListBlockLatency(long latency) {
        for (MutableQuantiles q : this.listBlockLatency) {
            if (q == null) continue;
            q.add(latency);
        }
    }

    public void addHsyncLatency(long hsyncLatencyTime) {
        for (MutableQuantiles q : this.hsyncLatencyNs) {
            if (q == null) continue;
            q.add(hsyncLatencyTime);
        }
    }

    public void addGetBlockLatency(long latency) {
        for (MutableQuantiles q : this.getBlockLatency) {
            if (q == null) continue;
            q.add(latency);
        }
    }

    public void addOMHsyncLatency(long hsyncLatencyTime) {
        for (MutableQuantiles q : this.omHsyncLatencyNs) {
            if (q == null) continue;
            q.add(hsyncLatencyTime);
        }
    }

    public void addGetCommittedBlockLengthLatency(long latency) {
        for (MutableQuantiles q : this.getCommittedBlockLengthLatency) {
            if (q == null) continue;
            q.add(latency);
        }
    }

    public void addReadChunkLatency(long latency) {
        for (MutableQuantiles q : this.readChunkLatency) {
            if (q == null) continue;
            q.add(latency);
        }
    }

    public void addGetSmallFileLatency(long latency) {
        for (MutableQuantiles q : this.getSmallFileLatency) {
            if (q == null) continue;
            q.add(latency);
        }
    }

    public void addDataNodeHsyncLatency(long hsyncLatencyTime) {
        for (MutableQuantiles q : this.datanodeHsyncLatencyNs) {
            if (q == null) continue;
            q.add(hsyncLatencyTime);
        }
    }

    @VisibleForTesting
    public MutableCounterLong getTotalWriteChunkBytes() {
        return this.totalWriteChunkBytes;
    }

    MutableCounterLong getTotalWriteChunkCalls() {
        return this.totalWriteChunkCalls;
    }

    Map<PipelineID, MutableCounterLong> getWriteChunkBytesByPipeline() {
        return this.writeChunkBytesByPipeline;
    }

    Map<PipelineID, MutableCounterLong> getWriteChunkCallsByPipeline() {
        return this.writeChunkCallsByPipeline;
    }

    Map<UUID, MutableCounterLong> getWriteChunksCallsByLeaders() {
        return this.writeChunksCallsByLeaders;
    }

    public MutableRate getHsyncSynchronizedWorkNs() {
        return this.hsyncSynchronizedWorkNs;
    }

    public MutableRate getHsyncSendWriteChunkNs() {
        return this.hsyncSendWriteChunkNs;
    }

    public MutableRate getHsyncWaitForFlushNs() {
        return this.hsyncWaitForFlushNs;
    }

    public MutableRate getHsyncWatchForCommitNs() {
        return this.hsyncWatchForCommitNs;
    }

    public MutableCounterLong getWriteChunksDuringWrite() {
        return this.writeChunksDuringWrite;
    }

    public MutableCounterLong getFlushesDuringWrite() {
        return this.flushesDuringWrite;
    }

    static {
        referenceCount = 0;
        SOURCE_NAME = ContainerClientMetrics.class.getSimpleName();
        instanceCount = 0;
    }
}

