/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.annotations;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.hadoop.ozone.request.validation.RegisterValidator"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RegisterValidatorProcessor
extends AbstractProcessor {
    public static final String ANNOTATION_SIMPLE_NAME = "RegisterValidator";
    public static final String VERSION_CLASS_NAME = "org.apache.hadoop.ozone.Version";
    public static final String REQUEST_PROCESSING_PHASE_CLASS_NAME = "org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase";
    public static final String APPLY_BEFORE_METHOD_NAME = "applyBefore";
    public static final String REQUEST_TYPE_METHOD_NAME = "requestType";
    public static final String PROCESSING_PHASE_METHOD_NAME = "processingPhase";
    public static final String MAX_VERSION_NOT_FOUND_ERROR_MESSAGE = "Method applyBefore returning an enum implementing org.apache.hadoop.ozone.Version not found";
    public static final String REQUEST_TYPE_NOT_FOUND_ERROR_MESSAGE = "Method requestType returning an enum not found";
    public static final String PROCESSING_PHASE_NOT_FOUND_ERROR_MESSAGE = "Method processingPhase returning an enum implementing org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase not found";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            if (!typeElement.getSimpleName().contentEquals(ANNOTATION_SIMPLE_NAME)) continue;
            this.processElements(roundEnv.getElementsAnnotatedWith(typeElement));
        }
        return false;
    }

    private boolean validateArrayMethod(ExecutableElement method, String expectedMethodName, ElementKind expectedReturnType, String expectedReturnClass) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        TypeElement expectedReturnInterface = expectedReturnClass == null || expectedReturnClass.equals("") ? null : elementUtils.getTypeElement(expectedReturnClass);
        return method.getSimpleName().toString().equals(expectedMethodName) && (expectedReturnType == null || TypeKind.ARRAY.equals((Object)method.getReturnType().getKind()) && types.asElement(((ArrayType)method.getReturnType()).getComponentType()).getKind() == expectedReturnType) && (expectedReturnInterface == null || types.isAssignable(types.asElement(method.getReturnType()).asType(), expectedReturnInterface.asType()));
    }

    private boolean validateMethod(ExecutableElement method, String expectedMethodName, ElementKind expectedReturnType, String expectedReturnClass) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        TypeElement expectedReturnInterface = expectedReturnClass == null || expectedReturnClass.equals("") ? null : elementUtils.getTypeElement(expectedReturnClass);
        return method.getSimpleName().toString().equals(expectedMethodName) && (expectedReturnType == null || types.asElement(method.getReturnType()) != null && types.asElement(method.getReturnType()).getKind() == expectedReturnType) && (expectedReturnInterface == null || types.isAssignable(types.asElement(method.getReturnType()).asType(), expectedReturnInterface.asType()));
    }

    private void processElements(Set<? extends Element> annotatedElements) {
        for (Element element : annotatedElements) {
            if (!element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            boolean hasApplyBeforeMethod = false;
            boolean hasRequestType = false;
            boolean hasRequestProcessPhase = false;
            for (Element element2 : element.getEnclosedElements()) {
                if (!(element2 instanceof ExecutableElement)) continue;
                ExecutableElement method = (ExecutableElement)element2;
                hasApplyBeforeMethod = hasApplyBeforeMethod || this.validateMethod(method, APPLY_BEFORE_METHOD_NAME, ElementKind.ENUM, VERSION_CLASS_NAME);
                hasRequestType = hasRequestType || this.validateArrayMethod(method, REQUEST_TYPE_METHOD_NAME, ElementKind.ENUM, null);
                hasRequestProcessPhase = hasRequestProcessPhase || this.validateMethod(method, PROCESSING_PHASE_METHOD_NAME, ElementKind.ENUM, REQUEST_PROCESSING_PHASE_CLASS_NAME);
            }
            if (!hasApplyBeforeMethod) {
                this.emitErrorMsg("Method applyBefore returning an enum implementing org.apache.hadoop.ozone.Version not found for " + element.getSimpleName().toString());
            }
            if (!hasRequestType) {
                this.emitErrorMsg("Method requestType returning an enum not found for " + element.getSimpleName().toString());
            }
            if (hasRequestProcessPhase) continue;
            this.emitErrorMsg("Method processingPhase returning an enum implementing org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase not found for " + element.getSimpleName().toString());
        }
    }

    private void emitErrorMsg(String s) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, s);
    }
}

