/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.se;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;

public final class CDILauncher {
    private CDILauncher() {
    }

    public static void main(String[] args) {
        SeContainerInitializer initializer = SeContainerInitializer.newInstance();
        Config config = CDILauncher.configure(initializer, args);
        try (SeContainer container = initializer.initialize();){
            if (config.main != null) {
                CDILauncher.executeMain(config, container);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeMain(Config config, SeContainer container) {
        block20: {
            BeanManager manager = container.getBeanManager();
            Set beans = manager.getBeans(config.main);
            if (beans == null || beans.isEmpty()) {
                try {
                    beans = manager.getBeans(Thread.currentThread().getContextClassLoader().loadClass(config.main), new Annotation[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("No bean '" + config.main + "' found");
                }
            }
            Bean bean = manager.resolve(beans);
            CreationalContext context = manager.createCreationalContext(null);
            Object reference = manager.getReference(bean, CDILauncher.selectProxyType(bean.getTypes()), context);
            try {
                if (Runnable.class.isInstance(reference)) {
                    ((Runnable)Runnable.class.cast(reference)).run();
                    break block20;
                }
                Method method = null;
                try {
                    method = bean.getBeanClass().getMethod("main", String[].class);
                }
                catch (Exception e) {
                    try {
                        method = bean.getBeanClass().getMethod("main", new Class[0]);
                    }
                    catch (Exception e2) {
                        try {
                            method = bean.getBeanClass().getMethod("main", new Class[0]);
                        }
                        catch (Exception e3) {
                            throw new IllegalArgumentException(bean + " does not implements Runnable or has a public main method");
                        }
                    }
                }
                try {
                    Object[] objectArray;
                    Object object = Modifier.isStatic(method.getModifiers()) ? null : reference;
                    if (method.getParameterCount() == 1) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = config.args;
                    } else {
                        objectArray = new Object[]{};
                    }
                    Object output = method.invoke(object, objectArray);
                    if (output != null) {
                        System.out.println(output);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getTargetException());
                }
            }
            finally {
                if (!manager.isNormalScope(bean.getScope())) {
                    context.release();
                }
            }
        }
    }

    private static Class<?> selectProxyType(Set<Type> types) {
        if (types.contains(Runnable.class)) {
            return Runnable.class;
        }
        return Object.class;
    }

    private static Config configure(SeContainerInitializer initializer, String[] args) {
        String main = null;
        ArrayList<String> remaining = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String current = args[i];
            if (current != null && current.startsWith("--openwebbeans.")) {
                if (args.length <= i + 1) {
                    throw new IllegalArgumentException("Missing argument value for: '" + args[i] + "'");
                }
                if (current.equals("--openwebbeans.main")) {
                    if (main != null) {
                        throw new IllegalArgumentException("Ambiguous main '" + main + "' vs '" + args[i + 1] + "'");
                    }
                    main = args[i + 1];
                } else {
                    initializer.addProperty(current.substring("--".length()), (Object)args[i + 1]);
                }
                ++i;
                continue;
            }
            remaining.add(current);
        }
        return new Config(remaining.toArray(new String[0]), main);
    }

    private static class Config {
        private final String[] args;
        private final String main;

        private Config(String[] args, String main) {
            this.args = args;
            this.main = main;
        }
    }
}

