/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.resource.spi.se;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.rmi.CORBA.Stub;
import javax.xml.ws.WebServiceRef;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.resource.spi.se.StandaloneResourceProcessor;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneResourceInjectionService
implements ResourceInjectionService {
    private static final String DUMMY_STRING = "owb.actual.resource.dummy";
    private final StandaloneResourceProcessor processor = StandaloneResourceProcessor.getProcessor();
    private static final Logger logger = WebBeansLoggerFacade.getLogger(StandaloneResourceInjectionService.class);
    private final WebBeansContext webBeansContext;
    private final Map<Class<?>, Boolean> classContainsEEResources = new ConcurrentHashMap();

    public StandaloneResourceInjectionService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    protected WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        if (resourceReference.supports(Resource.class)) {
            Resource resource = (Resource)resourceReference.getAnnotation(Resource.class);
            return this.processor.getResource(resource, resourceReference.getResourceType());
        }
        if (resourceReference.supports(WebServiceRef.class)) {
            WebServiceRef resource = (WebServiceRef)resourceReference.getAnnotation(WebServiceRef.class);
            return this.processor.getWebServiceResource(resource, resourceReference.getResourceType());
        }
        if (resourceReference.supports(PersistenceContext.class)) {
            PersistenceContext persistenceContext = (PersistenceContext)resourceReference.getAnnotation(PersistenceContext.class);
            return this.processor.getEntityManager(persistenceContext, resourceReference.getResourceType());
        }
        if (resourceReference.supports(PersistenceUnit.class)) {
            PersistenceUnit persistenceUnit = (PersistenceUnit)resourceReference.getAnnotation(PersistenceUnit.class);
            return this.processor.getEntityManagerFactory(persistenceUnit, resourceReference.getResourceType());
        }
        return null;
    }

    public void injectJavaEEResources(Object managedBeanInstance) {
        Class<?> currentClass = managedBeanInstance.getClass();
        Boolean containsEeResource = this.classContainsEEResources.get(currentClass);
        if (containsEeResource != null && !containsEeResource.booleanValue()) {
            return;
        }
        while (currentClass != null && !Object.class.getName().equals(currentClass.getName())) {
            Field[] fields;
            for (Field field : fields = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(currentClass)) {
                Annotation ann;
                if (field.isAnnotationPresent(Produces.class) || Modifier.isStatic(field.getModifiers()) || (ann = AnnotationUtil.hasOwbInjectableResource((Annotation[])field.getDeclaredAnnotations())) == null) continue;
                ResourceReference resourceRef = new ResourceReference(field.getDeclaringClass(), field.getName(), field.getType(), ann);
                try {
                    if (!field.isAccessible()) {
                        this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)field, true);
                    }
                    field.set(managedBeanInstance, this.getResourceReference(resourceRef));
                    containsEeResource = Boolean.TRUE;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0025", (Object[])new Object[]{e, field}));
                    throw new WebBeansException(MessageFormat.format(WebBeansLoggerFacade.getTokenString((String)"ERROR_0025"), field), (Throwable)e);
                }
            }
            currentClass = currentClass.getSuperclass();
        }
        if (containsEeResource == null) {
            containsEeResource = Boolean.FALSE;
        }
        this.classContainsEEResources.put(managedBeanInstance.getClass(), containsEeResource);
    }

    public void clear() {
        this.processor.clear();
    }

    public <T> void writeExternal(Bean<T> bean, T actualResource, ObjectOutput out) throws IOException {
        Object ret;
        FailOverService failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
        if (failoverService != null && (ret = failoverService.handleResource(bean, actualResource, null, out)) != FailOverService.NOT_HANDLED) {
            return;
        }
        if (actualResource instanceof Serializable) {
            out.writeObject(actualResource);
        } else {
            out.writeObject(DUMMY_STRING);
        }
    }

    public <T> T readExternal(Bean<T> bean, ObjectInput in) throws IOException, ClassNotFoundException {
        Object actualResource = null;
        FailOverService failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
        if (failoverService != null && (actualResource = failoverService.handleResource(bean, actualResource, in, null)) != FailOverService.NOT_HANDLED) {
            return (T)actualResource;
        }
        actualResource = in.readObject();
        if (actualResource instanceof Stub) {
            ORB orb = ORB.init((String[])new String[0], null);
            ((Stub)actualResource).connect(orb);
        } else if (actualResource.equals(DUMMY_STRING)) {
            actualResource = ((ResourceBean)bean).getActualInstance();
        }
        return (T)actualResource;
    }
}

