/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.tck;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.SingletonSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatefulSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatelessSessionContainerInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.SingletonBean;
import org.apache.openejb.jee.StatefulBean;
import org.apache.openejb.jee.StatelessBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.lifecycle.StandaloneLifeCycle;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.test.tck.ManagersImpl;
import org.apache.webbeans.test.tck.mock.TCKMetaDataDiscoveryImpl;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.spi.StandaloneContainers;

public class StandaloneContainersImpl
implements StandaloneContainers {
    protected final Logger logger = WebBeansLoggerFacade.getLogger(StandaloneContainersImpl.class);
    protected StandaloneLifeCycle lifeCycle = null;
    protected DeploymentException excpetion;

    public void deployInternal(Iterable<Class<?>> classes) throws DeploymentException {
        final TCKMetaDataDiscoveryImpl discovery = (TCKMetaDataDiscoveryImpl)WebBeansContext.getInstance().getScannerService();
        this.lifeCycle = new StandaloneLifeCycle(){

            protected void afterInitApplication(Properties event) {
                this.scannerService = discovery;
            }
        };
        try {
            Iterator<Class<?>> it = classes.iterator();
            while (it.hasNext()) {
                discovery.addBeanClass(it.next());
            }
            this.lifeCycle.startApplication(null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Standalone Container Impl.", e);
            this.excpetion = new DeploymentException("Standalone Container Impl.", (Throwable)e);
            throw this.excpetion;
        }
    }

    public boolean deployInternal(Iterable<Class<?>> classes, Iterable<URL> beansXmls) {
        try {
            final TCKMetaDataDiscoveryImpl discovery = (TCKMetaDataDiscoveryImpl)WebBeansContext.getInstance().getScannerService();
            this.lifeCycle = new StandaloneLifeCycle(){

                protected void afterInitApplication(Properties event) {
                    this.scannerService = discovery;
                }
            };
            Iterator<Class<?>> it = classes.iterator();
            while (it.hasNext()) {
                discovery.addBeanClass(it.next());
            }
            Iterator<URL> itUrl = beansXmls.iterator();
            while (itUrl.hasNext()) {
                discovery.addBeanXml(itUrl.next());
            }
            this.lifeCycle.startApplication(null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Standalone Container Impl.", e);
            this.excpetion = new DeploymentException("Standalone Container Impl.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void setup() {
    }

    public void cleanup() {
    }

    public void undeploy() {
        try {
            this.lifeCycle.stopApplication(null);
            this.lifeCycle = null;
        }
        finally {
            ManagersImpl.cleanUp();
        }
    }

    public DeploymentException getDeploymentException() {
        return this.excpetion;
    }

    public void deploy(Collection<Class<?>> classes) throws DeploymentException {
        this.setUp(classes);
        this.deployInternal(classes);
    }

    public boolean deploy(Collection<Class<?>> classes, Collection<URL> xmls) {
        if (!this.setUp(classes)) {
            return false;
        }
        return this.deployInternal(classes, xmls);
    }

    private boolean setUp(Collection<Class<?>> classes) {
        try {
            ConfigurationFactory config = new ConfigurationFactory();
            Assembler assembler = new Assembler();
            assembler.createProxyFactory((ProxyFactoryInfo)config.configureService(ProxyFactoryInfo.class));
            assembler.createTransactionManager((TransactionServiceInfo)config.configureService(TransactionServiceInfo.class));
            assembler.createSecurityService((SecurityServiceInfo)config.configureService(SecurityServiceInfo.class));
            assembler.createContainer((ContainerInfo)config.configureService(StatelessSessionContainerInfo.class));
            assembler.createContainer((ContainerInfo)config.configureService(StatefulSessionContainerInfo.class));
            assembler.createContainer((ContainerInfo)config.configureService(SingletonSessionContainerInfo.class));
            EjbJarInfo ejbJar = config.configureApplication(this.buildTestApp(classes));
            assembler.createApplication(ejbJar);
            System.setProperty("openejb.validation.output.level", "VERBOSE");
            Properties properties = new Properties(System.getProperties());
            properties.setProperty("java.naming.factory.initial", InitContextFactory.class.getName());
            new InitialContext(properties);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Standalone Container Impl.", e);
            return false;
        }
        return true;
    }

    private EjbModule buildTestApp(Collection<Class<?>> classes) {
        EjbJar ejbJar = new EjbJar();
        ejbJar.setId(this.getClass().getName());
        for (Class<?> clazz : classes) {
            if (this.isSingleton(clazz)) {
                ejbJar.addEnterpriseBean((EnterpriseBean)new SingletonBean(clazz));
            }
            if (this.isStateless(clazz)) {
                ejbJar.addEnterpriseBean((EnterpriseBean)new StatelessBean(clazz));
            }
            if (!this.isStatefull(clazz)) continue;
            ejbJar.addEnterpriseBean((EnterpriseBean)new StatefulBean(clazz));
        }
        return new EjbModule(ejbJar);
    }

    private boolean isSingleton(Class<?> clazz) {
        return clazz.isAnnotationPresent(Singleton.class);
    }

    private boolean isStateless(Class<?> clazz) {
        return clazz.isAnnotationPresent(Stateless.class);
    }

    private boolean isStatefull(Class<?> clazz) {
        return clazz.isAnnotationPresent(Stateful.class);
    }
}

