/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.tck;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.SingletonSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatefulSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatelessSessionContainerInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.SingletonBean;
import org.apache.openejb.jee.StatefulBean;
import org.apache.openejb.jee.StatelessBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.ejb.EjbPlugin;
import org.apache.webbeans.lifecycle.StandaloneLifeCycle;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.test.tck.ManagersImpl;
import org.apache.webbeans.test.tck.mock.TCKMetaDataDiscoveryImpl;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.spi.StandaloneContainers;

public class StandaloneContainersImpl
implements StandaloneContainers {
    private StandaloneLifeCycle lifeCycle = null;
    private DeploymentException excpetion;

    public void deployInternal(Iterable<Class<?>> classes) throws DeploymentException {
        final TCKMetaDataDiscoveryImpl discovery = (TCKMetaDataDiscoveryImpl)((Object)ServiceLoader.getService(ScannerService.class));
        this.lifeCycle = new StandaloneLifeCycle(){

            protected void afterInitApplication(Properties event) {
                this.scannerService = discovery;
            }
        };
        try {
            Iterator<Class<?>> it = classes.iterator();
            while (it.hasNext()) {
                discovery.addBeanClass(it.next());
            }
            this.lifeCycle.startApplication(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.excpetion = new DeploymentException("Standalone Container Impl.", e);
            throw this.excpetion;
        }
    }

    public boolean deployInternal(Iterable<Class<?>> classes, Iterable<URL> beansXmls) {
        try {
            final TCKMetaDataDiscoveryImpl discovery = (TCKMetaDataDiscoveryImpl)((Object)ServiceLoader.getService(ScannerService.class));
            this.lifeCycle = new StandaloneLifeCycle(){

                protected void afterInitApplication(Properties event) {
                    this.scannerService = discovery;
                }

                public void beforeStartApplication(Object object) {
                    super.beforeStartApplication(object);
                    try {
                        PluginLoader.getInstance().startUp();
                        EjbPlugin plugin = (EjbPlugin)PluginLoader.getInstance().getEjbPlugin();
                        plugin.setUseInTest(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            Iterator<Class<?>> it = classes.iterator();
            while (it.hasNext()) {
                discovery.addBeanClass(it.next());
            }
            Iterator<URL> itUrl = beansXmls.iterator();
            while (itUrl.hasNext()) {
                discovery.addBeanXml(itUrl.next());
            }
            this.lifeCycle.startApplication(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.excpetion = new DeploymentException("Standalone Container Impl.", e);
            return false;
        }
        return true;
    }

    public void setup() {
    }

    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        try {
            this.lifeCycle.stopApplication(null);
            this.lifeCycle = null;
            try {
                EjbPlugin plugin = (EjbPlugin)PluginLoader.getInstance().getEjbPlugin();
                plugin.setUseInTest(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            ManagersImpl.cleanUp();
        }
    }

    public DeploymentException getDeploymentException() {
        return this.excpetion;
    }

    protected BeanManager getBeanManager() {
        return BeanManagerImpl.getManager();
    }

    public void deploy(Collection<Class<?>> classes) throws DeploymentException {
        this.setUp(classes);
        this.deployInternal(classes);
    }

    public boolean deploy(Collection<Class<?>> classes, Collection<URL> xmls) {
        this.setUp(classes);
        return this.deployInternal(classes, xmls);
    }

    private void setUp(Collection<Class<?>> classes) {
        try {
            ConfigurationFactory config = new ConfigurationFactory();
            Assembler assembler = new Assembler();
            assembler.createProxyFactory((ProxyFactoryInfo)config.configureService(ProxyFactoryInfo.class));
            assembler.createTransactionManager((TransactionServiceInfo)config.configureService(TransactionServiceInfo.class));
            assembler.createSecurityService((SecurityServiceInfo)config.configureService(SecurityServiceInfo.class));
            assembler.createContainer((ContainerInfo)config.configureService(StatelessSessionContainerInfo.class));
            assembler.createContainer((ContainerInfo)config.configureService(StatefulSessionContainerInfo.class));
            assembler.createContainer((ContainerInfo)config.configureService(SingletonSessionContainerInfo.class));
            EjbJarInfo ejbJar = config.configureApplication(this.buildTestApp(classes));
            assembler.createApplication(ejbJar);
            System.setProperty("openejb.validation.output.level", "VERBOSE");
            Properties properties = new Properties(System.getProperties());
            properties.setProperty("java.naming.factory.initial", InitContextFactory.class.getName());
            new InitialContext(properties);
            try {
                EjbPlugin plugin = (EjbPlugin)PluginLoader.getInstance().getEjbPlugin();
                plugin.setUseInTest(true);
            }
            catch (Throwable e) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private EjbModule buildTestApp(Collection<Class<?>> classes) {
        EjbJar ejbJar = new EjbJar();
        ejbJar.setId(this.getClass().getName());
        for (Class<?> clazz : classes) {
            if (this.isSingleton(clazz)) {
                ejbJar.addEnterpriseBean((EnterpriseBean)new SingletonBean(clazz));
            }
            if (this.isStateless(clazz)) {
                ejbJar.addEnterpriseBean((EnterpriseBean)new StatelessBean(clazz));
            }
            if (!this.isStatefull(clazz)) continue;
            ejbJar.addEnterpriseBean((EnterpriseBean)new StatefulBean(clazz));
        }
        return new EjbModule(ejbJar);
    }

    private boolean isSingleton(Class<?> clazz) {
        return clazz.isAnnotationPresent(Singleton.class);
    }

    private boolean isStateless(Class<?> clazz) {
        return clazz.isAnnotationPresent(Stateless.class);
    }

    private boolean isStatefull(Class<?> clazz) {
        return clazz.isAnnotationPresent(Stateful.class);
    }
}

