/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.junit5.internal;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.openwebbeans.junit5.Scopes;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class ScopesExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private Runnable[] classCallbacks;
    private Runnable[] methodCallbacks;

    public void afterAll(ExtensionContext context) {
        this.stop(this.classCallbacks);
    }

    public void afterEach(ExtensionContext context) {
        this.stop(this.methodCallbacks);
    }

    public void beforeAll(ExtensionContext context) {
        this.classCallbacks = this.start(context, true);
    }

    public void beforeEach(ExtensionContext context) {
        this.methodCallbacks = this.start(context, false);
    }

    private Runnable[] start(ExtensionContext context, boolean canVetoScopes) {
        Class[] scopes = AnnotationUtils.findAnnotation((Optional)context.getElement(), Scopes.class).map(Scopes::value).orElse(null);
        if (scopes == null || scopes.length == 0) {
            return null;
        }
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        ContextsService contextsService = webBeansContext.getContextsService();
        if (canVetoScopes) {
            this.stopIfNeeded(scopes, contextsService, RequestScoped.class);
            this.stopIfNeeded(scopes, contextsService, SessionScoped.class);
            if (webBeansContext.getOpenWebBeansConfiguration().supportsConversation()) {
                this.stopIfNeeded(scopes, contextsService, ConversationScoped.class);
            }
        }
        return (Runnable[])Stream.of(scopes).map(scope -> {
            Class scopeAnnot = scope;
            contextsService.startContext(scopeAnnot, null);
            return () -> contextsService.endContext(scopeAnnot, null);
        }).toArray(Runnable[]::new);
    }

    private void stopIfNeeded(Class<?>[] scopes, ContextsService contextsService, Class<? extends Annotation> scope) {
        Context currentReqScope;
        if (Stream.of(scopes).noneMatch(it -> it == scope) && (currentReqScope = contextsService.getCurrentContext(scope)) != null && currentReqScope.isActive()) {
            contextsService.endContext(scope, null);
        }
    }

    private void stop(Runnable[] destroyers) {
        if (destroyers != null) {
            Stream.of(destroyers).forEach(Runnable::run);
        }
    }
}

