/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.junit5.internal;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.openwebbeans.junit5.Cdi;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class CdiExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static SeContainer reusableContainer;
    private SeContainer container;
    private Collection<CreationalContext<Object>> creationalContexts = new ArrayList<CreationalContext<Object>>();
    private Closeable[] onStop;

    public void beforeAll(ExtensionContext extensionContext) {
        Cdi config = AnnotationUtils.findAnnotation((Optional)extensionContext.getElement(), Cdi.class).orElse(null);
        if (config == null) {
            return;
        }
        boolean reusable = config.reusable();
        if (reusable && reusableContainer != null) {
            return;
        }
        if (!reusable && reusableContainer != null) {
            throw new IllegalStateException("You can't mix @Cdi(reusable=true) and @Cdi(reusable=false) in the same suite");
        }
        SeContainerInitializer initializer = SeContainerInitializer.newInstance();
        if (config.disableDiscovery()) {
            initializer.disableDiscovery();
        }
        initializer.setClassLoader(Thread.currentThread().getContextClassLoader());
        initializer.addBeanClasses((Class[])config.classes());
        initializer.enableDecorators((Class[])config.decorators());
        initializer.enableInterceptors((Class[])config.interceptors());
        initializer.selectAlternatives((Class[])config.alternatives());
        initializer.selectAlternativeStereotypes((Class[])config.alternativeStereotypes());
        initializer.addPackages((Package[])Stream.of(config.packages()).map(Class::getPackage).toArray(Package[]::new));
        initializer.addPackages(true, (Package[])Stream.of(config.recursivePackages()).map(Class::getPackage).toArray(Package[]::new));
        this.onStop = (Closeable[])Stream.of(config.onStarts()).map(it -> {
            try {
                return (Cdi.OnStart)it.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }).peek(Supplier::get).filter(Objects::nonNull).toArray(Closeable[]::new);
        if (reusable) {
            reusableContainer = initializer.initialize();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.doClose(reusableContainer), this.getClass().getName() + "-shutdown"));
        } else {
            this.container = initializer.initialize();
        }
    }

    public void afterAll(ExtensionContext extensionContext) {
        if (this.container != null) {
            this.doClose(this.container);
            this.container = null;
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        if (this.container == null && reusableContainer == null) {
            return;
        }
        extensionContext.getTestInstances().ifPresent(testInstances -> testInstances.getAllInstances().stream().distinct().forEach(instance -> {
            BeanManager manager = (this.container == null ? reusableContainer : this.container).getBeanManager();
            AnnotatedType annotatedType = manager.createAnnotatedType(instance.getClass());
            InjectionTarget injectionTarget = manager.createInjectionTarget(annotatedType);
            CreationalContext creationalContext = manager.createCreationalContext(null);
            this.creationalContexts.add((CreationalContext<Object>)creationalContext);
            injectionTarget.inject(instance, creationalContext);
        }));
    }

    public void afterEach(ExtensionContext extensionContext) {
        if (!this.creationalContexts.isEmpty()) {
            this.creationalContexts.forEach(CreationalContext::release);
            this.creationalContexts.clear();
        }
    }

    private void doClose(SeContainer container) {
        container.close();
        Stream.of(this.onStop).forEach(it -> {
            try {
                it.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

