/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jsf;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.context.FacesContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.jsf.JSFUtil;

public class ConversationAwareViewHandler
extends ViewHandlerWrapper {
    private final ViewHandler delegate;

    public ConversationAwareViewHandler(ViewHandler delegate) {
        this.delegate = delegate;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (!JSFUtil.isOwbApplication()) {
            return this.delegate.getActionURL(context, viewId);
        }
        String url = this.delegate.getActionURL(context, viewId);
        ConversationManager conversationManager = ConversationManager.getInstance();
        Conversation conversation = conversationManager.getConversationBeanReference();
        if (conversation != null && !conversation.isTransient()) {
            url = JSFUtil.getRedirectViewIdWithCid(url, conversation.getId());
        }
        return url;
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        String queryString;
        if (!JSFUtil.isOwbApplication()) {
            return this.delegate.getRedirectURL(context, viewId, parameters, includeViewParams);
        }
        String url = this.delegate.getRedirectURL(context, viewId, parameters, includeViewParams);
        int indexOfQuery = url.indexOf(63);
        if (indexOfQuery > 0 && ((queryString = url.substring(indexOfQuery)).contains("?cid=") || queryString.contains("&cid="))) {
            return url;
        }
        ConversationManager conversationManager = ConversationManager.getInstance();
        Conversation conversation = conversationManager.getConversationBeanReference();
        if (conversation != null && !conversation.isTransient()) {
            url = JSFUtil.getRedirectViewIdWithCid(url, conversation.getId());
        }
        return url;
    }

    public ViewHandler getWrapped() {
        return this.delegate;
    }
}

