/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jms.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javassist.util.proxy.MethodHandler;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.jms.JMSModel;
import org.apache.webbeans.jms.component.JmsBean;
import org.apache.webbeans.jms.util.JmsUtil;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsProxyHandler
implements MethodHandler {
    private JmsBean<?> jmsComponent = null;
    private static volatile ConnectionFactory connectionFactory = null;
    private AtomicBoolean cfSet = new AtomicBoolean(false);
    private static Map<JMSModel.JMSType, Connection> connections = new ConcurrentHashMap<JMSModel.JMSType, Connection>();
    private static Map<String, Destination> dests = new ConcurrentHashMap<String, Destination>();
    private Object jmsObject = null;
    private Class<?> injectionClazz = null;

    public JmsProxyHandler(JmsBean<?> jmsComponent, Class<?> injectionClazz) {
        this.jmsComponent = jmsComponent;
        this.injectionClazz = injectionClazz;
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Exception {
        if (method.getName().equals("closeJMSObject")) {
            this.close();
            return null;
        }
        if (!ClassUtil.isObjectMethod((String)method.getName())) {
            Object cf = null;
            if (this.jmsObject == null) {
                Class<?> jmsClazz = this.injectionClazz;
                if (cf == null && Connection.class.isAssignableFrom(jmsClazz)) {
                    cf = this.createOrReturnQueueOrTopicConnection();
                }
                if (cf == null && Destination.class.isAssignableFrom(jmsClazz)) {
                    cf = this.createOrReturnQueueOrTopic();
                }
                if (cf == null && Session.class.isAssignableFrom(jmsClazz)) {
                    cf = this.createSession();
                }
                if (cf == null && MessageProducer.class.isAssignableFrom(jmsClazz)) {
                    cf = this.createMessageProducers();
                }
                if (cf == null && MessageConsumer.class.isAssignableFrom(jmsClazz)) {
                    cf = this.createMessageConsumers();
                }
                if (method.getName().equals("close")) {
                    throw new UnsupportedOperationException("close method is not supported for JMS resources");
                }
                if (cf == null) {
                    throw new WebBeansException("JMS Resource type is not correct!. Does not create JMS resource object to handle request");
                }
                this.jmsObject = cf;
            } else {
                cf = this.jmsObject;
            }
            return method.invoke(cf, arguments);
        }
        return proceed.invoke(instance, arguments);
    }

    private Object createOrReturnConnectionFactory() {
        if (connectionFactory != null) {
            return connectionFactory;
        }
        if (this.cfSet.compareAndSet(false, true)) {
            connectionFactory = JmsUtil.getConnectionFactory();
            return connectionFactory;
        }
        return null;
    }

    private Session createSession() {
        Connection connection = null;
        try {
            connection = this.createOrReturnQueueOrTopicConnection();
            return connection.createSession(false, 1);
        }
        catch (JMSException e) {
            this.ensureConnectionClosing(connection);
            throw new WebBeansException("Unable to create jms session", (Throwable)e);
        }
    }

    private void ensureConnectionClosing(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private MessageProducer createMessageProducers() {
        Connection connection = null;
        try {
            connection = this.createOrReturnQueueOrTopicConnection();
            return connection.createSession(false, 1).createProducer(this.createOrReturnQueueOrTopic());
        }
        catch (JMSException e) {
            this.ensureConnectionClosing(connection);
            throw new WebBeansException("Unable to create jms message producer", (Throwable)e);
        }
    }

    private MessageConsumer createMessageConsumers() {
        Connection connection = null;
        try {
            connection = this.createOrReturnQueueOrTopicConnection();
            return connection.createSession(false, 1).createConsumer(this.createOrReturnQueueOrTopic());
        }
        catch (JMSException e) {
            this.ensureConnectionClosing(connection);
            throw new WebBeansException("Unable to create jms message producer", (Throwable)e);
        }
    }

    private Connection createOrReturnQueueOrTopicConnection() {
        JMSModel jmsModel = this.jmsComponent.getJmsModel();
        try {
            if (jmsModel.getJmsType().equals((Object)JMSModel.JMSType.QUEUE)) {
                if (connections.containsKey(JMSModel.JMSType.QUEUE)) {
                    return connections.get(JMSModel.JMSType.QUEUE);
                }
                QueueConnectionFactory ccf = (QueueConnectionFactory)this.createOrReturnConnectionFactory();
                QueueConnection qc = ccf.createQueueConnection();
                connections.put(JMSModel.JMSType.QUEUE, (Connection)qc);
                return qc;
            }
            if (jmsModel.getJmsType().equals((Object)JMSModel.JMSType.TOPIC)) {
                if (connections.containsKey(JMSModel.JMSType.TOPIC)) {
                    return connections.get(JMSModel.JMSType.TOPIC);
                }
                TopicConnectionFactory ccf = (TopicConnectionFactory)this.createOrReturnConnectionFactory();
                TopicConnection qc = ccf.createTopicConnection();
                connections.put(JMSModel.JMSType.TOPIC, (Connection)qc);
                return qc;
            }
        }
        catch (JMSException e) {
            throw new WebBeansException("Unable to create jms connection", (Throwable)e);
        }
        return null;
    }

    private void close() {
        try {
            if (this.jmsObject != null) {
                Method method = this.jmsObject.getClass().getMethod("close", new Class[0]);
                if (!method.isAccessible()) {
                    this.jmsComponent.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)method, true);
                }
                method.invoke(this.jmsObject, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new WebBeansException("Unable to close JMS resources");
        }
    }

    private Destination createOrReturnQueueOrTopic() {
        String jndiName;
        JMSModel jmsModel = this.jmsComponent.getJmsModel();
        String string = jndiName = jmsModel.isJndiNameDefined() ? jmsModel.getJndiName() : jmsModel.getMappedName();
        if (dests.get(jndiName) != null) {
            return dests.get(jndiName);
        }
        Destination res = (Destination)JmsUtil.getInstanceFromJndi(this.jmsComponent.getJmsModel(), this.injectionClazz);
        dests.put(jndiName, res);
        return res;
    }

    public static void clearConnections() {
        try {
            connectionFactory = null;
            for (Connection connection : connections.values()) {
                connection.close();
            }
            connections = null;
            dests.clear();
            dests = null;
        }
        catch (Exception e) {
            throw new WebBeansException((Throwable)e);
        }
    }
}

