/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.enterprise.inject.spi.Annotated;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.GenericsUtil;

public abstract class AbstractAnnotated
implements Annotated {
    private final Type baseType;
    private Set<Type> typeClosures;
    private Set<Annotation> annotations = new HashSet<Annotation>();
    private Set<Class<?>> repeatables = new HashSet();
    private final WebBeansContext webBeansContext;

    protected AbstractAnnotated(WebBeansContext webBeansContext, Type baseType) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(baseType, "base type");
        this.baseType = baseType;
        this.webBeansContext = webBeansContext;
    }

    protected AbstractAnnotated(WebBeansContext webBeansContext, Annotated annotated) {
        this.baseType = annotated.getBaseType();
        this.webBeansContext = webBeansContext;
        this.typeClosures = annotated.getTypeClosure();
        this.annotations.addAll(annotated.getAnnotations());
    }

    protected void buildRepeatableAnnotations(Set<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        ArrayList<Annotation> repeatables = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            Optional<Method> repeatableMethod = this.webBeansContext.getAnnotationManager().getRepeatableMethod(type);
            if (!repeatableMethod.isPresent()) continue;
            try {
                Annotation[] repeatableAnns;
                if (repeatables == null) {
                    repeatables = new ArrayList<Annotation>();
                }
                for (Annotation repeatableAnn : repeatableAnns = (Annotation[])repeatableMethod.orElseThrow(IllegalStateException::new).invoke((Object)annotation, new Object[0])) {
                    repeatables.add(repeatableAnn);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                WebBeansLoggerFacade.getLogger(AbstractAnnotated.class).log(Level.FINER, "Problem while handling repeatable Annotations " + annotation.annotationType());
            }
        }
        if (repeatables != null && !repeatables.isEmpty()) {
            this.repeatables.addAll(repeatables.stream().map(Annotation::annotationType).collect(Collectors.toList()));
            this.annotations.addAll((Collection<Annotation>)repeatables);
        }
    }

    public Set<Class<?>> getRepeatables() {
        return this.repeatables;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        this.buildRepeatableAnnotations(Collections.singleton(annotation));
    }

    protected WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    protected void setAnnotations(Annotation[] annotations) {
        this.clearAnnotations();
        Collections.addAll(this.annotations, annotations);
        this.buildRepeatableAnnotations(this.annotations);
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return (T)ann;
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Set<Type> getTypeClosure() {
        if (this.typeClosures == null) {
            this.initTypeClosure();
        }
        return this.typeClosures;
    }

    protected abstract Class<?> getOwningClass();

    protected abstract Class<?> getDeclaringClass();

    private synchronized void initTypeClosure() {
        if (this.typeClosures == null) {
            this.typeClosures = this.extractTypeClojure(this.baseType);
            Set<String> ignoredInterfaces = this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredInterfaces();
            if (!ignoredInterfaces.isEmpty()) {
                this.typeClosures.removeIf(t -> t instanceof Class && ignoredInterfaces.contains(((Class)t).getName()));
            }
        }
    }

    protected Set<Type> extractTypeClojure(Type baseType) {
        return GenericsUtil.getTypeClosure(baseType, this.getOwningClass());
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Base Type : " + this.baseType.toString() + "," + "Type Closures : " + this.typeClosures + ",Annotations : " + this.annotations.toString();
    }
}

