/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Provider;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;
import org.apache.webbeans.proxy.AbstractProxyFactory;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.asm5.ClassWriter;
import org.apache.xbean.asm5.MethodVisitor;
import org.apache.xbean.asm5.Type;

public class NormalScopeProxyFactory
extends AbstractProxyFactory {
    public static final String FIELD_INSTANCE_PROVIDER = "owbContextualInstanceProvider";
    public static final String FIELD_PROTECTED_METHODS = "owbProtectedMethods";
    private ConcurrentMap<Bean<?>, Class<?>> cachedProxyClasses = new ConcurrentHashMap();

    public NormalScopeProxyFactory(WebBeansContext webBeansContext) {
        super(webBeansContext);
    }

    @Override
    protected Class getMarkerInterface() {
        return OwbNormalScopeProxy.class;
    }

    public static <T> T unwrapInstance(T proxyInstance) {
        if (proxyInstance instanceof OwbNormalScopeProxy) {
            try {
                Field internalInstanceField = proxyInstance.getClass().getDeclaredField(FIELD_INSTANCE_PROVIDER);
                internalInstanceField.setAccessible(true);
                Provider provider = (Provider)internalInstanceField.get(proxyInstance);
                return (T)provider.get();
            }
            catch (Exception e) {
                throw ExceptionUtil.throwAsRuntimeException(e);
            }
        }
        return proxyInstance;
    }

    public Provider getInstanceProvider(OwbNormalScopeProxy proxyInstance) {
        try {
            Field internalInstanceField = proxyInstance.getClass().getDeclaredField(FIELD_INSTANCE_PROVIDER);
            internalInstanceField.setAccessible(true);
            return (Provider)internalInstanceField.get(proxyInstance);
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    public <T> T createNormalScopeProxy(Bean<T> bean) {
        ClassLoader classLoader = bean.getBeanClass() != null ? this.getProxyClassLoader(bean.getBeanClass()) : (OwbBean.class.isInstance(bean) && ((OwbBean)OwbBean.class.cast(bean)).getReturnType() != null ? this.getProxyClassLoader(((OwbBean)OwbBean.class.cast(bean)).getReturnType()) : WebBeansUtil.getCurrentClassLoader());
        Class classToProxy = bean instanceof OwbBean ? ((OwbBean)bean).getReturnType() : bean.getBeanClass();
        Class<T> proxyClass = (Class<T>)this.cachedProxyClasses.get(bean);
        if (proxyClass == null) {
            proxyClass = this.createProxyClass(bean, classLoader, classToProxy);
        }
        return this.createProxyInstance(proxyClass, this.getInstanceProvider(classLoader, bean));
    }

    public Provider getInstanceProvider(ClassLoader classLoader, Bean<?> bean) {
        String scopeClassName = bean.getScope().getName();
        Class<?> instanceProviderClass = null;
        String proxyMappingConfigKey = "org.apache.webbeans.proxy.mapping." + scopeClassName;
        String className = this.webBeansContext.getOpenWebBeansConfiguration().getProperty(proxyMappingConfigKey);
        if (className == null || NormalScopedBeanInterceptorHandler.class.getName().equals(className)) {
            return new NormalScopedBeanInterceptorHandler(this.webBeansContext.getBeanManagerImpl(), bean);
        }
        try {
            instanceProviderClass = Class.forName(className, true, classLoader);
            Constructor<?> ct = instanceProviderClass.getConstructor(BeanManager.class, Bean.class);
            return (Provider)ct.newInstance(this.webBeansContext.getBeanManagerImpl(), bean);
        }
        catch (NoSuchMethodException nsme) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + className + " has wrong constructor", nsme);
        }
        catch (ClassNotFoundException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + className + " cannot be found", e);
        }
        catch (InvocationTargetException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + className + " creation exception", e);
        }
        catch (InstantiationException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + className + " creation exception", e);
        }
        catch (IllegalAccessException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + className + " creation exception", e);
        }
    }

    public synchronized <T> Class<T> createProxyClass(Bean<T> bean, ClassLoader classLoader, Class<T> classToProxy) {
        Class<T> proxyClass = (Class<T>)this.cachedProxyClasses.get(bean);
        if (proxyClass == null) {
            proxyClass = this.createProxyClass(classLoader, classToProxy);
            this.cachedProxyClasses.putIfAbsent(bean, proxyClass);
        }
        return proxyClass;
    }

    @Override
    protected void createSerialisation(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName) {
        String[] exceptionTypeNames = new String[]{Type.getType(ObjectStreamException.class).getInternalName()};
        MethodVisitor mv = cw.visitMethod(1, "writeReplace", "()Ljava/lang/Object;", null, exceptionTypeNames);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassFileName, FIELD_INSTANCE_PROVIDER, Type.getDescriptor(Provider.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    public <T> Class<T> createProxyClass(ClassLoader classLoader, Class<T> classToProxy) throws ProxyGenerationException {
        Method[] nonInterceptedMethods;
        String proxyClassName = this.getUnusedProxyClassName(classLoader, (classToProxy.getSigners() != null ? this.getSignedClassProxyName(classToProxy) : classToProxy.getName()) + "$$OwbNormalScopeProxy");
        Method[] interceptedMethods = null;
        if (classToProxy.isInterface()) {
            nonInterceptedMethods = classToProxy.getMethods();
        } else {
            ArrayList<Method> methods = new ArrayList<Method>();
            ArrayList<Method> protectedMethods = new ArrayList<Method>();
            for (Method method : ClassUtil.getNonPrivateMethods(classToProxy, true)) {
                if (this.unproxyableMethod(method)) continue;
                if (Modifier.isProtected(method.getModifiers())) {
                    protectedMethods.add(method);
                    continue;
                }
                methods.add(method);
            }
            nonInterceptedMethods = methods.toArray(new Method[methods.size()]);
            interceptedMethods = protectedMethods.toArray(new Method[protectedMethods.size()]);
        }
        Class<T> clazz = this.createProxyClass(classLoader, proxyClassName, classToProxy, interceptedMethods, nonInterceptedMethods);
        if (interceptedMethods != null && interceptedMethods.length > 0) {
            try {
                Field protectedMethodsField = clazz.getDeclaredField(FIELD_PROTECTED_METHODS);
                protectedMethodsField.setAccessible(true);
                protectedMethodsField.set(null, interceptedMethods);
            }
            catch (Exception e) {
                throw new ProxyGenerationException(e);
            }
        }
        return clazz;
    }

    public <T> T createProxyInstance(Class<T> proxyClass, Provider provider) throws ProxyGenerationException {
        try {
            T proxy = this.unsafeNewInstance(proxyClass);
            Field delegateField = proxy.getClass().getDeclaredField(FIELD_INSTANCE_PROVIDER);
            delegateField.setAccessible(true);
            delegateField.set(proxy, provider);
            return proxy;
        }
        catch (Exception e) {
            throw new ProxyGenerationException(e);
        }
    }

    @Override
    protected void createConstructor(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName, Constructor<?> ignored) throws ProxyGenerationException {
        try {
            Constructor<Object> superDefaultCt;
            String parentClassFileName;
            if (classToProxy.isInterface()) {
                parentClassFileName = Type.getInternalName(Object.class);
                superDefaultCt = Object.class.getConstructor(null);
            } else {
                parentClassFileName = classFileName;
                superDefaultCt = classToProxy.getDeclaredConstructor(null);
            }
            String descriptor = Type.getConstructorDescriptor(superDefaultCt);
            MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, parentClassFileName, "<init>", descriptor, false);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(1);
            mv.visitFieldInsn(181, proxyClassFileName, FIELD_INSTANCE_PROVIDER, Type.getDescriptor(Provider.class));
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (NoSuchMethodException e) {
            throw new ProxyGenerationException(e);
        }
    }

    @Override
    protected void createInstanceVariables(ClassWriter cw, Class<?> classToProxy, String classFileName) {
        cw.visitField(2, FIELD_INSTANCE_PROVIDER, Type.getDescriptor(Provider.class), null, null).visitEnd();
        cw.visitField(10, FIELD_PROTECTED_METHODS, Type.getDescriptor(Method[].class), null, null).visitEnd();
    }

    @Override
    protected void delegateInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] interceptedMethods) throws ProxyGenerationException {
        if (interceptedMethods == null) {
            return;
        }
        for (int i = 0; i < interceptedMethods.length; ++i) {
            Method proxiedMethod = interceptedMethods[i];
            this.generateDelegationMethod(cw, proxiedMethod, i, classToProxy, proxyClassFileName);
        }
    }

    @Override
    protected void delegateNonInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] noninterceptedMethods) throws ProxyGenerationException {
        for (Method delegatedMethod : noninterceptedMethods) {
            String methodDescriptor = Type.getMethodDescriptor((Method)delegatedMethod);
            Class<?>[] exceptionTypes = delegatedMethod.getExceptionTypes();
            String[] exceptionTypeNames = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                exceptionTypeNames[i] = Type.getType(exceptionTypes[i]).getInternalName();
            }
            int targetModifiers = delegatedMethod.getModifiers() & 0x85;
            MethodVisitor mv = cw.visitMethod(targetModifiers, delegatedMethod.getName(), methodDescriptor, null, exceptionTypeNames);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, proxyClassFileName, FIELD_INSTANCE_PROVIDER, Type.getDescriptor(Provider.class));
            mv.visitMethodInsn(185, Type.getInternalName(Provider.class), "get", "()Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, Type.getInternalName(classToProxy));
            int offset = 1;
            for (Class<?> aClass : delegatedMethod.getParameterTypes()) {
                Type type = Type.getType(aClass);
                mv.visitVarInsn(type.getOpcode(21), offset);
                offset += type.getSize();
            }
            Type declaringClass = Type.getType(delegatedMethod.getDeclaringClass());
            boolean interfaceMethod = Modifier.isInterface(delegatedMethod.getDeclaringClass().getModifiers());
            mv.visitMethodInsn(interfaceMethod ? 185 : 182, declaringClass.getInternalName(), delegatedMethod.getName(), methodDescriptor, interfaceMethod);
            this.generateReturn(mv, delegatedMethod);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }

    private void generateDelegationMethod(ClassWriter cw, Method method, int methodIndex, Class<?> classToProxy, String proxyClassFileName) {
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int modifiers = method.getModifiers();
        int modifier = modifiers & 0x85;
        MethodVisitor mv = cw.visitMethod(modifier, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, proxyClassFileName, FIELD_PROTECTED_METHODS, Type.getDescriptor(Method[].class));
        mv.visitIntInsn(16, methodIndex);
        mv.visitInsn(50);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassFileName, FIELD_INSTANCE_PROVIDER, Type.getDescriptor(Provider.class));
        mv.visitMethodInsn(185, Type.getInternalName(Provider.class), "get", "()Ljava/lang/Object;", true);
        this.pushMethodParameterArray(mv, parameterTypes);
        mv.visitMethodInsn(184, Type.getInternalName(NormalScopeProxyFactory.class), "delegateProtectedMethod", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, this.getCastType(returnType));
        if (returnType.isPrimitive() && !Void.TYPE.equals(returnType)) {
            mv.visitMethodInsn(182, this.getWrapperType(returnType), this.getPrimitiveMethod(returnType), "()" + Type.getDescriptor(returnType), false);
        }
        mv.visitInsn(this.getReturnInsn(returnType));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static Object delegateProtectedMethod(Method method, Object instance, Object[] params) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, params);
        }
        catch (InvocationTargetException ite) {
            throw ExceptionUtil.throwAsRuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
    }
}

