/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.util.Asserts;

public class InjectionTargetFactoryImpl<T>
implements InjectionTargetFactory<T> {
    private AnnotatedType<T> annotatedType;
    private WebBeansContext webBeansContext;

    public InjectionTargetFactoryImpl(AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
        Asserts.assertNotNull(annotatedType, "AnnotatedType");
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        this.annotatedType = annotatedType;
        this.webBeansContext = webBeansContext;
    }

    public InjectionTarget<T> createInjectionTarget() {
        return this.createInjectionTarget(null);
    }

    public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        InjectionTargetImpl<T> injectionTarget = new InjectionTargetImpl<T>(this.annotatedType, this.createInjectionPoints(bean), this.webBeansContext, this.getPostConstructMethods(), this.getPreDestroyMethods());
        if (ManagedBean.class.isInstance(bean)) {
            ((ManagedBean)ManagedBean.class.cast(bean)).setOriginalInjectionTarget(injectionTarget);
        }
        GProcessInjectionTarget event = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEvent(injectionTarget, this.annotatedType);
        InjectionTarget it = event.getInjectionTarget();
        event.setStarted();
        return it;
    }

    public Set<InjectionPoint> createInjectionPoints(Bean<T> bean) {
        HashSet<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
        for (InjectionPoint injectionPoint : this.webBeansContext.getInjectionPointFactory().buildInjectionPoints(bean, this.annotatedType)) {
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }

    public AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    protected WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    protected List<AnnotatedMethod<?>> getPostConstructMethods() {
        return this.webBeansContext.getInterceptorUtil().getLifecycleMethods(this.annotatedType, PostConstruct.class);
    }

    protected List<AnnotatedMethod<?>> getPreDestroyMethods() {
        return this.webBeansContext.getInterceptorUtil().getLifecycleMethods(this.annotatedType, PreDestroy.class);
    }
}

