/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.se;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.annotation.InitializedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SingletonContext;

public class DefaultContextsService
extends AbstractContextsService {
    private static ThreadLocal<RequestContext> requestContext = null;
    private static ThreadLocal<SessionContext> sessionContext = null;
    private ApplicationContext applicationContext = null;
    private static ThreadLocal<ConversationContext> conversationContext = null;
    private static ThreadLocal<SingletonContext> singletonContext = null;
    private static ThreadLocal<DependentContext> dependentContext = null;
    private final WebBeansContext webBeansContext;

    public DefaultContextsService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    @Override
    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.stopRequestContext(endParameters);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.stopSessionContext(endParameters);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.stopApplicationContext(endParameters);
            } else if (scopeType.equals(ConversationScoped.class)) {
                this.stopConversationContext(endParameters);
            } else if (!scopeType.equals(Dependent.class)) {
                this.stopSingletonContext(endParameters);
            }
        }
    }

    @Override
    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getCurrentRequestContext();
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getCurrentSessionContext();
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            return this.getCurrentApplicationContext();
        }
        if (scopeType.equals(ConversationScoped.class)) {
            return this.getCurrentConversationContext();
        }
        if (scopeType.equals(Dependent.class)) {
            return this.getCurrentDependentContext();
        }
        if (scopeType.equals(Singleton.class)) {
            return this.getCurrentSingletonContext();
        }
        return null;
    }

    @Override
    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        try {
            if (scopeType.equals(RequestScoped.class)) {
                this.startRequestContext(startParameter);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.startSessionContext(startParameter);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.startApplicationContext(startParameter);
            } else if (scopeType.equals(ConversationScoped.class)) {
                this.startConversationContext(startParameter);
            } else if (!scopeType.equals(Dependent.class) && scopeType.equals(Singleton.class)) {
                this.startSingletonContext(startParameter);
            }
        }
        catch (Exception e) {
            if (e instanceof ContextException) {
                throw (ContextException)e;
            }
            throw new ContextException((Throwable)e);
        }
    }

    @Override
    public boolean supportsContext(Class<? extends Annotation> scopeType) {
        return scopeType.equals(RequestScoped.class) || scopeType.equals(SessionScoped.class) || scopeType.equals(ApplicationScoped.class) || scopeType.equals(ConversationScoped.class) || scopeType.equals(Dependent.class) || scopeType.equals(Singleton.class);
    }

    @Override
    public void destroy(Object destroyObject) {
        requestContext.set(null);
        sessionContext.set(null);
        conversationContext.set(null);
        dependentContext.set(null);
        singletonContext.set(null);
        requestContext.remove();
        sessionContext.remove();
        conversationContext.remove();
        dependentContext.remove();
        singletonContext.remove();
    }

    private Context getCurrentApplicationContext() {
        return this.applicationContext;
    }

    private Context getCurrentConversationContext() {
        return (Context)conversationContext.get();
    }

    private Context getCurrentDependentContext() {
        if (dependentContext.get() == null) {
            dependentContext.set(new DependentContext());
        }
        return (Context)dependentContext.get();
    }

    private Context getCurrentRequestContext() {
        return (Context)requestContext.get();
    }

    private Context getCurrentSessionContext() {
        return (Context)sessionContext.get();
    }

    private Context getCurrentSingletonContext() {
        return (Context)singletonContext.get();
    }

    private void startApplicationContext(Object instance) {
        ApplicationContext ctx = new ApplicationContext();
        ctx.setActive(true);
        this.applicationContext = ctx;
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{InitializedLiteral.INSTANCE_APPLICATION_SCOPED});
    }

    private void startConversationContext(Object object) {
        ConversationContext ctx = new ConversationContext();
        ctx.setActive(true);
        conversationContext.set(ctx);
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{InitializedLiteral.INSTANCE_CONVERSATION_SCOPED});
    }

    private void startRequestContext(Object instance) {
        RequestContext ctx = new RequestContext();
        ctx.setActive(true);
        requestContext.set(ctx);
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{InitializedLiteral.INSTANCE_REQUEST_SCOPED});
    }

    private void startSessionContext(Object instance) {
        SessionContext ctx = new SessionContext();
        ctx.setActive(true);
        sessionContext.set(ctx);
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{InitializedLiteral.INSTANCE_SESSION_SCOPED});
    }

    private void startSingletonContext(Object object) {
        SingletonContext ctx = new SingletonContext();
        ctx.setActive(true);
        singletonContext.set(ctx);
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{InitializedLiteral.INSTANCE_SINGLETON_SCOPED});
    }

    private void stopApplicationContext(Object object) {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
            this.applicationContext = null;
            WebBeansContext.currentInstance().getBeanManagerImpl().clearCacheProxies();
            this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{DestroyedLiteral.INSTANCE_APPLICATION_SCOPED});
        }
    }

    private void stopConversationContext(Object object) {
        if (conversationContext.get() != null) {
            conversationContext.get().destroy();
        }
        conversationContext.set(null);
        conversationContext.remove();
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{DestroyedLiteral.INSTANCE_CONVERSATION_SCOPED});
    }

    private void stopRequestContext(Object instance) {
        if (requestContext.get() != null) {
            requestContext.get().destroy();
        }
        requestContext.set(null);
        requestContext.remove();
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{DestroyedLiteral.INSTANCE_REQUEST_SCOPED});
    }

    private void stopSessionContext(Object instance) {
        if (sessionContext.get() != null) {
            sessionContext.get().destroy();
        }
        sessionContext.set(null);
        sessionContext.remove();
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{DestroyedLiteral.INSTANCE_SESSION_SCOPED});
    }

    private void stopSingletonContext(Object object) {
        if (singletonContext.get() != null) {
            singletonContext.get().destroy();
        }
        singletonContext.set(null);
        singletonContext.remove();
        this.webBeansContext.getBeanManagerImpl().fireEvent(new Object(), new Annotation[]{DestroyedLiteral.INSTANCE_SINGLETON_SCOPED});
    }

    static {
        requestContext = new ThreadLocal();
        sessionContext = new ThreadLocal();
        conversationContext = new ThreadLocal();
        dependentContext = new ThreadLocal();
        singletonContext = new ThreadLocal();
    }
}

