/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.conversation;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.plugins.OpenWebBeansWebPlugin;
import org.apache.webbeans.util.Asserts;

public class ConversationImpl
implements Conversation,
Serializable {
    private static final long serialVersionUID = 8511063860333431722L;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ConversationImpl.class);
    private String id;
    private String oldId;
    private boolean isTransient = true;
    private long timeout;
    private String sessionId;
    private long activeTime = 0L;
    private static AtomicInteger conversationIdGenerator = new AtomicInteger(0);
    private Set<Long> threadsUsingIt = new HashSet<Long>();
    private transient WebBeansContext webBeansContext;

    public ConversationImpl() {
    }

    public ConversationImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        try {
            this.timeout = Long.parseLong(this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.timeoutInterval", "1800000"));
        }
        catch (NumberFormatException e) {
            this.timeout = 1800000L;
        }
    }

    public ConversationImpl(String sessionId, WebBeansContext webBeansContext) {
        Asserts.assertNotNull(sessionId);
        this.webBeansContext = webBeansContext;
        try {
            this.timeout = Long.parseLong(this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.timeoutInterval", "1800000"));
        }
        catch (NumberFormatException e) {
            this.timeout = 1800000L;
        }
        this.sessionId = sessionId;
    }

    public void begin() {
        if (this.isTransient) {
            this.isTransient = false;
            this.id = Integer.toString(conversationIdGenerator.incrementAndGet());
            this.ensureSessionId();
            this.iUseIt();
            this.updateTimeOut();
            ConversationManager manager = this.webBeansContext.getConversationManager();
            try {
                manager.addConversationContext(this, this.getOrStartConversationScope());
            }
            catch (ContextNotActiveException cnae) {
                throw cnae;
            }
            catch (Exception e) {
                manager.addConversationContext(this, new ConversationContext());
            }
        } else {
            logger.log(Level.WARNING, "WARN_0003", this.id);
            throw new IllegalStateException();
        }
    }

    private ConversationContext getOrStartConversationScope() {
        ConversationContext context = (ConversationContext)this.webBeansContext.getContextsService().getCurrentContext(ConversationScoped.class);
        if (context == null) {
            this.webBeansContext.getContextsService().startContext(ConversationScoped.class, null);
            context = (ConversationContext)this.webBeansContext.getContextsService().getCurrentContext(ConversationScoped.class);
        }
        if (context == null) {
            throw new ContextNotActiveException(ConversationScoped.class.getName());
        }
        if (!context.isActive()) {
            context.setActive(true);
        }
        return context;
    }

    public void begin(String id) {
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        if (conversationManager.isConversationExistWithGivenId(id)) {
            throw new IllegalArgumentException("Conversation with id=" + id + " is already exist!");
        }
        if (this.isTransient) {
            this.isTransient = false;
            this.id = id;
            this.iUseIt();
            this.ensureSessionId();
            this.updateTimeOut();
            conversationManager.addConversationContext(this, this.getOrStartConversationScope());
        }
    }

    private void ensureSessionId() {
        OpenWebBeansWebPlugin web;
        if (this.sessionId == null && (web = this.webBeansContext.getPluginLoader().getWebPlugin()) != null) {
            this.sessionId = web.currentSessionId();
        }
    }

    public void end() {
        this.check();
        if (this.isTransient) {
            logger.log(Level.WARNING, "WARN_0004", this.id);
            throw new IllegalStateException(this.toString() + " has already ended");
        }
        this.iDontUseItAnymore();
        this.oldId = this.id;
        this.id = null;
        this.isTransient = true;
    }

    public String getOldId() {
        return this.oldId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int iUseIt() {
        long thread = Thread.currentThread().getId();
        ConversationImpl conversationImpl = this;
        synchronized (conversationImpl) {
            this.threadsUsingIt.add(thread);
            return this.threadsUsingIt.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iDontUseItAnymore() {
        long thread = Thread.currentThread().getId();
        ConversationImpl conversationImpl = this;
        synchronized (conversationImpl) {
            this.threadsUsingIt.remove(thread);
        }
    }

    public String getId() {
        return this.id;
    }

    public long getTimeout() {
        this.check();
        return this.timeout;
    }

    public boolean isTransient() {
        this.check();
        return this.isTransient;
    }

    private synchronized void check() {
        if (this.threadsUsingIt.size() > 1) {
            throw new BusyConversationException("Propogated conversation with sessionid/cid=" + this.sessionId + "/" + this.id + " is used by other request.");
        }
    }

    public void setTimeout(long milliseconds) {
        this.check();
        this.timeout = milliseconds;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getActiveTime() {
        return this.activeTime;
    }

    public void updateTimeOut() {
        this.activeTime = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConversationImpl other = (ConversationImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }

    public String toString() {
        return "Conversation with id [ " + this.id + " ]";
    }

    private Object writeReplace() throws ObjectStreamException {
        Serialization serialization = new Serialization();
        serialization.setId(this.id);
        serialization.setSessionId(this.sessionId);
        return serialization;
    }

    public static class Serialization
    implements Serializable {
        private String sessionId;
        private String id;

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public void setId(String id) {
            this.id = id;
        }

        Object readResolve() throws ObjectStreamException {
            return WebBeansContext.currentInstance().getConversationManager().getPropogatedConversation(this.id, this.sessionId);
        }
    }
}

