/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.DefinitionException;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;

public abstract class AbstractProducerBeanBuilder<T, A extends AnnotatedMember<?>, P extends AbstractProducerBean<T>> {
    protected final InjectionTargetBean<?> parent;
    protected final A annotatedMember;
    protected final BeanAttributes<T> beanAttributes;

    public AbstractProducerBeanBuilder(InjectionTargetBean<?> parent, A annotated, BeanAttributes<T> beanAttributes) {
        Asserts.assertNotNull(parent, "webBeansContext may not be null");
        Asserts.assertNotNull(annotated, "annotated may not be null");
        Asserts.assertNotNull(beanAttributes, "beanAttributes may not be null");
        this.parent = parent;
        this.annotatedMember = annotated;
        this.beanAttributes = beanAttributes;
    }

    protected AnnotatedType<?> getSuperType() {
        Class superclass = this.annotatedMember.getDeclaringType().getJavaClass().getSuperclass();
        if (superclass == null) {
            return null;
        }
        return this.parent.getWebBeansContext().getAnnotatedElementFactory().getAnnotatedType(superclass);
    }

    public void validate() throws DefinitionException {
        Type type = this.annotatedMember.getBaseType();
        if (type instanceof GenericArrayType) {
            throw new WebBeansConfigurationException("Produced Type must not be a GenericArrayType");
        }
        if (ClassUtil.isParametrizedType(type)) {
            ParameterizedType parameterizedType;
            if (GenericsUtil.containsWildcardType(type)) {
                throw new WebBeansConfigurationException("Produced type must not be a WildcardType");
            }
            if (!Dependent.class.equals((Object)this.beanAttributes.getScope()) && GenericsUtil.containTypeVariable((parameterizedType = GenericsUtil.getParameterizedType(type)).getActualTypeArguments())) {
                throw new WebBeansConfigurationException("Produced ParametrizedType must be @Dependent-Scope");
            }
        }
    }

    protected abstract <X> P createBean(InjectionTargetBean<X> var1, Class<T> var2);

    protected P createBean(Class<T> beanClass) {
        return this.createBean(this.parent, beanClass);
    }
}

