/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class ErrorStack {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ErrorStack.class);
    private Stack<Throwable> errorStack = new Stack();

    public void pushError(Throwable e) {
        this.errorStack.addElement(e);
    }

    public void logErrors() {
        if (!this.errorStack.isEmpty()) {
            for (Throwable t : this.errorStack) {
                logger.log(Level.SEVERE, t.getMessage(), t);
            }
        }
    }

    public void clear() {
        this.errorStack.clear();
    }

    public boolean hasErrors() {
        return !this.errorStack.isEmpty();
    }
}

