/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;
import org.apache.webbeans.util.Asserts;

public final class AnnotatedElementFactory {
    public static final String OWB_DEFAULT_KEY = "OWB_DEFAULT_KEY";
    private static final Logger logger = WebBeansLoggerFacade.getLogger(AnnotatedElementFactory.class);
    private ConcurrentMap<Class<?>, ConcurrentMap<String, AnnotatedType<?>>> annotatedTypeCache = new ConcurrentHashMap();
    private ConcurrentMap<Constructor<?>, AnnotatedConstructor<?>> annotatedConstructorCache = new ConcurrentHashMap();
    private ConcurrentMap<Method, AnnotatedMethod<?>> annotatedMethodCache = new ConcurrentHashMap();
    private ConcurrentMap<Field, AnnotatedField<?>> annotatedFieldCache = new ConcurrentHashMap();
    private WebBeansContext webBeansContext;

    public AnnotatedElementFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public <X> AnnotatedType<X> getAnnotatedType(Class<X> annotatedClass) {
        return (AnnotatedType)this.getAnnotatedTypeCache(annotatedClass).get(OWB_DEFAULT_KEY);
    }

    public <X> Iterable<AnnotatedType<X>> getAnnotatedTypes(Class<X> annotatedClass) {
        return this.getAnnotatedTypeCache(annotatedClass).values();
    }

    public <X> AnnotatedType<X> setAnnotatedType(AnnotatedType<X> annotatedType) {
        return this.setAnnotatedType(annotatedType, OWB_DEFAULT_KEY);
    }

    public <X> AnnotatedType<X> setAnnotatedType(AnnotatedType<X> annotatedType, String id) {
        ConcurrentMap annotatedTypes = this.getAnnotatedTypeCache(annotatedType.getJavaClass());
        return annotatedTypes.put(id, annotatedType);
    }

    public <X> AnnotatedType<X> newAnnotatedType(Class<X> annotatedClass) {
        Asserts.assertNotNull(annotatedClass, "annotatedClass is null");
        ConcurrentMap<String, AnnotatedType<X>> annotatedTypes = this.getAnnotatedTypeCache(annotatedClass);
        AnnotatedType annotatedType = (AnnotatedType)annotatedTypes.get(OWB_DEFAULT_KEY);
        if (annotatedType == null) {
            try {
                AnnotatedType oldType;
                AnnotatedType<X> supertype = null;
                if (annotatedClass.getSuperclass() != null && !annotatedClass.getSuperclass().equals(Object.class)) {
                    supertype = this.newAnnotatedType(annotatedClass.getSuperclass());
                }
                if ((oldType = (AnnotatedType)annotatedTypes.putIfAbsent(OWB_DEFAULT_KEY, annotatedType = new AnnotatedTypeImpl(this.webBeansContext, annotatedClass, supertype))) != null) {
                    annotatedType = oldType;
                }
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException || e instanceof ArrayStoreException) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0027", annotatedClass.getName(), e.getCause()), e);
                    }
                    annotatedType = null;
                }
                throw new RuntimeException(e);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0027", annotatedClass.getName(), ncdfe.getCause()), ncdfe);
                }
                annotatedType = null;
            }
        }
        return annotatedType;
    }

    public <X> AnnotatedConstructor<X> newAnnotatedConstructor(Constructor<X> constructor, AnnotatedType<X> declaringClass) {
        AnnotatedConstructorImpl<X> annConstructor;
        Asserts.assertNotNull(constructor, "constructor is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        if (this.annotatedConstructorCache.containsKey(constructor)) {
            annConstructor = (AnnotatedConstructorImpl<X>)this.annotatedConstructorCache.get(constructor);
        } else {
            annConstructor = new AnnotatedConstructorImpl<X>(this.webBeansContext, constructor, declaringClass);
            AnnotatedConstructorImpl<X> old = this.annotatedConstructorCache.putIfAbsent(constructor, annConstructor);
            if (old != null) {
                annConstructor = old;
            }
        }
        return annConstructor;
    }

    public <X> AnnotatedField<X> newAnnotatedField(Field field, AnnotatedType<X> declaringClass) {
        AnnotatedFieldImpl<X> annotField;
        Asserts.assertNotNull(field, "field is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        if (this.annotatedFieldCache.containsKey(field)) {
            annotField = (AnnotatedFieldImpl<X>)this.annotatedFieldCache.get(field);
        } else {
            annotField = new AnnotatedFieldImpl<X>(this.webBeansContext, field, declaringClass);
            AnnotatedFieldImpl<X> old = this.annotatedFieldCache.putIfAbsent(field, annotField);
            if (old != null) {
                annotField = old;
            }
        }
        return annotField;
    }

    public <X> AnnotatedMethod<X> newAnnotatedMethod(Method method, AnnotatedType<X> declaringType) {
        AnnotatedMethodImpl<X> annotMethod;
        Asserts.assertNotNull(method, "method is null");
        Asserts.assertNotNull(declaringType, "declaringType is null");
        if (this.annotatedMethodCache.containsKey(method)) {
            annotMethod = (AnnotatedMethodImpl<X>)this.annotatedMethodCache.get(method);
        } else {
            annotMethod = new AnnotatedMethodImpl<X>(this.webBeansContext, method, declaringType);
            AnnotatedMethodImpl<X> old = this.annotatedMethodCache.putIfAbsent(method, annotMethod);
            if (old != null) {
                annotMethod = old;
            }
        }
        return annotMethod;
    }

    public void clear() {
        this.annotatedTypeCache.clear();
        this.annotatedConstructorCache.clear();
        this.annotatedFieldCache.clear();
        this.annotatedMethodCache.clear();
    }

    private <T> ConcurrentMap<String, AnnotatedType<T>> getAnnotatedTypeCache(Class<T> type) {
        ConcurrentMap oldAnnotatedTypes;
        ConcurrentMap annotatedTypes = (ConcurrentHashMap)this.annotatedTypeCache.get(type);
        if (annotatedTypes == null && (oldAnnotatedTypes = (ConcurrentMap)this.annotatedTypeCache.putIfAbsent(type, annotatedTypes = new ConcurrentHashMap())) != null) {
            annotatedTypes = oldAnnotatedTypes;
        }
        return annotatedTypes;
    }
}

