/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

public class ObserverMethodsBuilder<T, I extends InjectionTargetBean<T>> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ObserverMethodsBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ObserverMethod<?>> defineObserverMethods(AbstractOwbBean<T> bean) {
        HashSet definedObservers = new HashSet();
        Set annotatedMethods = this.annotatedType.getMethods();
        Iterator iterator = annotatedMethods.iterator();
        while (iterator.hasNext()) {
            ObserverMethod<?> definedObserver;
            AnnotatedMethod annotatedMethod;
            AnnotatedMethod annt = annotatedMethod = (AnnotatedMethod)iterator.next();
            List parameters = annt.getParameters();
            boolean found = false;
            for (AnnotatedParameter parameter : parameters) {
                if (!parameter.isAnnotationPresent(Observes.class)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            this.checkObserverMethodConditions(annotatedMethod, annotatedMethod.getDeclaringType().getJavaClass());
            if (bean.getScope().equals(Dependent.class)) {
                AnnotationUtil.getAnnotatedMethodFirstParameterWithAnnotation(annotatedMethod, Observes.class);
                Observes observes = AnnotationUtil.getAnnotatedMethodFirstParameterAnnotation(annotatedMethod, Observes.class);
                Reception reception = observes.notifyObserver();
                if (reception.equals((Object)Reception.IF_EXISTS)) {
                    throw new WebBeansConfigurationException("Dependent Bean : " + this.annotatedType.getJavaClass() + " can not define observer method with @Receiver = IF_EXIST");
                }
            }
            if ((definedObserver = this.webBeansContext.getBeanManagerImpl().getNotificationManager().getObservableMethodForAnnotatedMethod(annotatedMethod, bean)) == null) continue;
            definedObservers.add(definedObserver);
        }
        return definedObservers;
    }

    private void checkObserverMethodConditions(AnnotatedMethod<T> annotatedMethod, Class<?> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        Method candidateObserverMethod = annotatedMethod.getJavaMember();
        if (AnnotationUtil.hasAnnotatedMethodMultipleParameterAnnotation(annotatedMethod, Observes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not define two parameters with annotated @Observes");
        }
        if (annotatedMethod.isAnnotationPresent(Produces.class) || annotatedMethod.isAnnotationPresent(Inject.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not annotated with annotation in the list {@Produces, @Initializer, @Destructor}");
        }
        if (AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, Disposes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not annotated with annotation @Disposes");
        }
    }
}

