/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.EventMetadata;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.event.OwbObserverMethod;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.events.generics.GenericBeanEvent;
import org.apache.webbeans.portable.events.generics.GenericProducerObserverEvent;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class NotificationManager {
    private final Map<Type, Set<ObserverMethod<?>>> observers = new ConcurrentHashMap();
    private final WebBeansContext webBeansContext;

    public NotificationManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public <T> void addObserver(ObserverMethod<T> observer, Type eventType) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(observer.getObservedQualifiers());
        Set<ObserverMethod<?>> set = this.observers.get(eventType);
        if (set == null) {
            set = new HashSet();
            this.observers.put(eventType, set);
        }
        set.add(observer);
    }

    public <T> void addObserver(ObserverMethod<T> observer, TypeLiteral<T> typeLiteral) {
        EventUtil.checkEventType(typeLiteral.getRawType());
        this.addObserver(observer, typeLiteral.getType());
    }

    public void disableOverriddenObservers(Class<?> subClass) {
        for (Set<ObserverMethod<?>> observerMethods : this.observers.values()) {
            Iterator<ObserverMethod<?>> i = observerMethods.iterator();
            while (i.hasNext()) {
                AnnotatedMethod observerMethod;
                ObserverMethod<?> observer = i.next();
                if (!(observer instanceof ObserverMethodImpl) || (observerMethod = ((ObserverMethodImpl)observer).getObserverMethod()).getJavaMember().getDeclaringClass().equals(subClass)) continue;
                try {
                    subClass.getMethod(observerMethod.getJavaMember().getName(), observerMethod.getJavaMember().getParameterTypes());
                    i.remove();
                }
                catch (NoSuchMethodException nsme) {}
            }
        }
    }

    public <T> Set<ObserverMethod<? super T>> resolveObservers(T event, EventMetadata metadata) {
        EventUtil.checkEventBindings(this.webBeansContext, metadata.getQualifiers());
        Type eventType = metadata.getType();
        Set<ObserverMethod<T>> observersMethods = this.filterByType(event, eventType);
        observersMethods = this.filterByQualifiers(observersMethods, metadata.getQualifiers());
        if (observersMethods.isEmpty()) {
            EventUtil.checkQualifierImplementations(metadata.getQualifiers());
        }
        return observersMethods;
    }

    private <T> Set<ObserverMethod<? super T>> filterByType(T event, Type eventType) {
        Type[] genericInts;
        if (WebBeansUtil.isExtensionEventType(eventType)) {
            return this.filterByExtensionEventType(event, eventType);
        }
        Class<?> eventClass = ClassUtil.getClass(eventType);
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        HashSet<Type> types = new HashSet<Type>();
        types.add(eventType);
        Type superClazz = eventClass.getGenericSuperclass();
        if (superClazz != null) {
            types.add(superClazz);
        }
        if ((genericInts = eventClass.getGenericInterfaces()) != null && genericInts.length > 0) {
            for (Type genericInt : genericInts) {
                types.add(genericInt);
            }
        }
        Set<Type> keySet = this.observers.keySet();
        block1: for (Type type : keySet) {
            for (Type check : types) {
                if (!ClassUtil.checkEventTypeAssignability(check, type)) continue;
                Set<ObserverMethod<?>> wrappers = this.observers.get(type);
                for (ObserverMethod<?> wrapper : wrappers) {
                    matching.add(wrapper);
                }
                continue block1;
            }
        }
        return matching;
    }

    private <T> Set<ObserverMethod<? super T>> filterByExtensionEventType(T event, Type eventType) {
        Class<?> eventClass = ClassUtil.getClazz(eventType);
        HashSet<ObserverMethod<? super T>> matching = new HashSet<ObserverMethod<? super T>>();
        Set<Type> keySet = this.observers.keySet();
        for (Type type : keySet) {
            Object genericBeanEvent;
            Class<?> beanClass = null;
            Class<?> observerClass = ClassUtil.getClazz(type);
            if (observerClass == null || !observerClass.isAssignableFrom(eventClass)) continue;
            if (WebBeansUtil.isExtensionBeanEventType(eventType)) {
                if (!WebBeansUtil.isDefaultExtensionBeanEventType(observerClass)) continue;
                genericBeanEvent = (GenericBeanEvent)event;
                beanClass = genericBeanEvent.getBeanClassFor(observerClass);
                if (ClassUtil.isParametrizedType(type)) {
                    this.addToMathingWithParametrizedForBeans(type, beanClass, matching);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (WebBeansUtil.isExtensionProducerOrObserverEventType(eventType)) {
                genericBeanEvent = (GenericProducerObserverEvent)event;
                beanClass = genericBeanEvent.getBeanClass();
                Class<?> producerOrObserverReturnClass = genericBeanEvent.getProducerOrObserverType();
                if (WebBeansUtil.isDefaultExtensionProducerOrObserverEventType(observerClass)) {
                    boolean processProducerEvent = false;
                    if (observerClass.equals(ProcessProducer.class)) {
                        processProducerEvent = true;
                    }
                    if (ClassUtil.isParametrizedType(type)) {
                        this.addToMatchingWithParametrizedForProducers(processProducerEvent, type, beanClass, producerOrObserverReturnClass, matching);
                        continue;
                    }
                    this.addToMatching(type, matching);
                    continue;
                }
                if (!observerClass.isAssignableFrom(eventClass)) continue;
                if (ClassUtil.isParametrizedType(type)) {
                    this.addToMathingWithParametrizedForBeans(type, beanClass, matching);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (!observerClass.isAssignableFrom(eventClass)) continue;
            this.addToMatching(type, matching);
        }
        return matching;
    }

    private boolean checkEventTypeParameterForExtensions(Class<?> beanClass, Type observerTypeActualArg) {
        if (ClassUtil.isTypeVariable(observerTypeActualArg)) {
            Class clazzTvBound;
            TypeVariable tv = (TypeVariable)observerTypeActualArg;
            Type tvBound = tv.getBounds()[0];
            if (tvBound instanceof Class && (clazzTvBound = (Class)tvBound).isAssignableFrom(beanClass)) {
                return true;
            }
        } else {
            Class observerClass;
            if (ClassUtil.isWildCardType(observerTypeActualArg)) {
                return ClassUtil.checkRequiredTypeIsWildCard(beanClass, observerTypeActualArg);
            }
            if (observerTypeActualArg instanceof Class && (observerClass = (Class)observerTypeActualArg).isAssignableFrom(beanClass)) {
                return true;
            }
        }
        return false;
    }

    private <T> void addToMatching(Type type, Set<ObserverMethod<? super T>> matching) {
        Set<ObserverMethod<?>> wrappers = this.observers.get(type);
        for (ObserverMethod<?> wrapper : wrappers) {
            matching.add(wrapper);
        }
    }

    private <T> void addToMathingWithParametrizedForBeans(Type type, Class<?> beanClass, Set<ObserverMethod<? super T>> matching) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else if (this.checkEventTypeParameterForExtensions(beanClass, actualArgs[0])) {
            this.addToMatching(type, matching);
        }
    }

    private <T> void addToMatchingWithParametrizedForProducers(boolean processProducer, Type type, Class<?> beanClass, Class<?> producerOrObserverReturnClass, Set<ObserverMethod<? super T>> matching) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else {
            Type beanClassArg = actualArgs[1];
            Type returnClassArg = actualArgs[0];
            if (processProducer) {
                beanClassArg = actualArgs[0];
                returnClassArg = actualArgs[1];
            }
            if (this.checkEventTypeParameterForExtensions(beanClass, beanClassArg) && this.checkEventTypeParameterForExtensions(producerOrObserverReturnClass, returnClassArg)) {
                this.addToMatching(type, matching);
            }
        }
    }

    private <T> Set<ObserverMethod<? super T>> filterByQualifiers(Set<ObserverMethod<? super T>> observers, Set<Annotation> eventQualifiers) {
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        block0: for (ObserverMethod<T> observerMethod : observers) {
            Set qualifiers = observerMethod.getObservedQualifiers();
            if (qualifiers.size() > eventQualifiers.size()) continue;
            for (Annotation qualifier : qualifiers) {
                boolean found = false;
                for (Annotation inList : eventQualifiers) {
                    if (!AnnotationUtil.isCdiAnnotationEqual(inList, qualifier)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                continue block0;
            }
            matching.add(observerMethod);
        }
        return matching;
    }

    public void fireEvent(Object event, EventMetadata metadata, boolean isLifecycleEvent) {
        Set<ObserverMethod<Object>> observerMethods = this.resolveObservers(event, metadata);
        for (ObserverMethod<Object> observer : observerMethods) {
            try {
                if (isLifecycleEvent && !Extension.class.isAssignableFrom(observer.getBeanClass())) continue;
                TransactionPhase phase = observer.getTransactionPhase();
                if (phase != null && !phase.equals((Object)TransactionPhase.IN_PROGRESS)) {
                    TransactionService transactionService = this.webBeansContext.getService(TransactionService.class);
                    if (transactionService != null) {
                        transactionService.registerTransactionSynchronization(phase, observer, event);
                        continue;
                    }
                    if (observer instanceof OwbObserverMethod) {
                        ((OwbObserverMethod)observer).notify(event, metadata);
                        continue;
                    }
                    observer.notify(event);
                    continue;
                }
                if (observer instanceof OwbObserverMethod) {
                    ((OwbObserverMethod)observer).notify(event, metadata);
                    continue;
                }
                observer.notify(event);
            }
            catch (WebBeansException e) {
                Throwable exc = e.getCause();
                if (exc instanceof InvocationTargetException) {
                    InvocationTargetException invt = (InvocationTargetException)exc;
                    exc = invt.getCause();
                }
                if (!RuntimeException.class.isAssignableFrom(exc.getClass())) {
                    throw new ObserverException(WebBeansLoggerFacade.getTokenString("EXCEPT_0008") + event.getClass().getName(), (Throwable)e);
                }
                RuntimeException rte = (RuntimeException)exc;
                throw rte;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }
    }

    public <T> ObserverMethod<?> getObservableMethodForAnnotatedMethod(AnnotatedMethod<?> annotatedMethod, AbstractOwbBean<T> bean) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod parameter can not be null");
        Observes observes = AnnotationUtil.getAnnotatedMethodFirstParameterAnnotation(annotatedMethod, Observes.class);
        boolean ifExist = false;
        if (observes != null && observes.notifyObserver().equals((Object)Reception.IF_EXISTS)) {
            ifExist = true;
        }
        Annotation[] observerQualifiers = bean.getWebBeansContext().getAnnotationManager().getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(annotatedMethod, Observes.class);
        Type type = AnnotationUtil.getAnnotatedMethodFirstParameterWithAnnotation(annotatedMethod, Observes.class);
        ObserverMethodImpl observer = new ObserverMethodImpl(bean, annotatedMethod, ifExist, observerQualifiers, type);
        this.addObserver(observer, type);
        return observer;
    }
}

