/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotated;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.util.ClassUtil;

class AnnotatedTypeImpl<X>
extends AbstractAnnotated
implements AnnotatedType<X> {
    private final AnnotatedType<? super X> supertype;
    private final Class<X> annotatedClass;
    private volatile State state;

    AnnotatedTypeImpl(WebBeansContext webBeansContext, Class<X> annotatedClass, AnnotatedTypeImpl<? super X> supertype) {
        super(webBeansContext, annotatedClass);
        this.supertype = supertype;
        this.annotatedClass = annotatedClass;
        if (supertype == null) {
            this.setAnnotations(annotatedClass.getDeclaredAnnotations());
        } else {
            HashSet<Class<? extends Annotation>> annotationTypes = new HashSet<Class<? extends Annotation>>();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (Annotation annotation : annotatedClass.getDeclaredAnnotations()) {
                annotations.add(annotation);
                annotationTypes.add(annotation.annotationType());
            }
            for (Annotation annotation : supertype.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(Inherited.class) || annotationTypes.contains(annotation.annotationType())) continue;
                annotations.add(annotation);
                annotationTypes.add(annotation.annotationType());
            }
            this.setAnnotations(annotations.toArray(new Annotation[annotations.size()]));
        }
    }

    public Class<X> getJavaClass() {
        return this.annotatedClass;
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.getState().constructors;
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this.getState().fields;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.getState().methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State getState() {
        State result = this.state;
        if (result == null) {
            AnnotatedTypeImpl annotatedTypeImpl = this;
            synchronized (annotatedTypeImpl) {
                result = this.state;
                if (result == null) {
                    this.state = result = new State();
                }
            }
        }
        return result;
    }

    private class State {
        private final Set<AnnotatedConstructor<X>> constructors;
        private final Set<AnnotatedField<? super X>> fields;
        private final Set<AnnotatedMethod<? super X>> methods;

        private State() {
            Constructor constructor;
            Constructor[] decCtxs = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredConstructors(AnnotatedTypeImpl.this.annotatedClass);
            HashSet constructors = new HashSet();
            HashSet fields = new HashSet();
            HashSet<AnnotatedMethod> methods = new HashSet<AnnotatedMethod>();
            this.constructors = Collections.unmodifiableSet(constructors);
            this.fields = Collections.unmodifiableSet(fields);
            this.methods = Collections.unmodifiableSet(methods);
            for (Constructor ct : decCtxs) {
                if (ct.isSynthetic()) continue;
                AnnotatedConstructorImpl ac = new AnnotatedConstructorImpl(AnnotatedTypeImpl.this.getWebBeansContext(), ct, AnnotatedTypeImpl.this);
                constructors.add(ac);
            }
            if (constructors.isEmpty() && (constructor = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredConstructor(AnnotatedTypeImpl.this.annotatedClass, new Class[0])) != null) {
                constructors.add(new AnnotatedConstructorImpl(AnnotatedTypeImpl.this.getWebBeansContext(), constructor, AnnotatedTypeImpl.this));
            }
            Field[] decFields = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredFields(AnnotatedTypeImpl.this.annotatedClass);
            Method[] decMethods = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredMethods(AnnotatedTypeImpl.this.annotatedClass);
            for (Field field : decFields) {
                if (field.isSynthetic()) continue;
                AnnotatedFieldImpl af = new AnnotatedFieldImpl(AnnotatedTypeImpl.this.getWebBeansContext(), field, AnnotatedTypeImpl.this);
                fields.add(af);
            }
            for (AccessibleObject accessibleObject : decMethods) {
                if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
                AnnotatedMethodImpl am = new AnnotatedMethodImpl(AnnotatedTypeImpl.this.getWebBeansContext(), (Method)accessibleObject, AnnotatedTypeImpl.this);
                methods.add(am);
            }
            if (AnnotatedTypeImpl.this.supertype != null) {
                fields.addAll(AnnotatedTypeImpl.this.supertype.getFields());
                for (AnnotatedMethod method : AnnotatedTypeImpl.this.supertype.getMethods()) {
                    if (this.isOverridden(method)) continue;
                    methods.add(method);
                }
            }
        }

        private boolean isOverridden(AnnotatedMethod<? super X> superclassMethod) {
            for (AnnotatedMethod annotatedMethod : this.methods) {
                if (!ClassUtil.isOverridden(annotatedMethod.getJavaMember(), superclassMethod.getJavaMember())) continue;
                return true;
            }
            return false;
        }
    }
}

