/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotated;

abstract class AbstractAnnotatedMember<X>
extends AbstractAnnotated
implements AnnotatedMember<X> {
    private final AnnotatedType<X> declaringType;
    protected final Member javaMember;

    AbstractAnnotatedMember(WebBeansContext webBeansContext, Type baseType, Member javaMember, AnnotatedType<X> declaringType) {
        super(webBeansContext, baseType);
        if (declaringType == null) {
            throw new IllegalArgumentException("declaringType cannot be null");
        }
        this.javaMember = javaMember;
        this.declaringType = declaringType;
    }

    public AnnotatedType<X> getDeclaringType() {
        return this.declaringType;
    }

    public Member getJavaMember() {
        return this.javaMember;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.javaMember.getModifiers());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(",");
        builder.append("Java Member Name : " + this.javaMember.getName());
        return builder.toString();
    }
}

