/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.util.ExceptionUtil;

public abstract class AbstractInvocationContext<T>
implements InvocationContext {
    private T target;
    private Method method;
    private Object[] parameters;
    private Map<String, Object> contextData;
    private Object timer;

    public AbstractInvocationContext(T target, Method method, Object[] parameters) {
        this.target = target;
        this.method = method;
        this.parameters = parameters;
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
    }

    public AbstractInvocationContext(T target, Method method, Object[] parameters, Object timer) {
        this(target, method, parameters);
        this.timer = timer;
    }

    public T getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Object getTimer() {
        return this.timer;
    }

    public Object proceed() throws Exception {
        try {
            return this.method.invoke(this.target, this.parameters);
        }
        catch (InvocationTargetException ite) {
            throw ExceptionUtil.throwAsRuntimeException(ite.getCause());
        }
    }
}

