/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.io.Serializable;
import java.lang.reflect.Field;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.spi.ProducerFactory;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerFieldBean<T>
extends AbstractProducerBean<T> {
    private Field producerField = null;

    public ProducerFieldBean(InjectionTargetBean<?> ownerComponent, BeanAttributesImpl<T> beanAttributes, Class<T> returnType, ProducerFactory<T> producerFactory) {
        super(ownerComponent.getBeanClass(), ownerComponent.getWebBeansContext(), WebBeansType.PRODUCERFIELD, beanAttributes, returnType, producerFactory);
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = null;
        instance = super.create(creationalContext);
        this.checkNullInstance(instance);
        this.checkScopeType();
        return instance;
    }

    public Field getCreatorField() {
        return this.producerField;
    }

    public void setProducerField(Field field) {
        this.producerField = field;
    }

    protected void checkNullInstance(Object instance) {
        String errorMessage = "WebBeans producer field : %s return type in the component implementation class : %s scope must be @Dependent to create null instance";
        WebBeansUtil.checkNullInstance(instance, this.getScope(), errorMessage, this.producerField.getName(), this.getBeanClass().getName());
    }

    protected void checkScopeType() {
        String errorMessage = "WebBeans producer method : %s return type in the component implementation class : %s with passivating scope @%s must be Serializable";
        this.getWebBeansContext().getWebBeansUtil().checkSerializableScopeType(this.getScope(), ClassUtil.isClassAssignable(Serializable.class, this.getReturnType()), errorMessage, this.producerField.getName(), this.getBeanClass().getName(), this.getScope().getName());
    }

    @Override
    public boolean isPassivationCapable() {
        return this.isPassivationCapable(this.producerField.getType(), this.producerField.getModifiers());
    }

    @Override
    public String getId() {
        if (this.passivatingId == null) {
            String id = super.getId();
            this.passivatingId = id + "#" + this.producerField.toGenericString();
        }
        return this.passivatingId;
    }
}

