/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.scannotation.archiveiterator.FileIterator;
import org.scannotation.archiveiterator.Filter;
import org.scannotation.archiveiterator.JarIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDB {
    private Map<String, Set<String>> annotationIndex = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> implementsIndex = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> classIndex = new HashMap<String, Set<String>>();
    private boolean scanClassAnnotations = true;
    private boolean scanMethodAnnotations = true;
    private boolean scanParameterAnnotations = true;
    private boolean scanFieldAnnotations = true;
    private String[] ignoredPackages = new String[]{"javax", "java", "sun", "com.sun", "javassist"};

    public String[] getIgnoredPackages() {
        return this.ignoredPackages;
    }

    public void setIgnoredPackages(String[] ignoredPackages) {
        this.ignoredPackages = ignoredPackages;
    }

    public void addIgnoredPackages(String ... ignored) {
        String[] tmp = new String[this.ignoredPackages.length + ignored.length];
        int i = 0;
        for (String ign : this.ignoredPackages) {
            tmp[i++] = ign;
        }
        for (String ign : ignored) {
            tmp[i++] = ign;
        }
    }

    public void crossReferenceMetaAnnotations() throws CrossReferenceException {
        HashSet<String> unresolved = new HashSet<String>();
        HashSet<String> index = new HashSet<String>();
        index.addAll(this.annotationIndex.keySet());
        for (String annotation : index) {
            if (this.ignoreScan(annotation)) continue;
            if (this.classIndex.containsKey(annotation)) {
                for (String xref : this.classIndex.get(annotation)) {
                    this.annotationIndex.get(xref).addAll((Collection<String>)this.annotationIndex.get(annotation));
                }
                continue;
            }
            InputStream bits = Thread.currentThread().getContextClassLoader().getResourceAsStream(annotation.replace('.', '/') + ".class");
            if (bits == null) {
                unresolved.add(annotation);
                continue;
            }
            try {
                this.scanClass(bits);
            }
            catch (IOException e) {
                unresolved.add(annotation);
            }
            for (String xref : this.classIndex.get(annotation)) {
                this.annotationIndex.get(xref).addAll((Collection<String>)this.annotationIndex.get(annotation));
            }
        }
        if (unresolved.size() > 0) {
            throw new CrossReferenceException(unresolved);
        }
    }

    private boolean ignoreScan(String intf) {
        for (String ignored : this.ignoredPackages) {
            if (!intf.startsWith(ignored + ".")) continue;
            return true;
        }
        return false;
    }

    public Map<String, Set<String>> getAnnotationIndex() {
        return this.annotationIndex;
    }

    public Map<String, Set<String>> getClassIndex() {
        return this.classIndex;
    }

    public void setScanClassAnnotations(boolean scanClassAnnotations) {
        this.scanClassAnnotations = scanClassAnnotations;
    }

    public void setScanMethodAnnotations(boolean scanMethodAnnotations) {
        this.scanMethodAnnotations = scanMethodAnnotations;
    }

    public void setScanParameterAnnotations(boolean scanParameterAnnotations) {
        this.scanParameterAnnotations = scanParameterAnnotations;
    }

    public void setScanFieldAnnotations(boolean scanFieldAnnotations) {
        this.scanFieldAnnotations = scanFieldAnnotations;
    }

    public void scanArchives(String ... urls) throws IOException {
        for (String urlPath : urls) {
            this.scanUrlPath(urlPath);
        }
    }

    private void scanUrlPath(String urlPath) throws IOException {
        InputStream stream;
        JarIterator it;
        Filter filter = new Filter(){

            public boolean accepts(String filename) {
                if (filename.endsWith(".class")) {
                    if (filename.startsWith("/")) {
                        filename = filename.substring(1);
                    }
                    if (!AnnotationDB.this.ignoreScan(filename.replace('/', '.'))) {
                        return true;
                    }
                }
                return false;
            }
        };
        String jarUrlPath = this.isJarUrl(urlPath);
        if (jarUrlPath != null) {
            it = new JarIterator(new URL(this.ensureCorrectUrlFormat(jarUrlPath)).openStream(), filter);
        } else {
            File f = new File(new URL(this.ensureCorrectUrlFormat(urlPath)).getFile());
            if (!f.exists() && urlPath.contains("%20")) {
                urlPath = urlPath.replaceAll("%20", " ");
                f = new File(new URL(this.ensureCorrectUrlFormat(urlPath)).getFile());
            }
            it = new FileIterator(f, filter);
        }
        while ((stream = it.next()) != null) {
            this.scanClass(stream);
        }
    }

    private String isJarUrl(String urlPath) {
        int jarColon = urlPath.indexOf(58);
        if (urlPath.endsWith("!/") && jarColon > 0) {
            urlPath = urlPath.substring(jarColon + 1, urlPath.length() - 2);
            return urlPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanClass(InputStream bits) throws IOException {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(bits));
        try {
            ClassFile cf = new ClassFile(dstream);
            this.classIndex.put(cf.getName(), new HashSet());
            if (this.scanClassAnnotations) {
                this.scanClass(cf);
            }
            if (this.scanMethodAnnotations || this.scanParameterAnnotations) {
                this.scanMethods(cf);
            }
            if (this.scanFieldAnnotations) {
                this.scanFields(cf);
            }
            if (cf.getInterfaces() != null) {
                HashSet intfs = new HashSet();
                Collections.addAll(intfs, cf.getInterfaces());
                this.implementsIndex.put(cf.getName(), intfs);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            dstream.close();
            bits.close();
            throw throwable;
        }
        dstream.close();
        bits.close();
    }

    protected void scanClass(ClassFile cf) {
        String className = cf.getName();
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        if (visible != null) {
            this.populate(visible.getAnnotations(), className);
        }
        if (invisible != null) {
            this.populate(invisible.getAnnotations(), className);
        }
    }

    protected void scanMethods(ClassFile cf) {
        List methods = cf.getMethods();
        if (methods == null) {
            return;
        }
        for (Object obj : methods) {
            MethodInfo method = (MethodInfo)obj;
            if (this.scanMethodAnnotations) {
                AnnotationsAttribute visible = (AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations");
                AnnotationsAttribute invisible = (AnnotationsAttribute)method.getAttribute("RuntimeInvisibleAnnotations");
                if (visible != null) {
                    this.populate(visible.getAnnotations(), cf.getName());
                }
                if (invisible != null) {
                    this.populate(invisible.getAnnotations(), cf.getName());
                }
            }
            if (!this.scanParameterAnnotations) continue;
            ParameterAnnotationsAttribute paramsVisible = (ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations");
            ParameterAnnotationsAttribute paramsInvisible = (ParameterAnnotationsAttribute)method.getAttribute("RuntimeInvisibleParameterAnnotations");
            if (paramsVisible != null && paramsVisible.getAnnotations() != null) {
                for (Annotation[] anns : paramsVisible.getAnnotations()) {
                    this.populate(anns, cf.getName());
                }
            }
            if (paramsInvisible == null || paramsInvisible.getAnnotations() == null) continue;
            for (Annotation[] anns : paramsInvisible.getAnnotations()) {
                this.populate(anns, cf.getName());
            }
        }
    }

    protected void scanFields(ClassFile cf) {
        List fields = cf.getFields();
        if (fields == null) {
            return;
        }
        for (Object obj : fields) {
            FieldInfo field = (FieldInfo)obj;
            AnnotationsAttribute visible = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
            AnnotationsAttribute invisible = (AnnotationsAttribute)field.getAttribute("RuntimeInvisibleAnnotations");
            if (visible != null) {
                this.populate(visible.getAnnotations(), cf.getName());
            }
            if (invisible == null) continue;
            this.populate(invisible.getAnnotations(), cf.getName());
        }
    }

    protected void populate(Annotation[] annotations, String className) {
        if (annotations == null) {
            return;
        }
        Set<String> classAnnotations = this.classIndex.get(className);
        for (Annotation ann : annotations) {
            Set<String> classes = this.annotationIndex.get(ann.getTypeName());
            if (classes == null) {
                classes = new HashSet<String>();
                this.annotationIndex.put(ann.getTypeName(), classes);
            }
            classes.add(className);
            classAnnotations.add(ann.getTypeName());
        }
    }

    public void outputAnnotationIndex(PrintWriter writer) {
        for (String ann : this.annotationIndex.keySet()) {
            writer.print(ann);
            writer.print(": ");
            Set<String> classes = this.annotationIndex.get(ann);
            Iterator<String> it = classes.iterator();
            while (it.hasNext()) {
                writer.print(it.next());
                if (!it.hasNext()) continue;
                writer.print(", ");
            }
            writer.println();
        }
    }

    private String ensureCorrectUrlFormat(String url) {
        if (!url.startsWith("file:/")) {
            url = "file:/" + url;
        }
        return url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrossReferenceException
    extends Exception {
        private static final long serialVersionUID = 8012802335134828909L;
        private Set<String> unresolved;

        public CrossReferenceException(Set<String> unresolved) {
            super("cannot resolve classes " + unresolved.toString());
            this.unresolved = unresolved;
        }

        public Set<String> getUnresolved() {
            return this.unresolved;
        }
    }
}

