/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ExtensionLoader {
    private final Map<Bean<?>, Object> extensions = new ConcurrentHashMap();
    private final Set<Class<? extends Extension>> extensionClasses = new HashSet<Class<? extends Extension>>();
    private final BeanManagerImpl manager;
    private final WebBeansContext webBeansContext;

    public ExtensionLoader(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.manager = this.webBeansContext.getBeanManagerImpl();
    }

    @Deprecated
    public static ExtensionLoader getInstance() {
        return WebBeansContext.getInstance().getExtensionLoader();
    }

    public void loadExtensionServices() {
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class, WebBeansUtil.getCurrentClassLoader());
        for (Extension ext : loader) {
            if (this.extensionClasses.contains(ext.getClass())) continue;
            this.extensionClasses.add(ext.getClass());
            try {
                this.addExtension(ext);
            }
            catch (Exception e) {
                throw new WebBeansException("Error occurred while reading Extension service list", e);
            }
        }
    }

    public <T> T getBeanInstance(Bean<T> bean) {
        Asserts.assertNotNull(bean, "bean parameter cannot be null");
        if (this.extensions.containsKey(bean)) {
            return (T)this.extensions.get(bean);
        }
        return null;
    }

    public void addExtension(Extension ext) {
        ExtensionBean<?> bean = this.webBeansContext.getWebBeansUtil().createExtensionComponent(ext.getClass());
        this.extensions.put(bean, ext);
        this.manager.addBean(bean);
    }

    public void clear() {
        this.extensions.clear();
        this.extensionClasses.clear();
    }
}

