/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotated;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;

class AnnotatedTypeImpl<X>
extends AbstractAnnotated
implements AnnotatedType<X> {
    private final Class<X> annotatedClass;
    private Set<AnnotatedConstructor<X>> constructors = null;
    private Set<AnnotatedField<? super X>> fields = null;
    private Set<AnnotatedMethod<? super X>> methods = null;

    AnnotatedTypeImpl(WebBeansContext webBeansContext, Class<X> annotatedClass) {
        super(webBeansContext, annotatedClass);
        this.annotatedClass = annotatedClass;
        this.setAnnotations(annotatedClass.getDeclaredAnnotations());
    }

    private synchronized void init() {
        if (this.constructors == null) {
            this.constructors = new HashSet<AnnotatedConstructor<X>>();
            this.fields = new HashSet<AnnotatedField<? super X>>();
            this.methods = new HashSet<AnnotatedMethod<? super X>>();
            Field[] decFields = this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredFields(this.annotatedClass);
            Method[] decMethods = this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredMethods(this.annotatedClass);
            Constructor[] decCtxs = this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredConstructors(this.annotatedClass);
            for (Field field : decFields) {
                AnnotatedFieldImpl af = new AnnotatedFieldImpl(this.getWebBeansContext(), field, this);
                this.fields.add(af);
            }
            for (AccessibleObject accessibleObject : decMethods) {
                AnnotatedMethodImpl am = new AnnotatedMethodImpl(this.getWebBeansContext(), (Method)accessibleObject, this);
                this.methods.add(am);
            }
            for (AccessibleObject accessibleObject : decCtxs) {
                AnnotatedConstructorImpl ac = new AnnotatedConstructorImpl(this.getWebBeansContext(), accessibleObject, this);
                this.constructors.add(ac);
            }
        }
    }

    public Class<X> getJavaClass() {
        return this.annotatedClass;
    }

    void addAnnotatedConstructor(AnnotatedConstructor<X> constructor) {
        if (this.constructors == null) {
            this.init();
        }
        this.constructors.add(constructor);
    }

    void addAnnotatedField(AnnotatedField<? super X> field) {
        if (this.constructors == null) {
            this.init();
        }
        this.fields.add(field);
    }

    void addAnnotatedMethod(AnnotatedMethod<? super X> method) {
        if (this.constructors == null) {
            this.init();
        }
        this.methods.add(method);
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        if (this.constructors == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.constructors);
    }

    public Set<AnnotatedField<? super X>> getFields() {
        if (this.constructors == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        if (this.constructors == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.methods);
    }
}

