/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept.webbeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableField;
import org.apache.webbeans.inject.InjectableMethods;
import org.apache.webbeans.intercept.OwbInterceptor;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class WebBeansInterceptor<T>
extends AbstractOwbBean<T>
implements OwbInterceptor<T> {
    private Map<Class<? extends Annotation>, Annotation> interceptorBindingSet = new HashMap<Class<? extends Annotation>, Annotation>();
    private Class<?> clazz;
    private AbstractInjectionTargetBean<T> delegateBean;
    private final WebBeansContext webBeansContext;

    public WebBeansInterceptor(AbstractInjectionTargetBean<T> delegateBean) {
        super(WebBeansType.INTERCEPTOR, delegateBean.getReturnType(), delegateBean.getWebBeansContext());
        this.delegateBean = delegateBean;
        this.clazz = this.getDelegate().getReturnType();
        this.webBeansContext = delegateBean.getWebBeansContext();
    }

    @Override
    public AbstractOwbBean<T> getDelegate() {
        return this.delegateBean;
    }

    @Override
    public AnnotatedType<T> getAnnotatedType() {
        return this.delegateBean.getAnnotatedType();
    }

    @Override
    public void addInterceptorBinding(Class<? extends Annotation> binding, Annotation annot) {
        Method[] methods;
        for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(binding)) {
            Class<?> clazz = method.getReturnType();
            if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getAnnotations(), Nonbinding.class)) continue;
            throw new WebBeansConfigurationException("Interceptor definition class : " + this.getClazz().getName() + " @InterceptorBinding : " + binding.getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
        }
        this.interceptorBindingSet.put(binding, annot);
    }

    @Override
    public boolean hasBinding(List<Class<? extends Annotation>> bindingTypes, List<Annotation> annots) {
        if (bindingTypes == null || annots == null) {
            return false;
        }
        if (bindingTypes.size() != annots.size()) {
            return false;
        }
        if (bindingTypes.size() == 0) {
            return false;
        }
        for (Annotation ann : this.getInterceptorBindings()) {
            Class<? extends Annotation> bindingType = ann.annotationType();
            int index = bindingTypes.indexOf(bindingType);
            if (index < 0) {
                return false;
            }
            if (AnnotationUtil.isQualifierEqual(ann, annots.get(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public Set<Interceptor<?>> getMetaInceptors() {
        HashSet set = new HashSet();
        Set<Annotation> keys = this.getInterceptorBindings();
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        for (Annotation key : keys) {
            Class<? extends Annotation> clazzAnnot = key.annotationType();
            Set<Annotation> declared = null;
            Annotation[] anns = null;
            if (this.webBeansContext.getBeanManagerImpl().hasInterceptorBindingType(clazzAnnot)) {
                declared = this.webBeansContext.getBeanManagerImpl().getInterceptorBindingTypeMetaAnnotations(clazzAnnot);
                anns = new Annotation[declared.size()];
                anns = declared.toArray(anns);
            } else if (annotationManager.hasInterceptorBindingMetaAnnotation(clazzAnnot.getDeclaredAnnotations())) {
                anns = annotationManager.getInterceptorBindingMetaAnnotations(clazzAnnot.getDeclaredAnnotations());
            }
            if (anns == null || anns.length <= 0) continue;
            Set<Interceptor<?>> metas = this.webBeansContext.getWebBeansInterceptorConfig().findDeployedWebBeansInterceptor(anns, this.webBeansContext);
            set.addAll(metas);
            for (Annotation ann : anns) {
                Annotation[] simple = new Annotation[]{ann};
                metas = this.webBeansContext.getWebBeansInterceptorConfig().findDeployedWebBeansInterceptor(simple, this.webBeansContext);
                set.addAll(metas);
            }
        }
        return set;
    }

    @Override
    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Set<Annotation> getInterceptorBindings() {
        HashSet<Annotation> set = new HashSet<Annotation>();
        Set<Class<? extends Annotation>> keySet = this.interceptorBindingSet.keySet();
        Iterator<Class<? extends Annotation>> itSet = keySet.iterator();
        while (itSet.hasNext()) {
            set.add(this.interceptorBindingSet.get(itSet.next()));
        }
        return set;
    }

    private Method getMethod(InterceptionType type) {
        Method method = null;
        if (type.equals((Object)InterceptionType.AROUND_INVOKE)) {
            method = WebBeansUtil.checkAroundInvokeAnnotationCriterias(this.getClazz(), AroundInvoke.class);
        } else if (type.equals((Object)InterceptionType.AROUND_TIMEOUT)) {
            method = WebBeansUtil.checkAroundInvokeAnnotationCriterias(this.getClazz(), AroundTimeout.class);
        } else {
            Class<? extends Annotation> interceptorTypeAnnotationClazz = this.webBeansContext.getInterceptorUtil().getInterceptorAnnotationClazz(type);
            method = this.getWebBeansContext().getWebBeansUtil().checkCommonAnnotationCriterias(this.getClazz(), interceptorTypeAnnotationClazz, true);
        }
        return method;
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        Context context = this.webBeansContext.getBeanManagerImpl().getContext(this.getScope());
        Object actualInstance = context.get(this.delegateBean, creationalContext);
        Object proxy = this.webBeansContext.getJavassistProxyFactory().createDependentScopedBeanProxy(this.delegateBean, actualInstance, creationalContext);
        return (T)proxy;
    }

    @Override
    public void setInjections(Object proxy, CreationalContext<?> creationalContext) {
        ManagedBean delegate = (ManagedBean)this.delegateBean;
        Set<Field> injectedFields = delegate.getInjectedFromSuperFields();
        for (Field injectedField : injectedFields) {
            this.injectField(injectedField, proxy, creationalContext);
        }
        Set<Method> injectedMethods = delegate.getInjectedFromSuperMethods();
        for (Method injectedMethod : injectedMethods) {
            this.injectMethod(injectedMethod, proxy, creationalContext);
        }
        injectedFields = delegate.getInjectedFields();
        for (Field injectedField : injectedFields) {
            this.injectField(injectedField, proxy, creationalContext);
        }
        injectedMethods = delegate.getInjectedMethods();
        for (Method injectedMethod : injectedMethods) {
            this.injectMethod(injectedMethod, proxy, creationalContext);
        }
    }

    private void injectField(Field field, Object instance, CreationalContext<?> creationalContext) {
        InjectableField f = new InjectableField(field, instance, this.delegateBean, creationalContext);
        f.doInjection();
    }

    private void injectMethod(Method method, Object instance, CreationalContext<?> creationalContext) {
        InjectableMethods m = new InjectableMethods(method, instance, this.delegateBean, creationalContext);
        m.doInjection();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegateBean.getQualifiers();
    }

    @Override
    public String getName() {
        return this.delegateBean.getName();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.delegateBean.getScope();
    }

    @Override
    public Set<Type> getTypes() {
        return this.delegateBean.getTypes();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegateBean.getInjectionPoints();
    }

    @Override
    public String toString() {
        return "WebBeans Interceptor with class : [" + this.clazz.getName() + "]";
    }

    @Override
    public boolean isNullable() {
        return this.delegateBean.isNullable();
    }

    @Override
    public boolean isSerializable() {
        return this.delegateBean.isSerializable();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.delegateBean.getBeanClass();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.delegateBean.getStereotypes();
    }

    public Object intercept(InterceptionType type, T instance, InvocationContext ctx) {
        Method method = this.getMethod(type);
        try {
            method.invoke(instance, ctx);
        }
        catch (Exception e) {
            this.getLogger().error(e);
            throw new WebBeansException(e);
        }
        return null;
    }

    public boolean intercepts(InterceptionType type) {
        Method method = this.getMethod(type);
        return method != null;
    }

    @Override
    public boolean isAlternative() {
        return this.delegateBean.isAlternative();
    }

    @Override
    public boolean isPassivationCapable() {
        return this.delegateBean.isPassivationCapable();
    }

    @Override
    public void validatePassivationDependencies() {
        this.delegateBean.validatePassivationDependencies();
    }
}

