/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.AroundInvoke;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.context.creational.EjbInterceptorContext;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.OpenWebBeansEjbLCAPlugin;

public class InterceptorDataImpl
implements InterceptorData {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorDataImpl.class);
    private Method aroundInvoke = null;
    private Method aroundTimeout = null;
    private Method postConstruct = null;
    private Method postActivate = null;
    private Method preDestroy = null;
    private Method prePassivate = null;
    private Interceptor<?> webBeansInterceptor;
    private boolean definedInInterceptorClass;
    private boolean definedInMethod;
    private Method annotatedMethod;
    private boolean isDefinedWithWebBeansInterceptor;
    private Class<?> interceptorClass = null;
    private WebBeansDecoratorInterceptor decoratorInterceptor = null;
    private final WebBeansContext webBeansContext;

    public InterceptorDataImpl(boolean isDefinedWithWebBeansInterceptor, WebBeansContext webBeansContext) {
        this(isDefinedWithWebBeansInterceptor, null, webBeansContext);
    }

    public InterceptorDataImpl(boolean isDefinedWithWebBeansInterceptor, WebBeansDecoratorInterceptor decoratorInterceptor, WebBeansContext webBeansContext) {
        this.isDefinedWithWebBeansInterceptor = isDefinedWithWebBeansInterceptor;
        this.decoratorInterceptor = decoratorInterceptor;
        this.webBeansContext = webBeansContext;
    }

    @Override
    public Class<?> getInterceptorClass() {
        return this.interceptorClass;
    }

    @Override
    public void setInterceptorClass(Class<?> clazz) {
        this.interceptorClass = clazz;
    }

    @Override
    public void setInterceptorMethod(Method m, Class<? extends Annotation> annotation) {
        OpenWebBeansEjbLCAPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbLCAPlugin();
        Class<? extends Annotation> prePassivateClass = null;
        Class<? extends Annotation> postActivateClass = null;
        Class<? extends Annotation> aroundTimeoutClass = null;
        if (null != ejbPlugin) {
            prePassivateClass = ejbPlugin.getPrePassivateClass();
            postActivateClass = ejbPlugin.getPostActivateClass();
            aroundTimeoutClass = ejbPlugin.getAroundTimeoutClass();
        }
        if (annotation.equals(AroundInvoke.class)) {
            this.setAroundInvoke(m);
        } else if (annotation.equals(PostConstruct.class)) {
            this.setPostConstruct(m);
        } else if (annotation.equals(PreDestroy.class)) {
            this.setPreDestroy(m);
        } else if (null != ejbPlugin && annotation.equals(prePassivateClass)) {
            this.setPrePassivate(m);
        } else if (null != ejbPlugin && annotation.equals(postActivateClass)) {
            this.setPostActivate(m);
        } else if (null != ejbPlugin && annotation.equals(aroundTimeoutClass)) {
            this.setAroundTimeout(m);
        }
    }

    public void setAroundInvoke(Method m) {
        this.aroundInvoke = m;
    }

    public void setAroundTimeout(Method m) {
        this.aroundTimeout = m;
    }

    protected void setPostConstruct(Method m) {
        this.postConstruct = m;
    }

    protected void setPostActivate(Method m) {
        this.postActivate = m;
    }

    protected void setPreDestroy(Method m) {
        this.preDestroy = m;
    }

    protected void setPrePassivate(Method m) {
        this.prePassivate = m;
    }

    @Override
    public Method getPostConstruct() {
        return this.postConstruct;
    }

    @Override
    public Method getPostActivate() {
        return this.postActivate;
    }

    @Override
    public Method getPreDestroy() {
        return this.preDestroy;
    }

    @Override
    public Method getPrePassivate() {
        return this.prePassivate;
    }

    @Override
    public Method getAroundInvoke() {
        return this.aroundInvoke;
    }

    @Override
    public Method getAroundTimeout() {
        return this.aroundTimeout;
    }

    @Override
    public boolean isDefinedInInterceptorClass() {
        return this.definedInInterceptorClass;
    }

    @Override
    public void setDefinedInInterceptorClass(boolean definedInInterceptorClass) {
        this.definedInInterceptorClass = definedInInterceptorClass;
    }

    @Override
    public boolean isDefinedInMethod() {
        return this.definedInMethod;
    }

    @Override
    public void setDefinedInMethod(boolean definedInMethod) {
        this.definedInMethod = definedInMethod;
    }

    @Override
    public Method getInterceptorBindingMethod() {
        return this.annotatedMethod;
    }

    @Override
    public void setInterceptorBindingMethod(Method annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
    }

    @Override
    public boolean isDefinedWithWebBeansInterceptor() {
        return this.isDefinedWithWebBeansInterceptor;
    }

    @Override
    public Interceptor<?> getWebBeansInterceptor() {
        return this.webBeansInterceptor;
    }

    @Override
    public void setWebBeansInterceptor(Interceptor<?> webBeansInterceptor) {
        this.webBeansInterceptor = webBeansInterceptor;
    }

    @Override
    public Method getInterceptorMethod() {
        if (this.aroundInvoke != null) {
            return this.aroundInvoke;
        }
        if (this.aroundTimeout != null) {
            return this.aroundTimeout;
        }
        if (this.postConstruct != null) {
            return this.postConstruct;
        }
        if (this.postActivate != null) {
            return this.postActivate;
        }
        if (this.preDestroy != null) {
            return this.preDestroy;
        }
        if (this.prePassivate != null) {
            return this.prePassivate;
        }
        return null;
    }

    @Override
    public boolean isLifecycleInterceptor() {
        return this.preDestroy != null || this.postConstruct != null || this.prePassivate != null || this.postActivate != null;
    }

    @Override
    public Object createNewInstance(Object ownerInstance, CreationalContextImpl<?> ownerCreationalContext) {
        if (this.isDefinedWithWebBeansInterceptor && this.definedInInterceptorClass) {
            if (this.webBeansInterceptor == null) {
                return this.decoratorInterceptor;
            }
            Object interceptor = ownerCreationalContext.getDependentInterceptor(ownerInstance, (Contextual<?>)this.webBeansInterceptor);
            if (interceptor == null) {
                BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
                WebBeansInterceptor actualInterceptor = (WebBeansInterceptor)this.webBeansInterceptor;
                CreationalContext creationalContext = manager.createCreationalContext(actualInterceptor);
                interceptor = manager.getReference(actualInterceptor, actualInterceptor.getBeanClass(), creationalContext);
                actualInterceptor.setInjections(interceptor, creationalContext);
                ownerCreationalContext.addDependent(ownerInstance, (WebBeansInterceptor)this.webBeansInterceptor, interceptor);
            }
            return interceptor;
        }
        Object interceptor = null;
        if (this.definedInInterceptorClass) {
            EjbInterceptorContext ctx = ownerCreationalContext.getEjbInterceptor(ownerInstance, this.interceptorClass);
            if (ctx == null) {
                interceptor = this.webBeansContext.getWebBeansUtil().newInstanceForced(this.interceptorClass);
                try {
                    OWBInjector injector = new OWBInjector(this.webBeansContext);
                    injector.inject(interceptor);
                    ctx = new EjbInterceptorContext();
                    ctx.setInjectorInstance(injector);
                    ctx.setInterceptorInstance(interceptor);
                    ctx.setInterceptorClass(this.interceptorClass);
                }
                catch (Exception e) {
                    logger.error("ERROR_0022", e, this.interceptorClass);
                }
                ownerCreationalContext.addEjbInterceptor(ownerInstance, ctx);
            } else {
                interceptor = ctx.getInterceptorInstance();
            }
        }
        return interceptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (null != this.webBeansInterceptor) {
            sb.append("webBeansInterceptor: [").append(this.webBeansInterceptor.getBeanClass()).append("]");
        }
        sb.append(" aroundInvoke  [").append(this.aroundInvoke).append("]");
        sb.append(" aroundTimeout [").append(this.aroundTimeout).append("]");
        sb.append(" postConstruct [").append(this.postConstruct).append("]");
        sb.append(" preDestroy    [").append(this.preDestroy).append("]");
        sb.append(" postActivate  [").append(this.postActivate).append("]");
        sb.append(" prePassivate  [").append(this.prePassivate).append("]");
        return sb.toString();
    }
}

