/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.el;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;

public class ELContextStore {
    private static ThreadLocal<ELContextStore> contextStores = new ThreadLocal();
    private Map<Bean<?>, CreationalStore> dependentObjects = new HashMap();
    private Map<String, Bean<?>> beanNameToDependentBeanMapping = new HashMap();
    private Map<String, Object> normalScopedObjects = new HashMap<String, Object>();
    private BeanManagerImpl beanManager;

    public static ELContextStore getInstance(boolean createIfNotExist) {
        ELContextStore store = contextStores.get();
        if (store == null && createIfNotExist) {
            store = new ELContextStore();
            contextStores.set(store);
        }
        return store;
    }

    public Object findBeanByName(String name) {
        Object cachedBean = this.normalScopedObjects.get(name);
        if (cachedBean != null) {
            return cachedBean;
        }
        Bean<?> dependentBean = this.beanNameToDependentBeanMapping.get(name);
        if (dependentBean == null) {
            return null;
        }
        CreationalStore cs = this.dependentObjects.get(dependentBean);
        if (cs != null) {
            return cs.getObject();
        }
        return null;
    }

    private ELContextStore() {
    }

    public void addDependent(Bean<?> bean, Object dependent, CreationalContext<?> creationalContext) {
        this.dependentObjects.put(bean, new CreationalStore(dependent, creationalContext));
        this.beanNameToDependentBeanMapping.put(bean.getName(), bean);
    }

    public Object getDependent(Bean<?> bean) {
        CreationalStore sc = this.dependentObjects.get(bean);
        return sc != null ? sc.getObject() : null;
    }

    public void addNormalScoped(String beanName, Object contextualInstance) {
        this.normalScopedObjects.put(beanName, contextualInstance);
    }

    public BeanManagerImpl getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = WebBeansContext.getInstance().getBeanManagerImpl();
        }
        return this.beanManager;
    }

    public void destroyDependents() {
        Set<Bean<?>> beans = this.dependentObjects.keySet();
        Iterator<Bean<?>> i$ = beans.iterator();
        while (i$.hasNext()) {
            Bean<?> bean;
            Bean<?> o = bean = i$.next();
            CreationalStore store = this.dependentObjects.get(bean);
            o.destroy(store.getObject(), store.getCreational());
        }
        this.dependentObjects.clear();
        this.beanNameToDependentBeanMapping.clear();
    }

    public void destroyELContextStore() {
        this.beanManager = null;
        this.normalScopedObjects.clear();
        contextStores.set(null);
        contextStores.remove();
    }

    private static class CreationalStore {
        private Object object;
        private CreationalContext<?> creational;

        public CreationalStore(Object object, CreationalContext<?> creational) {
            this.object = object;
            this.creational = creational;
        }

        public Object getObject() {
            return this.object;
        }

        public CreationalContext<?> getCreational() {
            return this.creational;
        }
    }
}

