/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.CustomContextImpl;
import org.apache.webbeans.context.CustomPassivatingContextImpl;
import org.apache.webbeans.context.type.ContextTypes;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContextsService;

public final class ContextFactory {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ContextFactory.class);
    private final WebBeansContext webBeansContext;
    private ContextsService contextsService = null;

    public ContextFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    private ContextsService getContextsService() {
        if (this.contextsService == null) {
            this.contextsService = this.webBeansContext.getService(ContextsService.class);
        }
        return this.contextsService;
    }

    public void initRequestContext(Object request) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(RequestScoped.class, request);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public Context getCustomContext(Context context) {
        if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(context.getScope())) {
            return new CustomPassivatingContextImpl(context);
        }
        return new CustomContextImpl(context);
    }

    public void destroyRequestContext(Object request) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(RequestScoped.class, request);
    }

    public void initSessionContext(Object session) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(SessionScoped.class, session);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void destroySessionContext(Object session) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(SessionScoped.class, session);
    }

    public void initApplicationContext(Object parameter) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(ApplicationScoped.class, parameter);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void destroyApplicationContext(Object parameter) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(ApplicationScoped.class, parameter);
    }

    public void initSingletonContext(Object parameter) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(Singleton.class, parameter);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void destroySingletonContext(Object parameter) {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(Singleton.class, parameter);
    }

    public void initConversationContext(Object context) {
        try {
            ContextsService contextService = this.getContextsService();
            contextService.startContext(ConversationScoped.class, context);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void destroyConversationContext() {
        ContextsService contextService = this.getContextsService();
        contextService.endContext(ConversationScoped.class, null);
    }

    public Context getStandardContext(ContextTypes type) throws ContextNotActiveException {
        ContextsService contextService = this.getContextsService();
        return this.getStandardContext(contextService, type);
    }

    public Context getStandardContext(ContextsService contextService, ContextTypes type) throws ContextNotActiveException {
        Context context = null;
        switch (type.getCardinal()) {
            case 0: {
                context = contextService.getCurrentContext(RequestScoped.class);
                break;
            }
            case 1: {
                context = contextService.getCurrentContext(SessionScoped.class);
                break;
            }
            case 2: {
                context = contextService.getCurrentContext(ApplicationScoped.class);
                break;
            }
            case 3: {
                context = contextService.getCurrentContext(ConversationScoped.class);
                break;
            }
            case 4: {
                context = contextService.getCurrentContext(Dependent.class);
                break;
            }
            case 5: {
                context = contextService.getCurrentContext(Singleton.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("There is no such a standard context with context id=" + type.getCardinal());
            }
        }
        return context;
    }

    public Context getStandardContext(Class<? extends Annotation> scopeType) {
        ContextsService contextService = this.getContextsService();
        return contextService.getCurrentContext(scopeType);
    }

    public void activateContext(Class<? extends Annotation> scopeType) {
        ContextsService contextService = this.getContextsService();
        contextService.activateContext(scopeType);
    }

    public void deActivateContext(Class<? extends Annotation> scopeType) {
        ContextsService contextService = this.getContextsService();
        contextService.deActivateContext(scopeType);
    }
}

