/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.context.creational.DependentCreationalContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.AbstractInjectable;
import org.apache.webbeans.inject.InjectableMethods;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerMethodBean<T>
extends AbstractProducerBean<T> {
    protected Method creatorMethod;
    protected Method disposalMethod;

    public ProducerMethodBean(InjectionTargetBean<?> parent, Class<T> returnType) {
        super(WebBeansType.PRODUCERMETHOD, returnType, parent);
    }

    public Method getCreatorMethod() {
        return this.creatorMethod;
    }

    public void setCreatorMethod(Method creatorMethod) {
        this.creatorMethod = creatorMethod;
    }

    public Method getDisposalMethod() {
        return this.disposalMethod;
    }

    public void setDisposalMethod(Method disposalMethod) {
        if (this.disposalMethod != null) {
            throw new WebBeansConfigurationException("There are multiple disposal method for producer method component with name : " + this.getName() + " with implementation class " + this.getParent().getReturnType().getName() + " with disposal method name : " + disposalMethod.getName());
        }
        this.disposalMethod = disposalMethod;
    }

    @Override
    public String getId() {
        if (this.passivatingId == null) {
            String id = super.getId();
            this.passivatingId = id + "#" + this.creatorMethod.toGenericString();
        }
        return this.passivatingId;
    }

    public Type[] getActualTypeArguments() {
        Type type = this.creatorMethod.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return pType.getActualTypeArguments();
        }
        return new Type[0];
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        T instance = null;
        instance = this.createDefaultInstance(creationalContext);
        this.checkNullInstance(instance);
        this.checkScopeType();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T createDefaultInstance(CreationalContext<T> creationalContext) {
        List<DependentCreationalContext<Object>> oldDependents;
        T instance;
        block18: {
            instance = null;
            Object parentInstance = null;
            CreationalContext parentCreational = null;
            InjectableMethods m = null;
            oldDependents = AbstractInjectable.dependentInstanceOfProducerMethods.get();
            try {
                List<DependentCreationalContext<Object>> dependents;
                AbstractInjectable.dependentInstanceOfProducerMethods.set(new ArrayList());
                parentCreational = this.getManager().createCreationalContext(this.ownerComponent);
                if (!Modifier.isStatic(this.creatorMethod.getModifiers())) {
                    parentInstance = this.getParentInstance(parentCreational);
                }
                m = new InjectableMethods(this.creatorMethod, parentInstance, this, creationalContext);
                instance = m.doInjection();
                boolean isInjectionToAnotherBean = false;
                Contextual contextual = null;
                if (creationalContext instanceof CreationalContextImpl) {
                    contextual = ((CreationalContextImpl)creationalContext).getBean();
                    isInjectionToAnotherBean = contextual != this;
                }
                ThreadLocal<Object> injectionTargetInstance = AbstractInjectable.instanceUnderInjection;
                if (isInjectionToAnotherBean) {
                    if (oldDependents != null) {
                        DependentCreationalContext dependentCreational = new DependentCreationalContext(this);
                        dependentCreational.setInstance(instance);
                        dependentCreational.setDependentType(DependentCreationalContext.DependentType.BEAN);
                        oldDependents.add(dependentCreational);
                    }
                } else {
                    dependents = AbstractInjectable.dependentInstanceOfProducerMethods.get();
                    if (dependents != null) {
                        for (DependentCreationalContext dependentCreationalContext : dependents) {
                            ((CreationalContextImpl)creationalContext).addDependent(instance, dependentCreationalContext.getContextual(), dependentCreationalContext.getInstance());
                        }
                    }
                }
                if ((dependents = m.getDependentBeanParameters()) != null) {
                    Set beans = dependents.keySet();
                    for (Bean bean : beans) {
                        if (!(creationalContext instanceof CreationalContextImpl)) continue;
                        if (isInjectionToAnotherBean) {
                            if (oldDependents == null) {
                                if (injectionTargetInstance == null || injectionTargetInstance.get() == null) continue;
                                ((CreationalContextImpl)creationalContext).addDependent(injectionTargetInstance.get(), this, instance);
                                continue;
                            }
                            DependentCreationalContext dependentCreational = new DependentCreationalContext(bean);
                            dependentCreational.setInstance(dependents.get(bean));
                            dependentCreational.setDependentType(DependentCreationalContext.DependentType.BEAN);
                            oldDependents.add(dependentCreational);
                            continue;
                        }
                        ((CreationalContextImpl)creationalContext).addDependent(instance, bean, dependents.get(bean));
                    }
                }
                if (!this.getParent().getScope().equals(Dependent.class)) break block18;
            }
            catch (Throwable throwable) {
                if (this.getParent().getScope().equals(Dependent.class)) {
                    this.destroyBean(this.getParent(), parentInstance, parentCreational);
                }
                if (oldDependents != null) {
                    AbstractInjectable.dependentInstanceOfProducerMethods.set(oldDependents);
                } else {
                    AbstractInjectable.dependentInstanceOfProducerMethods.set(null);
                    AbstractInjectable.dependentInstanceOfProducerMethods.remove();
                }
                throw throwable;
            }
            this.destroyBean(this.getParent(), parentInstance, parentCreational);
        }
        if (oldDependents != null) {
            AbstractInjectable.dependentInstanceOfProducerMethods.set(oldDependents);
        } else {
            AbstractInjectable.dependentInstanceOfProducerMethods.set(null);
            AbstractInjectable.dependentInstanceOfProducerMethods.remove();
        }
        return instance;
    }

    @Override
    protected void destroyInstance(T instance, CreationalContext<T> creationalContext) {
        this.dispose(instance, creationalContext);
    }

    @Override
    public void dispose(T instance, CreationalContext<T> creationalContext) {
        this.disposeDefault(instance, creationalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeDefault(T instance, CreationalContext<T> creationalContext) {
        if (this.disposalMethod != null) {
            Map<Bean<?>, Object> dependents;
            InjectableMethods m;
            block9: {
                Object parentInstance = null;
                CreationalContext parentCreational = null;
                m = null;
                try {
                    parentCreational = this.getManager().createCreationalContext(this.ownerComponent);
                    if (!Modifier.isStatic(this.disposalMethod.getModifiers())) {
                        parentInstance = this.getParentInstance(parentCreational);
                    }
                    m = new InjectableMethods(this.disposalMethod, parentInstance, this.ownerComponent, creationalContext);
                    m.setDisposable(true);
                    m.setProducerMethodInstance(instance);
                    m.doInjection();
                    if (!this.getParent().getScope().equals(Dependent.class)) break block9;
                }
                catch (Throwable throwable) {
                    Map<Bean<?>, Object> dependents2;
                    if (this.getParent().getScope().equals(Dependent.class)) {
                        this.destroyBean(this.getParent(), parentInstance, parentCreational);
                    }
                    if ((dependents2 = m.getDependentBeanParameters()) != null) {
                        Set<Bean<?>> beans = dependents2.keySet();
                        Iterator<Bean<?>> i$ = beans.iterator();
                        while (i$.hasNext()) {
                            Bean<?> bean;
                            Bean<?> beanTt = bean = i$.next();
                            if (!(creationalContext instanceof CreationalContextImpl)) continue;
                            beanTt.destroy(dependents2.get(beanTt), creationalContext);
                        }
                    }
                    throw throwable;
                }
                this.destroyBean(this.getParent(), parentInstance, parentCreational);
            }
            if ((dependents = m.getDependentBeanParameters()) != null) {
                Set<Bean<?>> beans = dependents.keySet();
                Iterator<Bean<?>> i$ = beans.iterator();
                while (i$.hasNext()) {
                    Bean<?> bean;
                    Bean<?> beanTt = bean = i$.next();
                    if (!(creationalContext instanceof CreationalContextImpl)) continue;
                    beanTt.destroy(dependents.get(beanTt), creationalContext);
                }
            }
        }
    }

    protected void checkNullInstance(Object instance) {
        String errorMessage = "WebBeans producer method : " + this.creatorMethod.getName() + " return type in the component implementation class : " + this.ownerComponent.getReturnType().getName() + " scope type must be @Dependent to create null instance";
        WebBeansUtil.checkNullInstance(instance, this.getScope(), errorMessage);
    }

    protected void checkScopeType() {
        String errorMessage = "WebBeans producer method : " + this.creatorMethod.getName() + " return type in the component implementation class : " + this.ownerComponent.getReturnType().getName() + " with passivating scope @" + this.getScope().getName() + " must be Serializable";
        this.getWebBeansContext().getWebBeansUtil().checkSerializableScopeType(this.getScope(), this.isSerializable(), errorMessage);
    }

    @Override
    public boolean isPassivationCapable() {
        return this.isPassivationCapable(this.creatorMethod.getReturnType(), this.creatorMethod.getModifiers());
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

