/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.EventImpl;
import org.apache.webbeans.exception.WebBeansException;

public class EventBean<T>
extends AbstractOwbBean<Event<T>> {
    public static ThreadLocal<InjectionPoint> local = new ThreadLocal();

    public EventBean(WebBeansContext webBeansContext) {
        super(WebBeansType.OBSERVABLE, new TypeLiteral<Event<T>>(){}.getRawType(), webBeansContext);
    }

    @Override
    protected Event<T> createInstance(CreationalContext<Event<T>> creationalContext) {
        EventImpl instance = null;
        InjectionPoint injectionPoint = local.get();
        Type eventType = null;
        if (injectionPoint != null) {
            Type type = injectionPoint.getType();
            ParameterizedType pt = (ParameterizedType)type;
            Type[] eventActualTypeArgs = pt.getActualTypeArguments();
            eventType = eventActualTypeArgs[0];
            Annotation[] qualifiers = new Annotation[injectionPoint.getQualifiers().size()];
            qualifiers = injectionPoint.getQualifiers().toArray(qualifiers);
            try {
                instance = new EventImpl(qualifiers, eventType, this.getWebBeansContext());
            }
            catch (Exception e) {
                throw new WebBeansException("Exception in creating Event implicit component for event type : " + eventType);
            }
            finally {
                local.set(null);
                local.remove();
            }
        }
        return instance;
    }

    @Override
    public boolean isPassivationCapable() {
        return true;
    }
}

