/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Decorator;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.util.Nonbinding;
import javax.inject.Named;
import javax.inject.Scope;
import javax.interceptor.AroundInvoke;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.xml.XMLManagedBean;
import org.apache.webbeans.component.xml.XMLProducerBean;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.event.xml.BeanObserverXMLImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.definition.NonexistentFieldException;
import org.apache.webbeans.exception.definition.NonexistentTypeException;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.inject.xml.XMLInjectionModelType;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.WebBeansInterceptorConfig;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;
import org.apache.webbeans.xml.XMLSpecializesManager;
import org.apache.webbeans.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLDefinitionUtil {
    private XMLDefinitionUtil() {
    }

    public static void checkSimpleWebBeansInXML(Class<?> clazz, Element webBeanDecleration, String errorMessage) throws WebBeansConfigurationException {
        boolean found;
        Asserts.nullCheckForClass(clazz);
        if (errorMessage == null) {
            errorMessage = "XML defined simple webbeans failed. ";
        }
        int modifier = clazz.getModifiers();
        if (ClassUtil.isDefinitionConstainsTypeVariables(clazz)) {
            throw new WebBeansConfigurationException(errorMessage + "Simple WebBeans component implementation class : " + clazz.getName() + " can not be parametrized type");
        }
        if (!ClassUtil.isStatic(modifier) && ClassUtil.isInnerClazz(clazz)) {
            throw new WebBeansConfigurationException(errorMessage + "Simple WebBeans component implementation class : " + clazz.getName() + " can not be non-static inner class");
        }
        if (clazz.isAnnotationPresent(javax.interceptor.Interceptor.class) && !(found = XMLUtil.hasChildElementWithWebBeansNameSpace(webBeanDecleration, "Interceptor"))) {
            throw new WebBeansConfigurationException(errorMessage + "Simple WebBeans component implementation class : " + clazz.getName() + " must be declared as <Interceptor> element in the XML");
        }
        if (clazz.isAnnotationPresent(Decorator.class) && !(found = XMLUtil.hasChildElementWithWebBeansNameSpace(webBeanDecleration, "Decorator"))) {
            throw new WebBeansConfigurationException(errorMessage + "Simple WebBeans component implementation class : " + clazz.getName() + " must be declared as <Decorator> element in the XML");
        }
    }

    public static void checkTypeMetaDataClasses(List<Class<? extends Annotation>> typeSet, String errorMessage) {
        if (typeSet != null && !typeSet.isEmpty()) {
            for (Class<? extends Annotation> clazz : typeSet) {
                if (clazz.isAnnotationPresent(NormalScope.class) || clazz.isAnnotationPresent(Scope.class) || AnnotationUtil.isQualifierAnnotation(clazz) || AnnotationUtil.isInterceptorBindingAnnotation(clazz) || AnnotationUtil.isStereoTypeAnnotation(clazz) || clazz.equals(Named.class) || clazz.equals(Specializes.class) || clazz.equals(javax.interceptor.Interceptor.class) || clazz.equals(Decorator.class)) continue;
                throw new WebBeansConfigurationException(errorMessage + " TypeLevelMeta data configuration is failed because of the class : " + clazz.getName() + " is not applicable type");
            }
        }
    }

    public static <T> Class<? extends Annotation> defineXMLTypeMetaData(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet, Class<? extends Annotation> defineType, String errorMessage) {
        Class<? extends Annotation> metaType = null;
        Iterator<Class<? extends Annotation>> it = annotationSet.iterator();
        boolean found = false;
        while (it.hasNext()) {
            Class<? extends Annotation> temp = it.next();
            if (!temp.isAnnotationPresent(defineType)) continue;
            if (found) {
                throw new WebBeansConfigurationException(errorMessage);
            }
            metaType = temp;
            found = true;
        }
        return metaType;
    }

    public static <T> boolean defineXMLBindingType(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList, String errorMessage) {
        Iterator<Class<? extends Annotation>> it = annotationSet.iterator();
        boolean found = false;
        int i = 0;
        while (it.hasNext()) {
            Class<? extends Annotation> temp = it.next();
            if (AnnotationUtil.isQualifierAnnotation(temp)) {
                Method[] methods;
                for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(temp)) {
                    Class<?> clazz = method.getReturnType();
                    if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getAnnotations(), Nonbinding.class)) continue;
                    throw new WebBeansConfigurationException(errorMessage + "WebBeans definition class : " + component.getReturnType().getName() + " @Qualifier : " + temp.getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
                }
                if (!found) {
                    found = true;
                }
                component.addQualifier(XMLUtil.getXMLDefinedAnnotationMember(annotationElementList.get(i), temp, errorMessage));
            }
            ++i;
        }
        return found;
    }

    public static <T> void defineXMLClassLevelInterceptorType(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList, String errorMessage) {
        Iterator<Class<? extends Annotation>> it = annotationSet.iterator();
        HashSet<Annotation> bindingTypeSet = new HashSet<Annotation>();
        int i = 0;
        while (it.hasNext()) {
            Class<? extends Annotation> temp = it.next();
            if (AnnotationUtil.isInterceptorBindingAnnotation(temp)) {
                bindingTypeSet.add(XMLUtil.getXMLDefinedAnnotationMember(annotationElementList.get(i), temp, errorMessage));
            }
            ++i;
        }
        Set<Annotation> stereoTypesSet = component.getOwbStereotypes();
        Annotation[] stereoTypes = new Annotation[stereoTypesSet.size()];
        for (Annotation stero : stereoTypes = stereoTypesSet.toArray(stereoTypes)) {
            Annotation[] steroInterceptorBindings;
            if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
            for (Annotation ann : steroInterceptorBindings = AnnotationUtil.getInterceptorBindingMetaAnnotations(stero.annotationType().getDeclaredAnnotations())) {
                bindingTypeSet.add(ann);
            }
        }
        Annotation[] anns = new Annotation[bindingTypeSet.size()];
        anns = bindingTypeSet.toArray(anns);
        Set<Interceptor<?>> set = WebBeansInterceptorConfig.findDeployedWebBeansInterceptor(anns);
        WebBeansInterceptorConfig.addComponentInterceptors(set, component.getInterceptorStack());
    }

    public static <T> void defineXMLMethodLevelInterceptorType(XMLManagedBean<T> component, Method interceptorMethod, Element interceptorMethodElement, String errorMessage) {
        HashSet<Annotation> bindingTypesSet = new HashSet<Annotation>();
        NodeList ns = interceptorMethodElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element bindingType = (Element)node;
            Class<?> annot = XMLUtil.getElementJavaType(bindingType);
            Annotation bindingAnnot = XMLUtil.getXMLDefinedAnnotationMember(bindingType, annot, errorMessage);
            bindingTypesSet.add(bindingAnnot);
        }
        Annotation[] result = new Annotation[bindingTypesSet.size()];
        result = bindingTypesSet.toArray(result);
        Set<Interceptor<?>> setInterceptors = WebBeansInterceptorConfig.findDeployedWebBeansInterceptor(result);
        Iterator<Interceptor<?>> it = setInterceptors.iterator();
        List<InterceptorData> stack = component.getInterceptorStack();
        while (it.hasNext()) {
            WebBeansInterceptor interceptor = (WebBeansInterceptor)it.next();
            WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), AroundInvoke.class, false, true, stack, interceptorMethod, true);
            WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), PostConstruct.class, false, true, stack, interceptorMethod, true);
            WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), PreDestroy.class, false, true, stack, interceptorMethod, true);
        }
    }

    public static <T> void defineXMLStereoType(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet) {
        for (Class<? extends Annotation> temp : annotationSet) {
            if (!AnnotationUtil.isStereoTypeAnnotation(temp)) continue;
            component.addStereoType(JavassistProxyFactory.createNewAnnotationProxy(temp));
        }
    }

    public static <T> boolean defineXMLName(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet) {
        for (Class<? extends Annotation> temp : annotationSet) {
            if (!temp.equals(Named.class)) continue;
            return true;
        }
        return false;
    }

    public static <T> void defineXMLSpecializes(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet) {
        for (Class<? extends Annotation> temp : annotationSet) {
            if (!temp.equals(Specializes.class)) continue;
            XMLSpecializesManager.getInstance().addXMLSpecializeClass(temp);
        }
    }

    public static <T> void defineXMLInterceptors(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList, String errorMessage) {
        Iterator<Class<? extends Annotation>> it = annotationSet.iterator();
        boolean found = false;
        HashSet<Annotation> interceptorBindingTypes = new HashSet<Annotation>();
        int i = 0;
        while (it.hasNext()) {
            Class<? extends Annotation> temp = it.next();
            if (temp.equals(javax.interceptor.Interceptor.class)) {
                if (found) {
                    throw new WebBeansConfigurationException(errorMessage + "More than one <Interceptor> element exist for class : " + component.getReturnType().getName());
                }
                found = true;
            } else if (AnnotationUtil.isInterceptorBindingAnnotation(temp)) {
                Element annotationElement = annotationElementList.get(i);
                Annotation bindingAnnotation = XMLUtil.getXMLDefinedAnnotationMember(annotationElement, temp, errorMessage);
                interceptorBindingTypes.add(bindingAnnotation);
            }
            ++i;
        }
        if (interceptorBindingTypes.size() == 0) {
            throw new WebBeansConfigurationException(errorMessage + "<Interceptor> decleration must have one interceptor binding type for class : " + component.getReturnType().getName());
        }
        Annotation[] anns = new Annotation[interceptorBindingTypes.size()];
        anns = interceptorBindingTypes.toArray(anns);
        InterceptorUtil.checkLifecycleConditions(component.getReturnType(), anns, errorMessage + "Lifecycle interceptor : " + component.getReturnType().getName() + " interceptor binding type must be defined as @Target{TYPE}");
        WebBeansInterceptorConfig.configureInterceptorClass(component, anns);
    }

    public static <T> void defineXMLDecorators(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet, Element decoratorDecleration, String errorMessage) {
        Iterator<Class<? extends Annotation>> it = annotationSet.iterator();
        boolean found = false;
        while (it.hasNext()) {
            Class<? extends Annotation> temp = it.next();
            if (!temp.equals(Decorator.class)) continue;
            if (found) {
                throw new WebBeansConfigurationException(errorMessage + "More than one <Decorator> element exist");
            }
            found = true;
        }
        if (found) {
            NodeList ns = decoratorDecleration.getChildNodes();
            for (int i = 0; i < ns.getLength(); ++i) {
                Node node = ns.item(i);
                if (!(node instanceof Element)) continue;
                Element child = (Element)node;
                if (XMLUtil.getElementNameSpace(child).equals(XMLUtil.getElementNameSpace(decoratorDecleration)) && XMLUtil.isElementHasDecoratesChild(child)) {
                    Field field = ClassUtil.getFieldWithName(component.getReturnType(), child.getLocalName());
                    if (field == null) {
                        throw new NonexistentFieldException(errorMessage + "Field with name : " + child.getLocalName() + " not found in the decorator class : " + component.getReturnType().getName());
                    }
                    NodeList ns1 = child.getElementsByTagName("Decorates");
                    Element type = (Element)ns1.item(0);
                    Class<?> apType = XMLUtil.getElementJavaType(type);
                    if (!field.getType().isAssignableFrom(apType)) {
                        throw new WebBeansConfigurationException(errorMessage + "Field name : " + field.getName() + " xml defined class type must be assignable to the field actual class type");
                    }
                    XMLInjectionPointModel model = XMLUtil.getInjectionPointModel(type, errorMessage);
                    WebBeansDecoratorConfig.configureXMLDecoratorClass(component, model);
                    continue;
                }
                throw new WebBeansConfigurationException(errorMessage + "Delegate decleration must defined exactly one child element with name Decorates");
            }
        }
    }

    public static <T> XMLProducerBean<T> defineXMLProducerMethod(WebBeansXMLConfigurator configurator, XMLManagedBean<T> component, Method producesMethod, Element producerMethodElement, String errorMessage) {
        boolean producesDefined = false;
        Class<?> type = null;
        Element typeElement = null;
        Element arrayElement = null;
        ArrayList<Class<? extends Annotation>> memberLevelMetaData = new ArrayList<Class<? extends Annotation>>();
        ArrayList<Element> memberLevelElement = new ArrayList<Element>();
        ArrayList<XMLInjectionPointModel> injectedParameters = new ArrayList<XMLInjectionPointModel>();
        NodeList ns = producerMethodElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            if (XMLUtil.isElementInWebBeansNameSpaceWithName(childElement, "Produces")) {
                if (producesDefined) {
                    throw new WebBeansConfigurationException(errorMessage + "More than one <Produces> element is defined");
                }
                producesDefined = true;
                boolean definedType = false;
                NodeList nsProducer = childElement.getChildNodes();
                for (int j = 0; j < nsProducer.getLength(); ++j) {
                    Node producerNode = nsProducer.item(j);
                    if (!(producerNode instanceof Element)) continue;
                    Element producesElementChild = (Element)producerNode;
                    if (producesElementChild.getLocalName().equals("Array")) {
                        arrayElement = producesElementChild;
                        definedType = true;
                        continue;
                    }
                    type = XMLUtil.getElementJavaType(producesElementChild);
                    if (type == null) {
                        throw new NonexistentTypeException(errorMessage + "Java type : " + XMLUtil.getElementJavaClassName(producesElementChild) + " does not exist in the <Produces> element child");
                    }
                    if (type.isAnnotation()) {
                        memberLevelMetaData.add(type);
                        memberLevelElement.add(producesElementChild);
                        continue;
                    }
                    if (!type.isAssignableFrom(producesMethod.getReturnType()) && !producesMethod.getReturnType().isAssignableFrom(type)) {
                        throw new WebBeansConfigurationException(errorMessage + "Defined returned method type is not compatible for producer method name : " + producesMethod.getName() + " in class : " + component.getReturnType().getName());
                    }
                    if (definedType) {
                        throw new WebBeansConfigurationException(errorMessage + "More than one Java type in the <Produces> element");
                    }
                    typeElement = producesElementChild;
                    definedType = true;
                }
                if (definedType) continue;
                throw new WebBeansConfigurationException(errorMessage + "<Produces> element must define at least one java type child");
            }
            XMLInjectionPointModel injectionPointModel = XMLUtil.getInjectionPointModel(childElement, errorMessage);
            injectedParameters.add(injectionPointModel);
        }
        XMLProducerBean<T> producerComponentImpl = XMLDefinitionUtil.configureProducerMethod(component, producesMethod, injectedParameters, type, arrayElement, typeElement, errorMessage);
        XMLDefinitionUtil.configureProducerTypeLevelMetaData(configurator, producerComponentImpl, producesMethod, producerMethodElement, memberLevelMetaData, memberLevelElement, component, errorMessage);
        return producerComponentImpl;
    }

    private static <T> XMLProducerBean<T> configureProducerMethod(InjectionTargetBean<?> parentComponent, Method producesMethod, List<XMLInjectionPointModel> injectedParameters, Class<T> type, Element arrayElement, Element typeElement, String errorMessage) {
        XMLProducerBean<T> producerComponentImpl = new XMLProducerBean<T>(parentComponent, type);
        if (arrayElement != null) {
            XMLUtil.defineXMLProducerApiTypeFromArrayElement(producerComponentImpl, arrayElement, errorMessage);
        } else {
            XMLInjectionPointModel model = XMLUtil.getInjectionPointModel(typeElement, errorMessage);
            producerComponentImpl.setActualTypeArguments(model.getActualTypeArguments());
            producerComponentImpl.addApiType(model.getInjectionClassType());
            if (model.getInjectionClassType().isPrimitive()) {
                producerComponentImpl.setNullable(false);
            }
        }
        producerComponentImpl.addApiType(Object.class);
        producerComponentImpl.setCreatorMethod(producesMethod);
        for (XMLInjectionPointModel injectionPointModel : injectedParameters) {
            producerComponentImpl.addProducerMethodInjectionPointModel(injectionPointModel);
            producerComponentImpl.addInjectionPoint(XMLDefinitionUtil.getXMLMethodInjectionPoint(producerComponentImpl, injectionPointModel, producesMethod));
        }
        return producerComponentImpl;
    }

    private static <T> XMLProducerBean<T> configureProducerTypeLevelMetaData(WebBeansXMLConfigurator configurator, XMLProducerBean<T> producerComponentImpl, Method producesMethod, Element producerMethodElement, List<Class<? extends Annotation>> memberLevelMetaData, List<Element> memberLevelElement, XMLManagedBean<T> component, String errorMessage) {
        for (Class<? extends Annotation> memberLevelMetaDataClass : memberLevelMetaData) {
            if (memberLevelMetaDataClass.isAnnotationPresent(NormalScope.class) || AnnotationUtil.isStereoTypeAnnotation(memberLevelMetaDataClass) || memberLevelMetaDataClass.equals(Named.class)) continue;
            throw new WebBeansConfigurationException(errorMessage + "Defined annotations for producer method name : " + producesMethod.getName() + " in class : " + component.getReturnType().getName() + " is not correct");
        }
        configurator.configureProducerTypeLevelMetaData(producerComponentImpl, memberLevelMetaData, memberLevelElement, producerMethodElement);
        return producerComponentImpl;
    }

    public static <T> void defineXMLDisposalMethod(XMLManagedBean<T> component, Method disposalMethod, Element disposalMethodElement, String errorMessage) {
        boolean disposalDefined = false;
        ArrayList<Element> otherParameterElements = new ArrayList<Element>();
        XMLProducerBean producerComponent = null;
        NodeList ns = disposalMethodElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            if (XMLUtil.isElementInWebBeansNameSpaceWithName(childElement, "Disposes")) {
                if (disposalDefined) {
                    throw new WebBeansConfigurationException(errorMessage + "More than one <Disposal> element is defined for defining disposal method : " + disposalMethod.getName());
                }
                disposalDefined = true;
                Element typeElement = (Element)childElement.getChildNodes().item(0);
                XMLInjectionPointModel model = XMLUtil.getInjectionPointModel(typeElement, errorMessage);
                component.addInjectionPoint(XMLDefinitionUtil.getXMLMethodInjectionPoint(component, model, disposalMethod));
                Set<Annotation> bindingTypes = model.getBindingTypes();
                Annotation[] bindingAnns = new Annotation[bindingTypes.size()];
                bindingAnns = bindingTypes.toArray(bindingAnns);
                Set<Bean<?>> set = InjectionResolver.getInstance().implResolveByType(model.getInjectionGenericType(), bindingAnns);
                producerComponent = (XMLProducerBean)set.iterator().next();
                if (producerComponent == null) {
                    throw new UnsatisfiedResolutionException(errorMessage + "Producer method component of the disposal method : " + disposalMethod.getName() + "is not found");
                }
                producerComponent.setDisposalMethod(disposalMethod);
                continue;
            }
            otherParameterElements.add(childElement);
        }
        for (Element otherElement : otherParameterElements) {
            XMLInjectionPointModel injectionPointParamModel = XMLUtil.getInjectionPointModel(otherElement, errorMessage);
            producerComponent.addDisposalMethodInjectionPointModel(injectionPointParamModel);
        }
    }

    public static <T, K> void defineXMLObservesMethod(XMLManagedBean<T> component, Method observesMethod, Element observesMethodElement, String errorMessage) {
        component.addObservableMethod(observesMethod);
        ArrayList<Element> otherParameterElements = new ArrayList<Element>();
        BeanObserverXMLImpl beanObserver = null;
        Class<?> eventType = null;
        NodeList ns = observesMethodElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            if (XMLUtil.isElementInWebBeansNameSpaceWithName(childElement, "Observers")) {
                Element typeElement = (Element)childElement.getChildNodes().item(0);
                eventType = XMLUtil.getElementJavaType(typeElement);
                XMLInjectionPointModel model = XMLUtil.getInjectionPointModel(typeElement, errorMessage);
                component.addInjectionPoint(XMLDefinitionUtil.getXMLMethodInjectionPoint(component, model, observesMethod));
                Set<Annotation> bindingTypes = model.getBindingTypes();
                Annotation[] bindingAnns = new Annotation[bindingTypes.size()];
                bindingAnns = bindingTypes.toArray(bindingAnns);
                beanObserver = new BeanObserverXMLImpl(component, observesMethod, false, bindingAnns, null);
                beanObserver.addXMLInjectionObservesParameter(model);
                NotificationManager.getInstance().addObserver(beanObserver, eventType);
                continue;
            }
            otherParameterElements.add(childElement);
        }
        if (beanObserver != null) {
            for (Element otherElement : otherParameterElements) {
                XMLInjectionPointModel injectionPointParamModel = XMLUtil.getInjectionPointModel(otherElement, errorMessage);
                beanObserver.addXMLInjectionObservesParameter(injectionPointParamModel);
            }
        }
    }

    public static InjectionPoint getXMLMethodInjectionPoint(AbstractOwbBean<?> component, XMLInjectionPointModel model, Method method) {
        Annotation[] annots;
        Asserts.assertNotNull(model, "model parameter can not be null");
        Asserts.assertNotNull(method, "method parameter can not be null");
        for (Annotation annotation : annots = method.getAnnotations()) {
            model.addAnnotation(annotation);
        }
        model.setInjectionMember(method);
        model.setType(XMLInjectionModelType.METHOD);
        return InjectionPointFactory.getXMLInjectionPointData(component, model);
    }
}

