/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.AroundInvoke;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.config.inheritance.IBeanInheritedMetaData;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataComparator;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class WebBeansInterceptorConfig {
    private static WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansInterceptorConfig.class);

    private WebBeansInterceptorConfig() {
    }

    public static <T> void configureInterceptorClass(AbstractInjectionTargetBean<T> delegate, Annotation[] interceptorBindingTypes) {
        if (delegate.getScope() != Dependent.class && logger.wblWillLogWarn()) {
            logger.warn("WARN_0005_1", delegate.getBeanClass().getName());
        }
        if (delegate.getName() != null && logger.wblWillLogWarn()) {
            logger.warn("WARN_0005_2", delegate.getBeanClass().getName());
        }
        if (delegate.isAlternative() && logger.wblWillLogWarn()) {
            logger.warn("WARN_0005_3", delegate.getBeanClass().getName());
        }
        logger.debug("Configuring interceptor class : [{0}]", delegate.getReturnType());
        WebBeansInterceptor<T> interceptor = new WebBeansInterceptor<T>(delegate);
        List<Annotation> anns = Arrays.asList(interceptorBindingTypes);
        for (Annotation ann : interceptorBindingTypes) {
            WebBeansInterceptorConfig.checkAnns(anns, ann, delegate);
            interceptor.addInterceptorBinding(ann.annotationType(), ann);
        }
        BeanManagerImpl.getManager().addInterceptor(interceptor);
    }

    private static void checkAnns(List<Annotation> list, Annotation ann, Bean<?> bean) {
        for (Annotation old : list) {
            if (!old.annotationType().equals(ann.annotationType()) || AnnotationUtil.hasAnnotationMember(ann.annotationType(), ann, old)) continue;
            throw new WebBeansConfigurationException("Interceptor Binding types must be equal for interceptor : " + bean);
        }
    }

    public static void configure(AbstractInjectionTargetBean<?> component, List<InterceptorData> stack) {
        Annotation[] stereoTypes;
        Class clazz = component.getReturnType();
        AnnotatedType<?> annotatedType = component.getAnnotatedType();
        Set annotations = null;
        if (annotatedType != null) {
            annotations = annotatedType.getAnnotations();
        }
        Set<Interceptor<?>> componentInterceptors = null;
        HashSet<Annotation> bindingTypeSet = new HashSet<Annotation>();
        Annotation[] anns = new Annotation[]{};
        Annotation[] typeAnns = null;
        typeAnns = annotations != null ? annotations.toArray(new Annotation[0]) : clazz.getDeclaredAnnotations();
        if (AnnotationUtil.hasInterceptorBindingMetaAnnotation(typeAnns)) {
            for (Annotation ann : anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(typeAnns)) {
                bindingTypeSet.add(ann);
            }
        }
        for (Annotation stero : stereoTypes = AnnotationUtil.getStereotypeMetaAnnotations(typeAnns)) {
            Annotation[] steroInterceptorBindings;
            if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
            for (Annotation ann : steroInterceptorBindings = AnnotationUtil.getInterceptorBindingMetaAnnotations(stero.annotationType().getDeclaredAnnotations())) {
                bindingTypeSet.add(ann);
            }
        }
        IBeanInheritedMetaData metadata = component.getInheritedMetaData();
        if (metadata != null) {
            Set<Annotation> inheritedStereotypes;
            Set<Annotation> inheritedBindingTypes = metadata.getInheritedInterceptorBindings();
            if (!inheritedBindingTypes.isEmpty()) {
                Annotation[] inheritedAnns = new Annotation[inheritedBindingTypes.size()];
                inheritedAnns = inheritedBindingTypes.toArray(inheritedAnns);
                anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(inheritedAnns);
                bindingTypeSet.addAll(Arrays.asList(anns));
            }
            if (!(inheritedStereotypes = metadata.getInheritedStereoTypes()).isEmpty()) {
                Annotation[] inherited = new Annotation[inheritedStereotypes.size()];
                inherited = inheritedStereotypes.toArray(inherited);
                Annotation[] transitiveStereotypes = AnnotationUtil.getStereotypeMetaAnnotations(inherited);
                for (Annotation stereo : transitiveStereotypes) {
                    Annotation[] steroInterceptorBindings;
                    if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(stereo.annotationType().getDeclaredAnnotations())) continue;
                    for (Annotation ann : steroInterceptorBindings = AnnotationUtil.getInterceptorBindingMetaAnnotations(stereo.annotationType().getDeclaredAnnotations())) {
                        bindingTypeSet.add(ann);
                    }
                }
            }
        }
        anns = new Annotation[bindingTypeSet.size()];
        anns = bindingTypeSet.toArray(anns);
        List<Annotation> beanAnnots = Arrays.asList(anns);
        for (Annotation checkAnn : anns) {
            WebBeansInterceptorConfig.checkAnns(beanAnnots, checkAnn, component);
        }
        if (anns.length > 0) {
            componentInterceptors = WebBeansInterceptorConfig.findDeployedWebBeansInterceptor(anns);
            WebBeansInterceptorConfig.addComponentInterceptors(componentInterceptors, stack);
        }
        if (annotatedType == null) {
            WebBeansInterceptorConfig.addMethodInterceptors(clazz, stack, componentInterceptors, bindingTypeSet);
        } else {
            WebBeansInterceptorConfig.addMethodInterceptors(annotatedType, stack, componentInterceptors);
        }
        Collections.sort(stack, new InterceptorDataComparator());
    }

    public static void addComponentInterceptors(Set<Interceptor<?>> set, List<InterceptorData> stack) {
        for (WebBeansInterceptor webBeansInterceptor : set) {
            AnnotatedType annotatedType = webBeansInterceptor.getAnnotatedType();
            if (annotatedType != null) {
                WebBeansUtil.configureInterceptorMethods(webBeansInterceptor, annotatedType, AroundInvoke.class, true, false, stack, null);
                WebBeansUtil.configureInterceptorMethods(webBeansInterceptor, annotatedType, PostConstruct.class, true, false, stack, null);
                WebBeansUtil.configureInterceptorMethods(webBeansInterceptor, annotatedType, PreDestroy.class, true, false, stack, null);
                continue;
            }
            WebBeansUtil.configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), AroundInvoke.class, true, false, stack, null, true);
            WebBeansUtil.configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), PostConstruct.class, true, false, stack, null, true);
            WebBeansUtil.configureInterceptorMethods(webBeansInterceptor, webBeansInterceptor.getClazz(), PreDestroy.class, true, false, stack, null, true);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void addMethodInterceptors(Class<?> clazz, List<InterceptorData> stack, Set<Interceptor<?>> componentInterceptors, Set<Annotation> resolvedComponentInterceptorBindings) {
        Method[] methods = clazz.getMethods();
        HashSet<Method> set = new HashSet<Method>();
        for (Method m : methods) {
            set.add(m);
        }
        for (Method m : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            set.add(m);
        }
        for (Method method : methods = set.toArray(new Method[0])) {
            HashSet<Annotation> interceptorAnns = new HashSet<Annotation>();
            if (AnnotationUtil.hasInterceptorBindingMetaAnnotation(method.getDeclaredAnnotations())) {
                Annotation[] anns;
                for (Annotation ann : anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(method.getAnnotations())) {
                    interceptorAnns.add(ann);
                }
            }
            interceptorAnns.addAll(resolvedComponentInterceptorBindings);
            if (interceptorAnns.isEmpty()) continue;
            Annotation[] result = new Annotation[interceptorAnns.size()];
            result = interceptorAnns.toArray(result);
            Set<Interceptor<Interceptor<?>>> setInterceptors = WebBeansInterceptorConfig.findDeployedWebBeansInterceptor(result);
            if (componentInterceptors != null) {
                setInterceptors.removeAll(componentInterceptors);
            }
            for (WebBeansInterceptor interceptor : setInterceptors) {
                WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), AroundInvoke.class, true, true, stack, method, true);
                WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), PostConstruct.class, true, true, stack, method, true);
                WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), PreDestroy.class, true, true, stack, method, true);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static <T> void addMethodInterceptors(AnnotatedType<T> annotatedType, List<InterceptorData> stack, Set<Interceptor<?>> componentInterceptors) {
        Set methods = annotatedType.getMethods();
        Iterator i$ = methods.iterator();
        while (i$.hasNext()) {
            Annotation[] stereoTypes;
            AnnotatedMethod methodA;
            AnnotatedMethod methodB = methodA = (AnnotatedMethod)i$.next();
            Method method = methodB.getJavaMember();
            HashSet<Annotation> interceptorAnns = new HashSet<Annotation>();
            Annotation[] methodAnns = AnnotationUtil.getAnnotationsFromSet(methodB.getAnnotations());
            if (AnnotationUtil.hasInterceptorBindingMetaAnnotation(methodAnns)) {
                Annotation[] anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(methodAnns);
                Annotation[] annsClazz = AnnotationUtil.getInterceptorBindingMetaAnnotations(AnnotationUtil.getAnnotationsFromSet(annotatedType.getAnnotations()));
                for (Annotation ann : anns) {
                    interceptorAnns.add(ann);
                }
                for (Annotation ann : annsClazz) {
                    interceptorAnns.add(ann);
                }
            }
            for (Annotation stero : stereoTypes = AnnotationUtil.getStereotypeMetaAnnotations(AnnotationUtil.getAnnotationsFromSet(annotatedType.getAnnotations()))) {
                Annotation[] steroInterceptorBindings;
                if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                for (Annotation ann : steroInterceptorBindings = AnnotationUtil.getInterceptorBindingMetaAnnotations(stero.annotationType().getDeclaredAnnotations())) {
                    interceptorAnns.add(ann);
                }
            }
            if (interceptorAnns.isEmpty()) continue;
            Annotation[] result = new Annotation[interceptorAnns.size()];
            result = interceptorAnns.toArray(result);
            Set<Interceptor<Interceptor<?>>> setInterceptors = WebBeansInterceptorConfig.findDeployedWebBeansInterceptor(result);
            if (componentInterceptors != null) {
                setInterceptors.removeAll(componentInterceptors);
            }
            for (WebBeansInterceptor interceptor : setInterceptors) {
                AnnotatedType interAnnoType = interceptor.getAnnotatedType();
                if (interAnnoType == null) {
                    WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), AroundInvoke.class, true, true, stack, method, true);
                    WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), PostConstruct.class, true, true, stack, method, true);
                    WebBeansUtil.configureInterceptorMethods(interceptor, interceptor.getClazz(), PreDestroy.class, true, true, stack, method, true);
                    continue;
                }
                WebBeansUtil.configureInterceptorMethods(interceptor, interAnnoType, AroundInvoke.class, true, true, stack, method);
                WebBeansUtil.configureInterceptorMethods(interceptor, interAnnoType, PostConstruct.class, true, true, stack, method);
                WebBeansUtil.configureInterceptorMethods(interceptor, interAnnoType, PreDestroy.class, true, true, stack, method);
            }
        }
    }

    private static Set<Interceptor<?>> getWebBeansInterceptors() {
        return Collections.unmodifiableSet(BeanManagerImpl.getManager().getInterceptors());
    }

    public static Set<Interceptor<?>> findDeployedWebBeansInterceptor(Annotation[] anns) {
        HashSet set = new HashSet();
        Iterator<Interceptor<?>> it = WebBeansInterceptorConfig.getWebBeansInterceptors().iterator();
        WebBeansInterceptor interceptor = null;
        ArrayList<Class<? extends Annotation>> bindingTypes = new ArrayList<Class<? extends Annotation>>();
        ArrayList<Annotation> listAnnot = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            bindingTypes.add(ann.annotationType());
            listAnnot.add(ann);
        }
        while (it.hasNext()) {
            interceptor = (WebBeansInterceptor)it.next();
            if (!interceptor.hasBinding(bindingTypes, listAnnot)) continue;
            set.add(interceptor);
            set.addAll(interceptor.getMetaInceptors());
        }
        return set;
    }
}

