/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class ResolutionUtil {
    private ResolutionUtil() {
    }

    public static boolean checkBeanTypeAssignableToGivenType(Set<Type> beanTypes, Type givenType, boolean newBean) {
        for (Type beanApiType : beanTypes) {
            Class<?> requiredType;
            if (ClassUtil.isAssignable(beanApiType, givenType)) {
                return true;
            }
            if (!newBean || !ClassUtil.isParametrizedType(givenType) || !ClassUtil.isClassAssignable(requiredType = ClassUtil.getClass(givenType), ClassUtil.getClass(beanApiType))) continue;
            return true;
        }
        return false;
    }

    public static void resolveByTypeConditions(ParameterizedType type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        boolean result = ClassUtil.checkParametrizedType(type);
        if (!result) {
            throw new IllegalArgumentException("Parametrized type : " + type + " can not contain type variable or wildcard type arguments");
        }
    }

    public static void getInstanceByTypeConditions(Annotation[] qualifiers) {
        AnnotationUtil.checkQualifierConditions(qualifiers);
    }

    public static void checkResolvedBeans(Set<Bean<?>> resolvedSet, Class<?> type, Annotation[] qualifiers) {
        ResolutionUtil.checkResolvedBeans(resolvedSet, type, qualifiers, null);
    }

    public static void checkResolvedBeans(Set<Bean<?>> resolvedSet, Class<?> type, Annotation[] qualifiers, InjectionPoint injectionPoint) {
        StringBuffer qualifierMessage = new StringBuffer("[");
        int i = 0;
        for (Annotation annot : qualifiers) {
            qualifierMessage.append(annot);
            if (++i == qualifiers.length) continue;
            qualifierMessage.append(",");
        }
        qualifierMessage.append("]");
        if (resolvedSet.isEmpty()) {
            StringBuffer message = new StringBuffer("Api type [" + type.getName() + "] is not found with the qualifiers ");
            message.append(qualifierMessage);
            if (injectionPoint != null) {
                message.append(" for injection into " + injectionPoint.toString());
            }
            throw new UnsatisfiedResolutionException(message.toString());
        }
        if (resolvedSet.size() > 1) {
            throw new AmbiguousResolutionException("There is more than one api type with : " + type.getName() + " with qualifiers : " + qualifierMessage);
        }
        Bean<?> bean = resolvedSet.iterator().next();
        WebBeansUtil.checkUnproxiableApiType(bean, bean.getScope());
    }
}

