/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.SecurityUtil;

public class OpenWebBeansConfiguration {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(OpenWebBeansConfiguration.class);
    private static final String DEFAULT_CONFIG_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans-default.properties";
    private static final String CONFIG_EE_COMMON_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans-ee-common.properties";
    private static final String CONFIG_EE_WEB_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans-ee-web.properties";
    private static final String CONFIG_JMS_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans-jms.properties";
    private static final String CONFIG_JSF_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans-jsf.properties";
    private static final String CONFIG_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans.properties";
    private Properties configProperties = new Properties();
    public static final String CONVERSATION_PERIODIC_DELAY = "org.apache.webbeans.conversation.Conversation.periodicDelay";
    @Deprecated
    public static final String USE_OWB_SPECIFIC_XML_CONFIGURATION = "org.apache.webbeans.useOwbSpecificXmlConfig";
    @Deprecated
    public static final String USE_OWB_SPECIFIC_FIELD_INJECTION = "org.apache.webbeans.fieldInjection.useOwbSpecificInjection";
    public static final String USE_EJB_DISCOVERY = "org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService";
    public static final String CONTAINER_LIFECYCLE = "org.apache.webbeans.spi.ContainerLifecycle";
    public static final String JNDI_SERVICE = "org.apache.webbeans.spi.JNDIService";
    public static final String SCANNER_SERVICE = "org.apache.webbeans.spi.ScannerService";
    public static final String CONTEXTS_SERVICE = "org.apache.webbeans.spi.ContextsService";
    public static final String CONVERSATION_SERVICE = "org.apache.webbeans.spi.ConversationService";
    public static final String RESOURCE_INJECTION_SERVICE = "org.apache.webbeans.spi.ResourceInjectionService";
    public static final String SECURITY_SERVICE = "org.apache.webbeans.spi.SecurityService";
    public static final String VALIDATOR_SERVICE = "org.apache.webbeans.spi.ValidatorService";
    public static final String TRANSACTION_SERVICE = "org.apache.webbeans.spi.TransactionService";
    public static final String APPLICATION_IS_JSP = "org.apache.webbeans.application.jsp";
    public static final String APPLICATION_SUPPORTS_CONVERSATION = "org.apache.webbeans.application.supportsConversation";
    public static final String USE_JSF2_EXTENSIONS = "org.apache.webbeans.application.useJSF2Extensions";
    public static final String USE_EJBINTERCEPTOR_INJECTION = "org.apache.webbeans.application.useEJBInterceptorInjection";
    public static final String EL_ADAPTOR_CLASS = "org.apache.webbeans.spi.adaptor.ELAdaptor";
    public static final String PROPERTY_OWB_APPLICATION = "org.apache.webbeans.application.isOwbApplication";

    public static OpenWebBeansConfiguration getInstance() {
        return (OpenWebBeansConfiguration)WebBeansFinder.getSingletonInstance(OpenWebBeansConfiguration.class.getName());
    }

    public OpenWebBeansConfiguration() {
        this.parseConfiguration();
        logger.debug("Overriden properties from System prpoerties");
        this.loadFromSystemProperties();
    }

    private void loadFromSystemProperties() {
        Properties properties = null;
        properties = System.getSecurityManager() != null ? SecurityUtil.doPrivilegedGetSystemProperties() : System.getProperties();
        String value = properties.getProperty(CONVERSATION_PERIODIC_DELAY);
        this.setPropertyFromSystemProperty(CONVERSATION_PERIODIC_DELAY, value);
        value = properties.getProperty(USE_EJB_DISCOVERY);
        this.setPropertyFromSystemProperty(USE_EJB_DISCOVERY, value);
        value = properties.getProperty(USE_EJBINTERCEPTOR_INJECTION);
        this.setPropertyFromSystemProperty(USE_EJBINTERCEPTOR_INJECTION, value);
        value = properties.getProperty(CONTAINER_LIFECYCLE);
        this.setPropertyFromSystemProperty(CONTAINER_LIFECYCLE, value);
        value = properties.getProperty(USE_JSF2_EXTENSIONS);
        this.setPropertyFromSystemProperty(USE_JSF2_EXTENSIONS, value);
        value = properties.getProperty(APPLICATION_IS_JSP);
        this.setPropertyFromSystemProperty(APPLICATION_IS_JSP, value);
        value = properties.getProperty(TRANSACTION_SERVICE);
        this.setPropertyFromSystemProperty(TRANSACTION_SERVICE, value);
        value = properties.getProperty(VALIDATOR_SERVICE);
        this.setPropertyFromSystemProperty(VALIDATOR_SERVICE, value);
        value = properties.getProperty(SECURITY_SERVICE);
        this.setPropertyFromSystemProperty(SECURITY_SERVICE, value);
        value = properties.getProperty(RESOURCE_INJECTION_SERVICE);
        this.setPropertyFromSystemProperty(RESOURCE_INJECTION_SERVICE, value);
        value = properties.getProperty(CONVERSATION_SERVICE);
        this.setPropertyFromSystemProperty(CONVERSATION_SERVICE, value);
        value = properties.getProperty(CONTEXTS_SERVICE);
        this.setPropertyFromSystemProperty(CONTEXTS_SERVICE, value);
        value = properties.getProperty(SCANNER_SERVICE);
        this.setPropertyFromSystemProperty(SCANNER_SERVICE, value);
        value = properties.getProperty(JNDI_SERVICE);
        this.setPropertyFromSystemProperty(JNDI_SERVICE, value);
        value = properties.getProperty(EL_ADAPTOR_CLASS);
        this.setPropertyFromSystemProperty(EL_ADAPTOR_CLASS, value);
    }

    private void setPropertyFromSystemProperty(String key, String value) {
        if (value != null) {
            this.setProperty(key, value);
        }
    }

    public synchronized void parseConfiguration() throws WebBeansConfigurationException {
        Properties newConfigProperties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream(DEFAULT_CONFIG_PROPERTIES_NAME);
        this.load(is, newConfigProperties);
        is = loader.getResourceAsStream(CONFIG_JMS_PROPERTIES_NAME);
        this.load(is, newConfigProperties);
        is = loader.getResourceAsStream(CONFIG_JSF_PROPERTIES_NAME);
        this.load(is, newConfigProperties);
        is = loader.getResourceAsStream(CONFIG_EE_COMMON_PROPERTIES_NAME);
        this.load(is, newConfigProperties);
        is = loader.getResourceAsStream(CONFIG_EE_WEB_PROPERTIES_NAME);
        this.load(is, newConfigProperties);
        URL configUrl = loader.getResource(CONFIG_PROPERTIES_NAME);
        if (configUrl == null) {
            logger.info("TEXT_CONFIG_NOT_FOUND", CONFIG_PROPERTIES_NAME);
        } else {
            logger.info("TEXT_CONFIG_FOUND", CONFIG_PROPERTIES_NAME, configUrl);
            is = loader.getResourceAsStream(CONFIG_PROPERTIES_NAME);
            this.load(is, newConfigProperties);
        }
        this.configProperties = newConfigProperties;
    }

    private void load(InputStream is, Properties newConfigProperties) {
        try {
            if (is != null) {
                newConfigProperties.load(is);
            }
        }
        catch (IOException ioEx) {
            throw new WebBeansConfigurationException(logger.getTokenString("CRITICAL_DEFAULT_CONFIG_FAILURE"), ioEx);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String getProperty(String key) {
        return this.configProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.configProperties.getProperty(key, defaultValue);
    }

    public synchronized void setProperty(String key, Object value) {
        this.configProperties.put(key, value);
    }

    public boolean isOwbSpecificFieldInjection() {
        String value = this.getProperty(USE_OWB_SPECIFIC_FIELD_INJECTION);
        return Boolean.valueOf(value);
    }

    public boolean isUseJSF2Extensions() {
        String value = this.getProperty(USE_JSF2_EXTENSIONS);
        return Boolean.valueOf(value);
    }

    public boolean isJspApplication() {
        String value = this.getProperty(APPLICATION_IS_JSP);
        return Boolean.valueOf(value);
    }

    public boolean supportsConversation() {
        String value = this.getProperty(APPLICATION_SUPPORTS_CONVERSATION);
        return Boolean.valueOf(value);
    }

    public boolean isUseEJBInterceptorInjection() {
        String value = this.getProperty(USE_EJBINTERCEPTOR_INJECTION);
        return Boolean.valueOf(value);
    }
}

