/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.boot;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.webbeans.lifecycle.LifecycleFactory;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContainerLifecycle;

public class Bootstrap {
    private static final WebBeansLogger log = WebBeansLogger.getLogger(Bootstrap.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private ContainerLifecycle containerLifecycle = null;
    private Properties properties = null;

    public void init(Properties properties) {
        log.info("INFO_0006");
        this.containerLifecycle = LifecycleFactory.getInstance().getLifecycle();
    }

    public void start() throws Exception {
        log.info("INFO_0005");
        long begin = System.currentTimeMillis();
        this.containerLifecycle.startApplication((Object)this.properties);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Bootstrap.this.latch.countDown();
            }
        });
        log.info("INFO_0001", Long.toString(System.currentTimeMillis() - begin));
        this.latch.await();
        log.info("INFO_0008");
        this.containerLifecycle.stopApplication((Object)this.properties);
        log.info("INFO_0009");
    }

    public static void main(String[] args) throws Exception {
        Bootstrap boot = new Bootstrap();
        boot.init(System.getProperties());
    }
}

