/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.portable.AbstractAnnotated;

class AnnotatedTypeImpl<X>
extends AbstractAnnotated
implements AnnotatedType<X> {
    private Class<X> annotatedClass;
    private Set<AnnotatedConstructor<X>> constructors = new HashSet<AnnotatedConstructor<X>>();
    private Set<AnnotatedField<? super X>> fields = new HashSet<AnnotatedField<? super X>>();
    private Set<AnnotatedMethod<? super X>> methods = new HashSet<AnnotatedMethod<? super X>>();

    AnnotatedTypeImpl(Class<X> annotatedClass) {
        super(annotatedClass);
        this.annotatedClass = annotatedClass;
        this.setAnnotations(annotatedClass.getDeclaredAnnotations());
    }

    void addAnnotatedConstructor(AnnotatedConstructor<X> constructor) {
        this.constructors.add(constructor);
    }

    void addAnnotatedField(AnnotatedField<? super X> field) {
        this.fields.add(field);
    }

    void addAnnotatedMethod(AnnotatedMethod<? super X> method) {
        this.methods.add(method);
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Class<X> getJavaClass() {
        return this.annotatedClass;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }
}

