/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jms;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

public class JMSModel {
    private JMSType jmsType;
    private String jndiName;
    private String mappedName;
    private boolean isJndiNameDefined;
    private Set<Annotation> bindings = new HashSet<Annotation>();

    public JMSModel(JMSType jmsType, String jndiName, String mappedName) {
        this.jmsType = jmsType;
        if (jndiName != null) {
            this.jndiName = jndiName;
            this.isJndiNameDefined = true;
        }
        this.mappedName = mappedName;
    }

    public void addBinding(Annotation annotation) {
        this.bindings.add(annotation);
    }

    public Annotation[] getBindings() {
        return this.bindings.toArray(new Annotation[0]);
    }

    public JMSType getJmsType() {
        return this.jmsType;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public boolean isJndiNameDefined() {
        return this.isJndiNameDefined;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bindings == null ? 0 : ((Object)this.bindings).hashCode());
        result = 31 * result + (this.jmsType == null ? 0 : this.jmsType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JMSModel other = (JMSModel)obj;
        if (this.bindings == null ? other.bindings != null : !((Object)this.bindings).equals(other.bindings)) {
            return false;
        }
        return !(this.jmsType == null ? other.jmsType != null : !this.jmsType.equals((Object)other.jmsType));
    }

    public static enum JMSType {
        QUEUE,
        TOPIC;

    }
}

