/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.apache.webbeans.annotation.NamedLiteral;
import org.apache.webbeans.inject.impl.InjectionPointImpl;
import org.apache.webbeans.inject.xml.XMLInjectionModelType;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

public class InjectionPointFactory {
    public static InjectionPoint getXMLInjectionPointData(Bean<?> owner, XMLInjectionPointModel xmlInjectionModel) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(xmlInjectionModel, "xmlInjectionModel parameter can not be null");
        InjectionPoint injectionPoint = null;
        Set<Annotation> setAnns = xmlInjectionModel.getAnnotations();
        Annotation[] anns = new Annotation[setAnns.size()];
        anns = setAnns.toArray(anns);
        boolean available = true;
        if (xmlInjectionModel.getType().equals((Object)XMLInjectionModelType.FIELD)) {
            if (InjectionPointFactory.checkFieldApplicable(anns)) {
                available = false;
            }
        } else if (xmlInjectionModel.getType().equals((Object)XMLInjectionModelType.METHOD) && InjectionPointFactory.checkMethodApplicable(anns)) {
            available = false;
        }
        if (available) {
            injectionPoint = InjectionPointFactory.getGenericInjectionPoint(owner, anns, xmlInjectionModel.getInjectionGenericType(), xmlInjectionModel.getInjectionMember(), null);
        }
        return injectionPoint;
    }

    public static InjectionPoint getFieldInjectionPointData(Bean<?> owner, Field member) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(member, "member parameter can not be null");
        Annotation[] annots = null;
        annots = member.getAnnotations();
        if (!InjectionPointFactory.checkFieldApplicable(annots)) {
            return InjectionPointFactory.getGenericInjectionPoint(owner, annots, member.getGenericType(), member, AnnotatedElementFactory.newAnnotatedField(member, member.getDeclaringClass()));
        }
        return null;
    }

    public static <X> InjectionPoint getFieldInjectionPointData(Bean<?> owner, AnnotatedField<X> annotField) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(annotField, "annotField parameter can not be null");
        Field member = annotField.getJavaMember();
        Annotation[] annots = AnnotationUtil.getAnnotationsFromSet(annotField.getAnnotations());
        if (!InjectionPointFactory.checkFieldApplicable(annots)) {
            return InjectionPointFactory.getGenericInjectionPoint(owner, annots, annotField.getBaseType(), member, annotField);
        }
        return null;
    }

    private static boolean checkFieldApplicable(Annotation[] anns) {
        return false;
    }

    private static InjectionPoint getGenericInjectionPoint(Bean<?> owner, Annotation[] annots, Type type, Member member, Annotated annotated) {
        InjectionPointImpl injectionPoint = null;
        Annotation[] qualifierAnnots = AnnotationUtil.getQualifierAnnotations(annots);
        if (member instanceof Field) {
            for (int i = 0; i < qualifierAnnots.length; ++i) {
                Annotation qualifier = qualifierAnnots[i];
                if (!qualifier.annotationType().equals(Named.class)) continue;
                Named named = (Named)qualifier;
                String value = named.value();
                if (value != null && !value.equals("")) break;
                NamedLiteral namedLiteral = new NamedLiteral();
                namedLiteral.setValue(member.getName());
                qualifierAnnots[i] = namedLiteral;
                break;
            }
        }
        injectionPoint = new InjectionPointImpl(owner, type, member, annotated);
        if (AnnotationUtil.hasAnnotation(annots, Delegate.class)) {
            injectionPoint.setDelegate(true);
        }
        if (Modifier.isTransient(member.getModifiers())) {
            injectionPoint.setTransient(true);
        }
        InjectionPointFactory.addAnnotation(injectionPoint, qualifierAnnots, true);
        return injectionPoint;
    }

    public static List<InjectionPoint> getMethodInjectionPointData(Bean<?> owner, Method member) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(member, "member parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        AnnotatedMethod<?> method = AnnotatedElementFactory.newAnnotatedMethod(member, member.getDeclaringClass());
        List parameters = method.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.getAnnotation(Observes.class) != null) continue;
            point = InjectionPointFactory.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), member, (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    public static <X> List<InjectionPoint> getMethodInjectionPointData(Bean<?> owner, AnnotatedMethod<X> method) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(method, "method parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        List parameters = method.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.getAnnotation(Observes.class) != null) continue;
            point = InjectionPointFactory.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), method.getJavaMember(), (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    private static boolean checkMethodApplicable(Annotation[] annot) {
        for (Annotation observersAnnot : annot) {
            if (!observersAnnot.annotationType().equals(Observes.class)) continue;
            return true;
        }
        return false;
    }

    public static InjectionPoint getPartialInjectionPoint(Bean<?> owner, Type type, Member member, Annotated annotated, Annotation ... bindings) {
        InjectionPointImpl impl = new InjectionPointImpl(owner, type, member, annotated);
        for (Annotation annot : bindings) {
            impl.addBindingAnnotation(annot);
        }
        return impl;
    }

    public static <T> List<InjectionPoint> getConstructorInjectionPointData(Bean<T> owner, AnnotatedConstructor<T> constructor) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(constructor, "constructor parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        List parameters = constructor.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            point = InjectionPointFactory.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), constructor.getJavaMember(), (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    public static List<InjectionPoint> getConstructorInjectionPointData(Bean<?> owner, Constructor<?> member) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(member, "member parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        AnnotatedConstructor<?> constructor = AnnotatedElementFactory.newAnnotatedConstructor(member);
        List parameters = constructor.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            point = InjectionPointFactory.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), member, (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    private static void addAnnotation(InjectionPointImpl impl, Annotation[] annots, boolean isBinding) {
        for (Annotation ann : annots) {
            if (!isBinding) continue;
            impl.addBindingAnnotation(ann);
        }
    }
}

