/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;

public class EventImpl<T>
implements Event<T>,
Serializable {
    private static final long serialVersionUID = -9035218380365451350L;
    private Annotation[] injectedBindings;
    private Type eventType;
    private transient BeanManagerImpl manager = null;

    public EventImpl(Annotation[] injectedBindings, Type eventType) {
        this.injectedBindings = injectedBindings;
        this.eventType = eventType;
        this.manager = BeanManagerImpl.getManager();
    }

    public void fire(T event) {
        this.manager.fireEvent(event, this.injectedBindings);
    }

    private Annotation[] getEventBindings(Annotation ... annotations) {
        AnnotationUtil.checkQualifierConditions(annotations);
        HashSet<Annotation> eventBindings = new HashSet<Annotation>();
        for (Annotation ann : this.injectedBindings) {
            eventBindings.add(ann);
        }
        Annotation[] anns = null;
        for (Annotation binding : annotations) {
            eventBindings.add(binding);
        }
        anns = new Annotation[eventBindings.size()];
        anns = eventBindings.toArray(anns);
        return anns;
    }

    public Event<T> select(Annotation ... bindings) {
        EventImpl<T> sub = new EventImpl<T>(this.getEventBindings(bindings), this.eventType);
        return sub;
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... bindings) {
        if (ClassUtil.isDefinitionConstainsTypeVariables(subtype)) {
            throw new IllegalArgumentException("Class : " + subtype + " cannot contain type variable");
        }
        Type sub = subtype;
        if (sub == null) {
            sub = this.eventType;
        }
        EventImpl<T> subEvent = new EventImpl<T>(this.getEventBindings(bindings), sub);
        return subEvent;
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        return this.select(subtype.getRawType(), bindings);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.manager = BeanManagerImpl.getManager();
    }
}

